/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.model.AnalysisSummary;
import software.amazon.awssdk.services.quicksight.model.SearchAnalysesRequest;
import software.amazon.awssdk.services.quicksight.model.SearchAnalysesResponse;

public class SearchAnalysesPublisher
implements SdkPublisher<SearchAnalysesResponse> {
    private final QuickSightAsyncClient client;
    private final SearchAnalysesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchAnalysesPublisher(QuickSightAsyncClient client, SearchAnalysesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchAnalysesPublisher(QuickSightAsyncClient client, SearchAnalysesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchAnalysesResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchAnalysesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AnalysisSummary> analysisSummaryList() {
        Function<SearchAnalysesResponse, Iterator> getIterator = response -> {
            if (response != null && response.analysisSummaryList() != null) {
                return response.analysisSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new SearchAnalysesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class SearchAnalysesResponseFetcher
    implements AsyncPageFetcher<SearchAnalysesResponse> {
        private SearchAnalysesResponseFetcher() {
        }

        public boolean hasNextPage(SearchAnalysesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchAnalysesResponse> nextPage(SearchAnalysesResponse previousPage) {
            if (previousPage == null) {
                return SearchAnalysesPublisher.this.client.searchAnalyses(SearchAnalysesPublisher.this.firstRequest);
            }
            return SearchAnalysesPublisher.this.client.searchAnalyses((SearchAnalysesRequest)((Object)SearchAnalysesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

