/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AnalysisError;
import software.amazon.awssdk.services.quicksight.model.AnalysisErrorListCopier;
import software.amazon.awssdk.services.quicksight.model.DataSetArnsListCopier;
import software.amazon.awssdk.services.quicksight.model.ResourceStatus;
import software.amazon.awssdk.services.quicksight.model.Sheet;
import software.amazon.awssdk.services.quicksight.model.SheetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Analysis
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Analysis> {
    private static final SdkField<String> ANALYSIS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisId").getter(Analysis.getter(Analysis::analysisId)).setter(Analysis.setter(Builder::analysisId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Analysis.getter(Analysis::arn)).setter(Analysis.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Analysis.getter(Analysis::name)).setter(Analysis.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Analysis.getter(Analysis::statusAsString)).setter(Analysis.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<AnalysisError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Errors").getter(Analysis.getter(Analysis::errors)).setter(Analysis.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalysisError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DATA_SET_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataSetArns").getter(Analysis.getter(Analysis::dataSetArns)).setter(Analysis.setter(Builder::dataSetArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> THEME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThemeArn").getter(Analysis.getter(Analysis::themeArn)).setter(Analysis.setter(Builder::themeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeArn").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(Analysis.getter(Analysis::createdTime)).setter(Analysis.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(Analysis.getter(Analysis::lastUpdatedTime)).setter(Analysis.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<List<Sheet>> SHEETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sheets").getter(Analysis.getter(Analysis::sheets)).setter(Analysis.setter(Builder::sheets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sheets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Sheet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_ID_FIELD, ARN_FIELD, NAME_FIELD, STATUS_FIELD, ERRORS_FIELD, DATA_SET_ARNS_FIELD, THEME_ARN_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, SHEETS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String analysisId;
    private final String arn;
    private final String name;
    private final String status;
    private final List<AnalysisError> errors;
    private final List<String> dataSetArns;
    private final String themeArn;
    private final Instant createdTime;
    private final Instant lastUpdatedTime;
    private final List<Sheet> sheets;

    private Analysis(BuilderImpl builder) {
        this.analysisId = builder.analysisId;
        this.arn = builder.arn;
        this.name = builder.name;
        this.status = builder.status;
        this.errors = builder.errors;
        this.dataSetArns = builder.dataSetArns;
        this.themeArn = builder.themeArn;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.sheets = builder.sheets;
    }

    public final String analysisId() {
        return this.analysisId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final ResourceStatus status() {
        return ResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<AnalysisError> errors() {
        return this.errors;
    }

    public final boolean hasDataSetArns() {
        return this.dataSetArns != null && !(this.dataSetArns instanceof SdkAutoConstructList);
    }

    public final List<String> dataSetArns() {
        return this.dataSetArns;
    }

    public final String themeArn() {
        return this.themeArn;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final boolean hasSheets() {
        return this.sheets != null && !(this.sheets instanceof SdkAutoConstructList);
    }

    public final List<Sheet> sheets() {
        return this.sheets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSetArns() ? this.dataSetArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.themeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSheets() ? this.sheets() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Analysis)) {
            return false;
        }
        Analysis other = (Analysis)obj;
        return Objects.equals(this.analysisId(), other.analysisId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors()) && this.hasDataSetArns() == other.hasDataSetArns() && Objects.equals(this.dataSetArns(), other.dataSetArns()) && Objects.equals(this.themeArn(), other.themeArn()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && this.hasSheets() == other.hasSheets() && Objects.equals(this.sheets(), other.sheets());
    }

    public final String toString() {
        return ToString.builder((String)"Analysis").add("AnalysisId", (Object)this.analysisId()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("Errors", this.hasErrors() ? this.errors() : null).add("DataSetArns", this.hasDataSetArns() ? this.dataSetArns() : null).add("ThemeArn", (Object)this.themeArn()).add("CreatedTime", (Object)this.createdTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("Sheets", this.hasSheets() ? this.sheets() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnalysisId": {
                return Optional.ofNullable(clazz.cast(this.analysisId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
            case "DataSetArns": {
                return Optional.ofNullable(clazz.cast(this.dataSetArns()));
            }
            case "ThemeArn": {
                return Optional.ofNullable(clazz.cast(this.themeArn()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "Sheets": {
                return Optional.ofNullable(clazz.cast(this.sheets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Analysis, T> g) {
        return obj -> g.apply((Analysis)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String analysisId;
        private String arn;
        private String name;
        private String status;
        private List<AnalysisError> errors = DefaultSdkAutoConstructList.getInstance();
        private List<String> dataSetArns = DefaultSdkAutoConstructList.getInstance();
        private String themeArn;
        private Instant createdTime;
        private Instant lastUpdatedTime;
        private List<Sheet> sheets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Analysis model) {
            this.analysisId(model.analysisId);
            this.arn(model.arn);
            this.name(model.name);
            this.status(model.status);
            this.errors(model.errors);
            this.dataSetArns(model.dataSetArns);
            this.themeArn(model.themeArn);
            this.createdTime(model.createdTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.sheets(model.sheets);
        }

        public final String getAnalysisId() {
            return this.analysisId;
        }

        public final void setAnalysisId(String analysisId) {
            this.analysisId = analysisId;
        }

        @Override
        public final Builder analysisId(String analysisId) {
            this.analysisId = analysisId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<AnalysisError.Builder> getErrors() {
            List<AnalysisError.Builder> result = AnalysisErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<AnalysisError.BuilderImpl> errors) {
            this.errors = AnalysisErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<AnalysisError> errors) {
            this.errors = AnalysisErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(AnalysisError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<AnalysisError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (AnalysisError)((AnalysisError.Builder)AnalysisError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getDataSetArns() {
            if (this.dataSetArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dataSetArns;
        }

        public final void setDataSetArns(Collection<String> dataSetArns) {
            this.dataSetArns = DataSetArnsListCopier.copy(dataSetArns);
        }

        @Override
        public final Builder dataSetArns(Collection<String> dataSetArns) {
            this.dataSetArns = DataSetArnsListCopier.copy(dataSetArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetArns(String ... dataSetArns) {
            this.dataSetArns(Arrays.asList(dataSetArns));
            return this;
        }

        public final String getThemeArn() {
            return this.themeArn;
        }

        public final void setThemeArn(String themeArn) {
            this.themeArn = themeArn;
        }

        @Override
        public final Builder themeArn(String themeArn) {
            this.themeArn = themeArn;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final List<Sheet.Builder> getSheets() {
            List<Sheet.Builder> result = SheetListCopier.copyToBuilder(this.sheets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSheets(Collection<Sheet.BuilderImpl> sheets) {
            this.sheets = SheetListCopier.copyFromBuilder(sheets);
        }

        @Override
        public final Builder sheets(Collection<Sheet> sheets) {
            this.sheets = SheetListCopier.copy(sheets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheets(Sheet ... sheets) {
            this.sheets(Arrays.asList(sheets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sheets(Consumer<Sheet.Builder> ... sheets) {
            this.sheets(Stream.of(sheets).map(c -> (Sheet)((Sheet.Builder)Sheet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Analysis build() {
            return new Analysis(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Analysis> {
        public Builder analysisId(String var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(ResourceStatus var1);

        public Builder errors(Collection<AnalysisError> var1);

        public Builder errors(AnalysisError ... var1);

        public Builder errors(Consumer<AnalysisError.Builder> ... var1);

        public Builder dataSetArns(Collection<String> var1);

        public Builder dataSetArns(String ... var1);

        public Builder themeArn(String var1);

        public Builder createdTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder sheets(Collection<Sheet> var1);

        public Builder sheets(Sheet ... var1);

        public Builder sheets(Consumer<Sheet.Builder> ... var1);
    }
}

