/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.model.AnalysisSummary;
import software.amazon.awssdk.services.quicksight.model.SearchAnalysesRequest;
import software.amazon.awssdk.services.quicksight.model.SearchAnalysesResponse;

public class SearchAnalysesIterable
implements SdkIterable<SearchAnalysesResponse> {
    private final QuickSightClient client;
    private final SearchAnalysesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchAnalysesIterable(QuickSightClient client, SearchAnalysesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchAnalysesResponseFetcher();
    }

    public Iterator<SearchAnalysesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AnalysisSummary> analysisSummaryList() {
        Function<SearchAnalysesResponse, Iterator> getIterator = response -> {
            if (response != null && response.analysisSummaryList() != null) {
                return response.analysisSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchAnalysesResponseFetcher
    implements SyncPageFetcher<SearchAnalysesResponse> {
        private SearchAnalysesResponseFetcher() {
        }

        public boolean hasNextPage(SearchAnalysesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchAnalysesResponse nextPage(SearchAnalysesResponse previousPage) {
            if (previousPage == null) {
                return SearchAnalysesIterable.this.client.searchAnalyses(SearchAnalysesIterable.this.firstRequest);
            }
            return SearchAnalysesIterable.this.client.searchAnalyses((SearchAnalysesRequest)((Object)SearchAnalysesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

