/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ResourcePermission;
import software.amazon.awssdk.services.quicksight.model.ResourcePermissionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LinkSharingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LinkSharingConfiguration> {
    private static final SdkField<List<ResourcePermission>> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Permissions").getter(LinkSharingConfiguration.getter(LinkSharingConfiguration::permissions)).setter(LinkSharingConfiguration.setter(Builder::permissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcePermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ResourcePermission> permissions;

    private LinkSharingConfiguration(BuilderImpl builder) {
        this.permissions = builder.permissions;
    }

    public final boolean hasPermissions() {
        return this.permissions != null && !(this.permissions instanceof SdkAutoConstructList);
    }

    public final List<ResourcePermission> permissions() {
        return this.permissions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissions() ? this.permissions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LinkSharingConfiguration)) {
            return false;
        }
        LinkSharingConfiguration other = (LinkSharingConfiguration)obj;
        return this.hasPermissions() == other.hasPermissions() && Objects.equals(this.permissions(), other.permissions());
    }

    public final String toString() {
        return ToString.builder((String)"LinkSharingConfiguration").add("Permissions", this.hasPermissions() ? this.permissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LinkSharingConfiguration, T> g) {
        return obj -> g.apply((LinkSharingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ResourcePermission> permissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LinkSharingConfiguration model) {
            this.permissions(model.permissions);
        }

        public final List<ResourcePermission.Builder> getPermissions() {
            List<ResourcePermission.Builder> result = ResourcePermissionListCopier.copyToBuilder(this.permissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermissions(Collection<ResourcePermission.BuilderImpl> permissions) {
            this.permissions = ResourcePermissionListCopier.copyFromBuilder(permissions);
        }

        @Override
        @Transient
        public final Builder permissions(Collection<ResourcePermission> permissions) {
            this.permissions = ResourcePermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder permissions(ResourcePermission ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder permissions(Consumer<ResourcePermission.Builder> ... permissions) {
            this.permissions(Stream.of(permissions).map(c -> (ResourcePermission)((ResourcePermission.Builder)ResourcePermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LinkSharingConfiguration build() {
            return new LinkSharingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LinkSharingConfiguration> {
        public Builder permissions(Collection<ResourcePermission> var1);

        public Builder permissions(ResourcePermission ... var1);

        public Builder permissions(Consumer<ResourcePermission.Builder> ... var1);
    }
}

