/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ResourceStatus {
    CREATION_IN_PROGRESS("CREATION_IN_PROGRESS"),
    CREATION_SUCCESSFUL("CREATION_SUCCESSFUL"),
    CREATION_FAILED("CREATION_FAILED"),
    UPDATE_IN_PROGRESS("UPDATE_IN_PROGRESS"),
    UPDATE_SUCCESSFUL("UPDATE_SUCCESSFUL"),
    UPDATE_FAILED("UPDATE_FAILED"),
    DELETED("DELETED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ResourceStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ResourceStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceStatus> knownValues() {
        return Stream.of(ResourceStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

