/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AdHocFilteringOption;
import software.amazon.awssdk.services.quicksight.model.ExportToCSVOption;
import software.amazon.awssdk.services.quicksight.model.SheetControlsOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DashboardPublishOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DashboardPublishOptions> {
    private static final SdkField<AdHocFilteringOption> AD_HOC_FILTERING_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdHocFilteringOption").getter(DashboardPublishOptions.getter(DashboardPublishOptions::adHocFilteringOption)).setter(DashboardPublishOptions.setter(Builder::adHocFilteringOption)).constructor(AdHocFilteringOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdHocFilteringOption").build()}).build();
    private static final SdkField<ExportToCSVOption> EXPORT_TO_CSV_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ExportToCSVOption").getter(DashboardPublishOptions.getter(DashboardPublishOptions::exportToCSVOption)).setter(DashboardPublishOptions.setter(Builder::exportToCSVOption)).constructor(ExportToCSVOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportToCSVOption").build()}).build();
    private static final SdkField<SheetControlsOption> SHEET_CONTROLS_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SheetControlsOption").getter(DashboardPublishOptions.getter(DashboardPublishOptions::sheetControlsOption)).setter(DashboardPublishOptions.setter(Builder::sheetControlsOption)).constructor(SheetControlsOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetControlsOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_HOC_FILTERING_OPTION_FIELD, EXPORT_TO_CSV_OPTION_FIELD, SHEET_CONTROLS_OPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final AdHocFilteringOption adHocFilteringOption;
    private final ExportToCSVOption exportToCSVOption;
    private final SheetControlsOption sheetControlsOption;

    private DashboardPublishOptions(BuilderImpl builder) {
        this.adHocFilteringOption = builder.adHocFilteringOption;
        this.exportToCSVOption = builder.exportToCSVOption;
        this.sheetControlsOption = builder.sheetControlsOption;
    }

    public final AdHocFilteringOption adHocFilteringOption() {
        return this.adHocFilteringOption;
    }

    public final ExportToCSVOption exportToCSVOption() {
        return this.exportToCSVOption;
    }

    public final SheetControlsOption sheetControlsOption() {
        return this.sheetControlsOption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adHocFilteringOption());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportToCSVOption());
        hashCode = 31 * hashCode + Objects.hashCode(this.sheetControlsOption());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardPublishOptions)) {
            return false;
        }
        DashboardPublishOptions other = (DashboardPublishOptions)obj;
        return Objects.equals(this.adHocFilteringOption(), other.adHocFilteringOption()) && Objects.equals(this.exportToCSVOption(), other.exportToCSVOption()) && Objects.equals(this.sheetControlsOption(), other.sheetControlsOption());
    }

    public final String toString() {
        return ToString.builder((String)"DashboardPublishOptions").add("AdHocFilteringOption", (Object)this.adHocFilteringOption()).add("ExportToCSVOption", (Object)this.exportToCSVOption()).add("SheetControlsOption", (Object)this.sheetControlsOption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdHocFilteringOption": {
                return Optional.ofNullable(clazz.cast(this.adHocFilteringOption()));
            }
            case "ExportToCSVOption": {
                return Optional.ofNullable(clazz.cast(this.exportToCSVOption()));
            }
            case "SheetControlsOption": {
                return Optional.ofNullable(clazz.cast(this.sheetControlsOption()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashboardPublishOptions, T> g) {
        return obj -> g.apply((DashboardPublishOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AdHocFilteringOption adHocFilteringOption;
        private ExportToCSVOption exportToCSVOption;
        private SheetControlsOption sheetControlsOption;

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardPublishOptions model) {
            this.adHocFilteringOption(model.adHocFilteringOption);
            this.exportToCSVOption(model.exportToCSVOption);
            this.sheetControlsOption(model.sheetControlsOption);
        }

        public final AdHocFilteringOption.Builder getAdHocFilteringOption() {
            return this.adHocFilteringOption != null ? this.adHocFilteringOption.toBuilder() : null;
        }

        public final void setAdHocFilteringOption(AdHocFilteringOption.BuilderImpl adHocFilteringOption) {
            this.adHocFilteringOption = adHocFilteringOption != null ? adHocFilteringOption.build() : null;
        }

        @Override
        public final Builder adHocFilteringOption(AdHocFilteringOption adHocFilteringOption) {
            this.adHocFilteringOption = adHocFilteringOption;
            return this;
        }

        public final ExportToCSVOption.Builder getExportToCSVOption() {
            return this.exportToCSVOption != null ? this.exportToCSVOption.toBuilder() : null;
        }

        public final void setExportToCSVOption(ExportToCSVOption.BuilderImpl exportToCSVOption) {
            this.exportToCSVOption = exportToCSVOption != null ? exportToCSVOption.build() : null;
        }

        @Override
        public final Builder exportToCSVOption(ExportToCSVOption exportToCSVOption) {
            this.exportToCSVOption = exportToCSVOption;
            return this;
        }

        public final SheetControlsOption.Builder getSheetControlsOption() {
            return this.sheetControlsOption != null ? this.sheetControlsOption.toBuilder() : null;
        }

        public final void setSheetControlsOption(SheetControlsOption.BuilderImpl sheetControlsOption) {
            this.sheetControlsOption = sheetControlsOption != null ? sheetControlsOption.build() : null;
        }

        @Override
        public final Builder sheetControlsOption(SheetControlsOption sheetControlsOption) {
            this.sheetControlsOption = sheetControlsOption;
            return this;
        }

        public DashboardPublishOptions build() {
            return new DashboardPublishOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DashboardPublishOptions> {
        public Builder adHocFilteringOption(AdHocFilteringOption var1);

        default public Builder adHocFilteringOption(Consumer<AdHocFilteringOption.Builder> adHocFilteringOption) {
            return this.adHocFilteringOption((AdHocFilteringOption)((AdHocFilteringOption.Builder)AdHocFilteringOption.builder().applyMutation(adHocFilteringOption)).build());
        }

        public Builder exportToCSVOption(ExportToCSVOption var1);

        default public Builder exportToCSVOption(Consumer<ExportToCSVOption.Builder> exportToCSVOption) {
            return this.exportToCSVOption((ExportToCSVOption)((ExportToCSVOption.Builder)ExportToCSVOption.builder().applyMutation(exportToCSVOption)).build());
        }

        public Builder sheetControlsOption(SheetControlsOption var1);

        default public Builder sheetControlsOption(Consumer<SheetControlsOption.Builder> sheetControlsOption) {
            return this.sheetControlsOption((SheetControlsOption)((SheetControlsOption.Builder)SheetControlsOption.builder().applyMutation(sheetControlsOption)).build());
        }
    }
}

