/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.quicksight.model.AssignmentStatus;
import software.amazon.awssdk.services.quicksight.model.IdentityMapCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIamPolicyAssignmentResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, CreateIamPolicyAssignmentResponse> {
    private static final SdkField<String> ASSIGNMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssignmentName").getter(CreateIamPolicyAssignmentResponse.getter(CreateIamPolicyAssignmentResponse::assignmentName)).setter(CreateIamPolicyAssignmentResponse.setter(Builder::assignmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentName").build()}).build();
    private static final SdkField<String> ASSIGNMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssignmentId").getter(CreateIamPolicyAssignmentResponse.getter(CreateIamPolicyAssignmentResponse::assignmentId)).setter(CreateIamPolicyAssignmentResponse.setter(Builder::assignmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentId").build()}).build();
    private static final SdkField<String> ASSIGNMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssignmentStatus").getter(CreateIamPolicyAssignmentResponse.getter(CreateIamPolicyAssignmentResponse::assignmentStatusAsString)).setter(CreateIamPolicyAssignmentResponse.setter(Builder::assignmentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentStatus").build()}).build();
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyArn").getter(CreateIamPolicyAssignmentResponse.getter(CreateIamPolicyAssignmentResponse::policyArn)).setter(CreateIamPolicyAssignmentResponse.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()}).build();
    private static final SdkField<Map<String, List<String>>> IDENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Identities").getter(CreateIamPolicyAssignmentResponse.getter(CreateIamPolicyAssignmentResponse::identities)).setter(CreateIamPolicyAssignmentResponse.setter(Builder::identities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identities").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(CreateIamPolicyAssignmentResponse.getter(CreateIamPolicyAssignmentResponse::requestId)).setter(CreateIamPolicyAssignmentResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(CreateIamPolicyAssignmentResponse.getter(CreateIamPolicyAssignmentResponse::status)).setter(CreateIamPolicyAssignmentResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSIGNMENT_NAME_FIELD, ASSIGNMENT_ID_FIELD, ASSIGNMENT_STATUS_FIELD, POLICY_ARN_FIELD, IDENTITIES_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private final String assignmentName;
    private final String assignmentId;
    private final String assignmentStatus;
    private final String policyArn;
    private final Map<String, List<String>> identities;
    private final String requestId;
    private final Integer status;

    private CreateIamPolicyAssignmentResponse(BuilderImpl builder) {
        super(builder);
        this.assignmentName = builder.assignmentName;
        this.assignmentId = builder.assignmentId;
        this.assignmentStatus = builder.assignmentStatus;
        this.policyArn = builder.policyArn;
        this.identities = builder.identities;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final String assignmentName() {
        return this.assignmentName;
    }

    public final String assignmentId() {
        return this.assignmentId;
    }

    public final AssignmentStatus assignmentStatus() {
        return AssignmentStatus.fromValue(this.assignmentStatus);
    }

    public final String assignmentStatusAsString() {
        return this.assignmentStatus;
    }

    public final String policyArn() {
        return this.policyArn;
    }

    public final boolean hasIdentities() {
        return this.identities != null && !(this.identities instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> identities() {
        return this.identities;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentities() ? this.identities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIamPolicyAssignmentResponse)) {
            return false;
        }
        CreateIamPolicyAssignmentResponse other = (CreateIamPolicyAssignmentResponse)((Object)obj);
        return Objects.equals(this.assignmentName(), other.assignmentName()) && Objects.equals(this.assignmentId(), other.assignmentId()) && Objects.equals(this.assignmentStatusAsString(), other.assignmentStatusAsString()) && Objects.equals(this.policyArn(), other.policyArn()) && this.hasIdentities() == other.hasIdentities() && Objects.equals(this.identities(), other.identities()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"CreateIamPolicyAssignmentResponse").add("AssignmentName", (Object)this.assignmentName()).add("AssignmentId", (Object)this.assignmentId()).add("AssignmentStatus", (Object)this.assignmentStatusAsString()).add("PolicyArn", (Object)this.policyArn()).add("Identities", this.hasIdentities() ? this.identities() : null).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssignmentName": {
                return Optional.ofNullable(clazz.cast(this.assignmentName()));
            }
            case "AssignmentId": {
                return Optional.ofNullable(clazz.cast(this.assignmentId()));
            }
            case "AssignmentStatus": {
                return Optional.ofNullable(clazz.cast(this.assignmentStatusAsString()));
            }
            case "PolicyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
            case "Identities": {
                return Optional.ofNullable(clazz.cast(this.identities()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIamPolicyAssignmentResponse, T> g) {
        return obj -> g.apply((CreateIamPolicyAssignmentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private String assignmentName;
        private String assignmentId;
        private String assignmentStatus;
        private String policyArn;
        private Map<String, List<String>> identities = DefaultSdkAutoConstructMap.getInstance();
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIamPolicyAssignmentResponse model) {
            super(model);
            this.assignmentName(model.assignmentName);
            this.assignmentId(model.assignmentId);
            this.assignmentStatus(model.assignmentStatus);
            this.policyArn(model.policyArn);
            this.identities(model.identities);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final String getAssignmentName() {
            return this.assignmentName;
        }

        public final void setAssignmentName(String assignmentName) {
            this.assignmentName = assignmentName;
        }

        @Override
        @Transient
        public final Builder assignmentName(String assignmentName) {
            this.assignmentName = assignmentName;
            return this;
        }

        public final String getAssignmentId() {
            return this.assignmentId;
        }

        public final void setAssignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
        }

        @Override
        @Transient
        public final Builder assignmentId(String assignmentId) {
            this.assignmentId = assignmentId;
            return this;
        }

        public final String getAssignmentStatus() {
            return this.assignmentStatus;
        }

        public final void setAssignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
        }

        @Override
        @Transient
        public final Builder assignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder assignmentStatus(AssignmentStatus assignmentStatus) {
            this.assignmentStatus(assignmentStatus == null ? null : assignmentStatus.toString());
            return this;
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        @Transient
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getIdentities() {
            if (this.identities instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.identities;
        }

        public final void setIdentities(Map<String, ? extends Collection<String>> identities) {
            this.identities = IdentityMapCopier.copy(identities);
        }

        @Override
        @Transient
        public final Builder identities(Map<String, ? extends Collection<String>> identities) {
            this.identities = IdentityMapCopier.copy(identities);
            return this;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        @Transient
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return this.status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public CreateIamPolicyAssignmentResponse build() {
            return new CreateIamPolicyAssignmentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIamPolicyAssignmentResponse> {
        public Builder assignmentName(String var1);

        public Builder assignmentId(String var1);

        public Builder assignmentStatus(String var1);

        public Builder assignmentStatus(AssignmentStatus var1);

        public Builder policyArn(String var1);

        public Builder identities(Map<String, ? extends Collection<String>> var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

