/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ActiveIAMPolicyAssignment;
import software.amazon.awssdk.services.quicksight.model.ActiveIAMPolicyAssignmentListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIamPolicyAssignmentsForUserResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, ListIamPolicyAssignmentsForUserResponse> {
    private static final SdkField<List<ActiveIAMPolicyAssignment>> ACTIVE_ASSIGNMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ActiveAssignments").getter(ListIamPolicyAssignmentsForUserResponse.getter(ListIamPolicyAssignmentsForUserResponse::activeAssignments)).setter(ListIamPolicyAssignmentsForUserResponse.setter(Builder::activeAssignments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveAssignments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActiveIAMPolicyAssignment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(ListIamPolicyAssignmentsForUserResponse.getter(ListIamPolicyAssignmentsForUserResponse::requestId)).setter(ListIamPolicyAssignmentsForUserResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListIamPolicyAssignmentsForUserResponse.getter(ListIamPolicyAssignmentsForUserResponse::nextToken)).setter(ListIamPolicyAssignmentsForUserResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(ListIamPolicyAssignmentsForUserResponse.getter(ListIamPolicyAssignmentsForUserResponse::status)).setter(ListIamPolicyAssignmentsForUserResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_ASSIGNMENTS_FIELD, REQUEST_ID_FIELD, NEXT_TOKEN_FIELD, STATUS_FIELD));
    private final List<ActiveIAMPolicyAssignment> activeAssignments;
    private final String requestId;
    private final String nextToken;
    private final Integer status;

    private ListIamPolicyAssignmentsForUserResponse(BuilderImpl builder) {
        super(builder);
        this.activeAssignments = builder.activeAssignments;
        this.requestId = builder.requestId;
        this.nextToken = builder.nextToken;
        this.status = builder.status;
    }

    public final boolean hasActiveAssignments() {
        return this.activeAssignments != null && !(this.activeAssignments instanceof SdkAutoConstructList);
    }

    public final List<ActiveIAMPolicyAssignment> activeAssignments() {
        return this.activeAssignments;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActiveAssignments() ? this.activeAssignments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIamPolicyAssignmentsForUserResponse)) {
            return false;
        }
        ListIamPolicyAssignmentsForUserResponse other = (ListIamPolicyAssignmentsForUserResponse)((Object)obj);
        return this.hasActiveAssignments() == other.hasActiveAssignments() && Objects.equals(this.activeAssignments(), other.activeAssignments()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"ListIamPolicyAssignmentsForUserResponse").add("ActiveAssignments", this.hasActiveAssignments() ? this.activeAssignments() : null).add("RequestId", (Object)this.requestId()).add("NextToken", (Object)this.nextToken()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActiveAssignments": {
                return Optional.ofNullable(clazz.cast(this.activeAssignments()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIamPolicyAssignmentsForUserResponse, T> g) {
        return obj -> g.apply((ListIamPolicyAssignmentsForUserResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private List<ActiveIAMPolicyAssignment> activeAssignments = DefaultSdkAutoConstructList.getInstance();
        private String requestId;
        private String nextToken;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIamPolicyAssignmentsForUserResponse model) {
            super(model);
            this.activeAssignments(model.activeAssignments);
            this.requestId(model.requestId);
            this.nextToken(model.nextToken);
            this.status(model.status);
        }

        public final List<ActiveIAMPolicyAssignment.Builder> getActiveAssignments() {
            List<ActiveIAMPolicyAssignment.Builder> result = ActiveIAMPolicyAssignmentListCopier.copyToBuilder(this.activeAssignments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder activeAssignments(Collection<ActiveIAMPolicyAssignment> activeAssignments) {
            this.activeAssignments = ActiveIAMPolicyAssignmentListCopier.copy(activeAssignments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeAssignments(ActiveIAMPolicyAssignment ... activeAssignments) {
            this.activeAssignments(Arrays.asList(activeAssignments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeAssignments(Consumer<ActiveIAMPolicyAssignment.Builder> ... activeAssignments) {
            this.activeAssignments(Stream.of(activeAssignments).map(c -> (ActiveIAMPolicyAssignment)((ActiveIAMPolicyAssignment.Builder)ActiveIAMPolicyAssignment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setActiveAssignments(Collection<ActiveIAMPolicyAssignment.BuilderImpl> activeAssignments) {
            this.activeAssignments = ActiveIAMPolicyAssignmentListCopier.copyFromBuilder(activeAssignments);
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public ListIamPolicyAssignmentsForUserResponse build() {
            return new ListIamPolicyAssignmentsForUserResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIamPolicyAssignmentsForUserResponse> {
        public Builder activeAssignments(Collection<ActiveIAMPolicyAssignment> var1);

        public Builder activeAssignments(ActiveIAMPolicyAssignment ... var1);

        public Builder activeAssignments(Consumer<ActiveIAMPolicyAssignment.Builder> ... var1);

        public Builder requestId(String var1);

        public Builder nextToken(String var1);

        public Builder status(Integer var1);
    }
}

