/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.GroupMember;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGroupMembershipResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, CreateGroupMembershipResponse> {
    private static final SdkField<GroupMember> GROUP_MEMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("GroupMember").getter(CreateGroupMembershipResponse.getter(CreateGroupMembershipResponse::groupMember)).setter(CreateGroupMembershipResponse.setter(Builder::groupMember)).constructor(GroupMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupMember").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(CreateGroupMembershipResponse.getter(CreateGroupMembershipResponse::requestId)).setter(CreateGroupMembershipResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(CreateGroupMembershipResponse.getter(CreateGroupMembershipResponse::status)).setter(CreateGroupMembershipResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_MEMBER_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private final GroupMember groupMember;
    private final String requestId;
    private final Integer status;

    private CreateGroupMembershipResponse(BuilderImpl builder) {
        super(builder);
        this.groupMember = builder.groupMember;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final GroupMember groupMember() {
        return this.groupMember;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.groupMember());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGroupMembershipResponse)) {
            return false;
        }
        CreateGroupMembershipResponse other = (CreateGroupMembershipResponse)((Object)obj);
        return Objects.equals(this.groupMember(), other.groupMember()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGroupMembershipResponse").add("GroupMember", (Object)this.groupMember()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupMember": {
                return Optional.ofNullable(clazz.cast(this.groupMember()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateGroupMembershipResponse, T> g) {
        return obj -> g.apply((CreateGroupMembershipResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private GroupMember groupMember;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGroupMembershipResponse model) {
            super(model);
            this.groupMember(model.groupMember);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final GroupMember.Builder getGroupMember() {
            return this.groupMember != null ? this.groupMember.toBuilder() : null;
        }

        @Override
        public final Builder groupMember(GroupMember groupMember) {
            this.groupMember = groupMember;
            return this;
        }

        public final void setGroupMember(GroupMember.BuilderImpl groupMember) {
            this.groupMember = groupMember != null ? groupMember.build() : null;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public CreateGroupMembershipResponse build() {
            return new CreateGroupMembershipResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGroupMembershipResponse> {
        public Builder groupMember(GroupMember var1);

        default public Builder groupMember(Consumer<GroupMember.Builder> groupMember) {
            return this.groupMember((GroupMember)((GroupMember.Builder)GroupMember.builder().applyMutation(groupMember)).build());
        }

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

