/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.DataSetReference;
import software.amazon.awssdk.services.quicksight.model.DataSetReferenceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DashboardSourceTemplate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DashboardSourceTemplate> {
    private static final SdkField<List<DataSetReference>> DATA_SET_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataSetReferences").getter(DashboardSourceTemplate.getter(DashboardSourceTemplate::dataSetReferences)).setter(DashboardSourceTemplate.setter(Builder::dataSetReferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetReferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataSetReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DashboardSourceTemplate.getter(DashboardSourceTemplate::arn)).setter(DashboardSourceTemplate.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_REFERENCES_FIELD, ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<DataSetReference> dataSetReferences;
    private final String arn;

    private DashboardSourceTemplate(BuilderImpl builder) {
        this.dataSetReferences = builder.dataSetReferences;
        this.arn = builder.arn;
    }

    public final boolean hasDataSetReferences() {
        return this.dataSetReferences != null && !(this.dataSetReferences instanceof SdkAutoConstructList);
    }

    public final List<DataSetReference> dataSetReferences() {
        return this.dataSetReferences;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataSetReferences() ? this.dataSetReferences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardSourceTemplate)) {
            return false;
        }
        DashboardSourceTemplate other = (DashboardSourceTemplate)obj;
        return this.hasDataSetReferences() == other.hasDataSetReferences() && Objects.equals(this.dataSetReferences(), other.dataSetReferences()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"DashboardSourceTemplate").add("DataSetReferences", this.hasDataSetReferences() ? this.dataSetReferences() : null).add("Arn", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSetReferences": {
                return Optional.ofNullable(clazz.cast(this.dataSetReferences()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashboardSourceTemplate, T> g) {
        return obj -> g.apply((DashboardSourceTemplate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DataSetReference> dataSetReferences = DefaultSdkAutoConstructList.getInstance();
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardSourceTemplate model) {
            this.dataSetReferences(model.dataSetReferences);
            this.arn(model.arn);
        }

        public final List<DataSetReference.Builder> getDataSetReferences() {
            List<DataSetReference.Builder> result = DataSetReferenceListCopier.copyToBuilder(this.dataSetReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder dataSetReferences(Collection<DataSetReference> dataSetReferences) {
            this.dataSetReferences = DataSetReferenceListCopier.copy(dataSetReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetReferences(DataSetReference ... dataSetReferences) {
            this.dataSetReferences(Arrays.asList(dataSetReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSetReferences(Consumer<DataSetReference.Builder> ... dataSetReferences) {
            this.dataSetReferences(Stream.of(dataSetReferences).map(c -> (DataSetReference)((DataSetReference.Builder)DataSetReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDataSetReferences(Collection<DataSetReference.BuilderImpl> dataSetReferences) {
            this.dataSetReferences = DataSetReferenceListCopier.copyFromBuilder(dataSetReferences);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public DashboardSourceTemplate build() {
            return new DashboardSourceTemplate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DashboardSourceTemplate> {
        public Builder dataSetReferences(Collection<DataSetReference> var1);

        public Builder dataSetReferences(DataSetReference ... var1);

        public Builder dataSetReferences(Consumer<DataSetReference.Builder> ... var1);

        public Builder arn(String var1);
    }
}

