/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesRequest;
import software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesResponse;
import software.amazon.awssdk.services.quicksight.model.TemplateAlias;

public class ListTemplateAliasesIterable
implements SdkIterable<ListTemplateAliasesResponse> {
    private final QuickSightClient client;
    private final ListTemplateAliasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTemplateAliasesIterable(QuickSightClient client, ListTemplateAliasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListTemplateAliasesResponseFetcher();
    }

    public Iterator<ListTemplateAliasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TemplateAlias> templateAliasList() {
        Function<ListTemplateAliasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.templateAliasList() != null) {
                return response.templateAliasList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTemplateAliasesResponseFetcher
    implements SyncPageFetcher<ListTemplateAliasesResponse> {
        private ListTemplateAliasesResponseFetcher() {
        }

        public boolean hasNextPage(ListTemplateAliasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTemplateAliasesResponse nextPage(ListTemplateAliasesResponse previousPage) {
            if (previousPage == null) {
                return ListTemplateAliasesIterable.this.client.listTemplateAliases(ListTemplateAliasesIterable.this.firstRequest);
            }
            return ListTemplateAliasesIterable.this.client.listTemplateAliases((ListTemplateAliasesRequest)((Object)ListTemplateAliasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

