/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ErrorInfo;
import software.amazon.awssdk.services.quicksight.model.IngestionRequestSource;
import software.amazon.awssdk.services.quicksight.model.IngestionRequestType;
import software.amazon.awssdk.services.quicksight.model.IngestionStatus;
import software.amazon.awssdk.services.quicksight.model.QueueInfo;
import software.amazon.awssdk.services.quicksight.model.RowInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ingestion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Ingestion> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Ingestion.getter(Ingestion::arn)).setter(Ingestion.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> INGESTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngestionId").getter(Ingestion.getter(Ingestion::ingestionId)).setter(Ingestion.setter(Builder::ingestionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionId").build()}).build();
    private static final SdkField<String> INGESTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngestionStatus").getter(Ingestion.getter(Ingestion::ingestionStatusAsString)).setter(Ingestion.setter(Builder::ingestionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionStatus").build()}).build();
    private static final SdkField<ErrorInfo> ERROR_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ErrorInfo").getter(Ingestion.getter(Ingestion::errorInfo)).setter(Ingestion.setter(Builder::errorInfo)).constructor(ErrorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorInfo").build()}).build();
    private static final SdkField<RowInfo> ROW_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RowInfo").getter(Ingestion.getter(Ingestion::rowInfo)).setter(Ingestion.setter(Builder::rowInfo)).constructor(RowInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowInfo").build()}).build();
    private static final SdkField<QueueInfo> QUEUE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueueInfo").getter(Ingestion.getter(Ingestion::queueInfo)).setter(Ingestion.setter(Builder::queueInfo)).constructor(QueueInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueInfo").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(Ingestion.getter(Ingestion::createdTime)).setter(Ingestion.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Long> INGESTION_TIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("IngestionTimeInSeconds").getter(Ingestion.getter(Ingestion::ingestionTimeInSeconds)).setter(Ingestion.setter(Builder::ingestionTimeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionTimeInSeconds").build()}).build();
    private static final SdkField<Long> INGESTION_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("IngestionSizeInBytes").getter(Ingestion.getter(Ingestion::ingestionSizeInBytes)).setter(Ingestion.setter(Builder::ingestionSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IngestionSizeInBytes").build()}).build();
    private static final SdkField<String> REQUEST_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestSource").getter(Ingestion.getter(Ingestion::requestSourceAsString)).setter(Ingestion.setter(Builder::requestSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestSource").build()}).build();
    private static final SdkField<String> REQUEST_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestType").getter(Ingestion.getter(Ingestion::requestTypeAsString)).setter(Ingestion.setter(Builder::requestType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, INGESTION_ID_FIELD, INGESTION_STATUS_FIELD, ERROR_INFO_FIELD, ROW_INFO_FIELD, QUEUE_INFO_FIELD, CREATED_TIME_FIELD, INGESTION_TIME_IN_SECONDS_FIELD, INGESTION_SIZE_IN_BYTES_FIELD, REQUEST_SOURCE_FIELD, REQUEST_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String ingestionId;
    private final String ingestionStatus;
    private final ErrorInfo errorInfo;
    private final RowInfo rowInfo;
    private final QueueInfo queueInfo;
    private final Instant createdTime;
    private final Long ingestionTimeInSeconds;
    private final Long ingestionSizeInBytes;
    private final String requestSource;
    private final String requestType;

    private Ingestion(BuilderImpl builder) {
        this.arn = builder.arn;
        this.ingestionId = builder.ingestionId;
        this.ingestionStatus = builder.ingestionStatus;
        this.errorInfo = builder.errorInfo;
        this.rowInfo = builder.rowInfo;
        this.queueInfo = builder.queueInfo;
        this.createdTime = builder.createdTime;
        this.ingestionTimeInSeconds = builder.ingestionTimeInSeconds;
        this.ingestionSizeInBytes = builder.ingestionSizeInBytes;
        this.requestSource = builder.requestSource;
        this.requestType = builder.requestType;
    }

    public final String arn() {
        return this.arn;
    }

    public final String ingestionId() {
        return this.ingestionId;
    }

    public final IngestionStatus ingestionStatus() {
        return IngestionStatus.fromValue(this.ingestionStatus);
    }

    public final String ingestionStatusAsString() {
        return this.ingestionStatus;
    }

    public final ErrorInfo errorInfo() {
        return this.errorInfo;
    }

    public final RowInfo rowInfo() {
        return this.rowInfo;
    }

    public final QueueInfo queueInfo() {
        return this.queueInfo;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Long ingestionTimeInSeconds() {
        return this.ingestionTimeInSeconds;
    }

    public final Long ingestionSizeInBytes() {
        return this.ingestionSizeInBytes;
    }

    public final IngestionRequestSource requestSource() {
        return IngestionRequestSource.fromValue(this.requestSource);
    }

    public final String requestSourceAsString() {
        return this.requestSource;
    }

    public final IngestionRequestType requestType() {
        return IngestionRequestType.fromValue(this.requestType);
    }

    public final String requestTypeAsString() {
        return this.requestType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.rowInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ingestion)) {
            return false;
        }
        Ingestion other = (Ingestion)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.ingestionId(), other.ingestionId()) && Objects.equals(this.ingestionStatusAsString(), other.ingestionStatusAsString()) && Objects.equals(this.errorInfo(), other.errorInfo()) && Objects.equals(this.rowInfo(), other.rowInfo()) && Objects.equals(this.queueInfo(), other.queueInfo()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.ingestionTimeInSeconds(), other.ingestionTimeInSeconds()) && Objects.equals(this.ingestionSizeInBytes(), other.ingestionSizeInBytes()) && Objects.equals(this.requestSourceAsString(), other.requestSourceAsString()) && Objects.equals(this.requestTypeAsString(), other.requestTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Ingestion").add("Arn", (Object)this.arn()).add("IngestionId", (Object)this.ingestionId()).add("IngestionStatus", (Object)this.ingestionStatusAsString()).add("ErrorInfo", (Object)this.errorInfo()).add("RowInfo", (Object)this.rowInfo()).add("QueueInfo", (Object)this.queueInfo()).add("CreatedTime", (Object)this.createdTime()).add("IngestionTimeInSeconds", (Object)this.ingestionTimeInSeconds()).add("IngestionSizeInBytes", (Object)this.ingestionSizeInBytes()).add("RequestSource", (Object)this.requestSourceAsString()).add("RequestType", (Object)this.requestTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "IngestionId": {
                return Optional.ofNullable(clazz.cast(this.ingestionId()));
            }
            case "IngestionStatus": {
                return Optional.ofNullable(clazz.cast(this.ingestionStatusAsString()));
            }
            case "ErrorInfo": {
                return Optional.ofNullable(clazz.cast(this.errorInfo()));
            }
            case "RowInfo": {
                return Optional.ofNullable(clazz.cast(this.rowInfo()));
            }
            case "QueueInfo": {
                return Optional.ofNullable(clazz.cast(this.queueInfo()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "IngestionTimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.ingestionTimeInSeconds()));
            }
            case "IngestionSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.ingestionSizeInBytes()));
            }
            case "RequestSource": {
                return Optional.ofNullable(clazz.cast(this.requestSourceAsString()));
            }
            case "RequestType": {
                return Optional.ofNullable(clazz.cast(this.requestTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Ingestion, T> g) {
        return obj -> g.apply((Ingestion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String ingestionId;
        private String ingestionStatus;
        private ErrorInfo errorInfo;
        private RowInfo rowInfo;
        private QueueInfo queueInfo;
        private Instant createdTime;
        private Long ingestionTimeInSeconds;
        private Long ingestionSizeInBytes;
        private String requestSource;
        private String requestType;

        private BuilderImpl() {
        }

        private BuilderImpl(Ingestion model) {
            this.arn(model.arn);
            this.ingestionId(model.ingestionId);
            this.ingestionStatus(model.ingestionStatus);
            this.errorInfo(model.errorInfo);
            this.rowInfo(model.rowInfo);
            this.queueInfo(model.queueInfo);
            this.createdTime(model.createdTime);
            this.ingestionTimeInSeconds(model.ingestionTimeInSeconds);
            this.ingestionSizeInBytes(model.ingestionSizeInBytes);
            this.requestSource(model.requestSource);
            this.requestType(model.requestType);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getIngestionId() {
            return this.ingestionId;
        }

        @Override
        public final Builder ingestionId(String ingestionId) {
            this.ingestionId = ingestionId;
            return this;
        }

        public final void setIngestionId(String ingestionId) {
            this.ingestionId = ingestionId;
        }

        public final String getIngestionStatus() {
            return this.ingestionStatus;
        }

        @Override
        public final Builder ingestionStatus(String ingestionStatus) {
            this.ingestionStatus = ingestionStatus;
            return this;
        }

        @Override
        public final Builder ingestionStatus(IngestionStatus ingestionStatus) {
            this.ingestionStatus(ingestionStatus == null ? null : ingestionStatus.toString());
            return this;
        }

        public final void setIngestionStatus(String ingestionStatus) {
            this.ingestionStatus = ingestionStatus;
        }

        public final ErrorInfo.Builder getErrorInfo() {
            return this.errorInfo != null ? this.errorInfo.toBuilder() : null;
        }

        @Override
        public final Builder errorInfo(ErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final void setErrorInfo(ErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        public final RowInfo.Builder getRowInfo() {
            return this.rowInfo != null ? this.rowInfo.toBuilder() : null;
        }

        @Override
        public final Builder rowInfo(RowInfo rowInfo) {
            this.rowInfo = rowInfo;
            return this;
        }

        public final void setRowInfo(RowInfo.BuilderImpl rowInfo) {
            this.rowInfo = rowInfo != null ? rowInfo.build() : null;
        }

        public final QueueInfo.Builder getQueueInfo() {
            return this.queueInfo != null ? this.queueInfo.toBuilder() : null;
        }

        @Override
        public final Builder queueInfo(QueueInfo queueInfo) {
            this.queueInfo = queueInfo;
            return this;
        }

        public final void setQueueInfo(QueueInfo.BuilderImpl queueInfo) {
            this.queueInfo = queueInfo != null ? queueInfo.build() : null;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Long getIngestionTimeInSeconds() {
            return this.ingestionTimeInSeconds;
        }

        @Override
        public final Builder ingestionTimeInSeconds(Long ingestionTimeInSeconds) {
            this.ingestionTimeInSeconds = ingestionTimeInSeconds;
            return this;
        }

        public final void setIngestionTimeInSeconds(Long ingestionTimeInSeconds) {
            this.ingestionTimeInSeconds = ingestionTimeInSeconds;
        }

        public final Long getIngestionSizeInBytes() {
            return this.ingestionSizeInBytes;
        }

        @Override
        public final Builder ingestionSizeInBytes(Long ingestionSizeInBytes) {
            this.ingestionSizeInBytes = ingestionSizeInBytes;
            return this;
        }

        public final void setIngestionSizeInBytes(Long ingestionSizeInBytes) {
            this.ingestionSizeInBytes = ingestionSizeInBytes;
        }

        public final String getRequestSource() {
            return this.requestSource;
        }

        @Override
        public final Builder requestSource(String requestSource) {
            this.requestSource = requestSource;
            return this;
        }

        @Override
        public final Builder requestSource(IngestionRequestSource requestSource) {
            this.requestSource(requestSource == null ? null : requestSource.toString());
            return this;
        }

        public final void setRequestSource(String requestSource) {
            this.requestSource = requestSource;
        }

        public final String getRequestType() {
            return this.requestType;
        }

        @Override
        public final Builder requestType(String requestType) {
            this.requestType = requestType;
            return this;
        }

        @Override
        public final Builder requestType(IngestionRequestType requestType) {
            this.requestType(requestType == null ? null : requestType.toString());
            return this;
        }

        public final void setRequestType(String requestType) {
            this.requestType = requestType;
        }

        public Ingestion build() {
            return new Ingestion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Ingestion> {
        public Builder arn(String var1);

        public Builder ingestionId(String var1);

        public Builder ingestionStatus(String var1);

        public Builder ingestionStatus(IngestionStatus var1);

        public Builder errorInfo(ErrorInfo var1);

        default public Builder errorInfo(Consumer<ErrorInfo.Builder> errorInfo) {
            return this.errorInfo((ErrorInfo)((ErrorInfo.Builder)ErrorInfo.builder().applyMutation(errorInfo)).build());
        }

        public Builder rowInfo(RowInfo var1);

        default public Builder rowInfo(Consumer<RowInfo.Builder> rowInfo) {
            return this.rowInfo((RowInfo)((RowInfo.Builder)RowInfo.builder().applyMutation(rowInfo)).build());
        }

        public Builder queueInfo(QueueInfo var1);

        default public Builder queueInfo(Consumer<QueueInfo.Builder> queueInfo) {
            return this.queueInfo((QueueInfo)((QueueInfo.Builder)QueueInfo.builder().applyMutation(queueInfo)).build());
        }

        public Builder createdTime(Instant var1);

        public Builder ingestionTimeInSeconds(Long var1);

        public Builder ingestionSizeInBytes(Long var1);

        public Builder requestSource(String var1);

        public Builder requestSource(IngestionRequestSource var1);

        public Builder requestType(String var1);

        public Builder requestType(IngestionRequestType var1);
    }
}

