/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.Ingestion;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIngestionResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DescribeIngestionResponse> {
    private static final SdkField<Ingestion> INGESTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Ingestion").getter(DescribeIngestionResponse.getter(DescribeIngestionResponse::ingestion)).setter(DescribeIngestionResponse.setter(Builder::ingestion)).constructor(Ingestion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ingestion").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(DescribeIngestionResponse.getter(DescribeIngestionResponse::requestId)).setter(DescribeIngestionResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(DescribeIngestionResponse.getter(DescribeIngestionResponse::status)).setter(DescribeIngestionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INGESTION_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private final Ingestion ingestion;
    private final String requestId;
    private final Integer status;

    private DescribeIngestionResponse(BuilderImpl builder) {
        super(builder);
        this.ingestion = builder.ingestion;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final Ingestion ingestion() {
        return this.ingestion;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestion());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIngestionResponse)) {
            return false;
        }
        DescribeIngestionResponse other = (DescribeIngestionResponse)((Object)obj);
        return Objects.equals(this.ingestion(), other.ingestion()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeIngestionResponse").add("Ingestion", (Object)this.ingestion()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Ingestion": {
                return Optional.ofNullable(clazz.cast(this.ingestion()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeIngestionResponse, T> g) {
        return obj -> g.apply((DescribeIngestionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private Ingestion ingestion;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIngestionResponse model) {
            super(model);
            this.ingestion(model.ingestion);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final Ingestion.Builder getIngestion() {
            return this.ingestion != null ? this.ingestion.toBuilder() : null;
        }

        @Override
        public final Builder ingestion(Ingestion ingestion) {
            this.ingestion = ingestion;
            return this;
        }

        public final void setIngestion(Ingestion.BuilderImpl ingestion) {
            this.ingestion = ingestion != null ? ingestion.build() : null;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public DescribeIngestionResponse build() {
            return new DescribeIngestionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIngestionResponse> {
        public Builder ingestion(Ingestion var1);

        default public Builder ingestion(Consumer<Ingestion.Builder> ingestion) {
            return this.ingestion((Ingestion)((Ingestion.Builder)Ingestion.builder().applyMutation(ingestion)).build());
        }

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

