/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.DataSourceErrorInfoType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourceErrorInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourceErrorInfo> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(DataSourceErrorInfo.getter(DataSourceErrorInfo::typeAsString)).setter(DataSourceErrorInfo.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(DataSourceErrorInfo.getter(DataSourceErrorInfo::message)).setter(DataSourceErrorInfo.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String message;

    private DataSourceErrorInfo(BuilderImpl builder) {
        this.type = builder.type;
        this.message = builder.message;
    }

    public final DataSourceErrorInfoType type() {
        return DataSourceErrorInfoType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceErrorInfo)) {
            return false;
        }
        DataSourceErrorInfo other = (DataSourceErrorInfo)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return ToString.builder((String)"DataSourceErrorInfo").add("Type", (Object)this.typeAsString()).add("Message", (Object)this.message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceErrorInfo, T> g) {
        return obj -> g.apply((DataSourceErrorInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceErrorInfo model) {
            this.type(model.type);
            this.message(model.message);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataSourceErrorInfoType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public DataSourceErrorInfo build() {
            return new DataSourceErrorInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourceErrorInfo> {
        public Builder type(String var1);

        public Builder type(DataSourceErrorInfoType var1);

        public Builder message(String var1);
    }
}

