/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.model.DashboardVersionSummary;
import software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsResponse;

public class ListDashboardVersionsPublisher
implements SdkPublisher<ListDashboardVersionsResponse> {
    private final QuickSightAsyncClient client;
    private final ListDashboardVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDashboardVersionsPublisher(QuickSightAsyncClient client, ListDashboardVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDashboardVersionsPublisher(QuickSightAsyncClient client, ListDashboardVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDashboardVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDashboardVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DashboardVersionSummary> dashboardVersionSummaryList() {
        Function<ListDashboardVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dashboardVersionSummaryList() != null) {
                return response.dashboardVersionSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDashboardVersionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDashboardVersionsResponseFetcher
    implements AsyncPageFetcher<ListDashboardVersionsResponse> {
        private ListDashboardVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDashboardVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDashboardVersionsResponse> nextPage(ListDashboardVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListDashboardVersionsPublisher.this.client.listDashboardVersions(ListDashboardVersionsPublisher.this.firstRequest);
            }
            return ListDashboardVersionsPublisher.this.client.listDashboardVersions((ListDashboardVersionsRequest)((Object)ListDashboardVersionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

