/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.IAMPolicyAssignmentSummary;
import software.amazon.awssdk.services.quicksight.model.IAMPolicyAssignmentSummaryListCopier;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIamPolicyAssignmentsResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, ListIamPolicyAssignmentsResponse> {
    private static final SdkField<List<IAMPolicyAssignmentSummary>> IAM_POLICY_ASSIGNMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IAMPolicyAssignments").getter(ListIamPolicyAssignmentsResponse.getter(ListIamPolicyAssignmentsResponse::iamPolicyAssignments)).setter(ListIamPolicyAssignmentsResponse.setter(Builder::iamPolicyAssignments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMPolicyAssignments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IAMPolicyAssignmentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListIamPolicyAssignmentsResponse.getter(ListIamPolicyAssignmentsResponse::nextToken)).setter(ListIamPolicyAssignmentsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(ListIamPolicyAssignmentsResponse.getter(ListIamPolicyAssignmentsResponse::requestId)).setter(ListIamPolicyAssignmentsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(ListIamPolicyAssignmentsResponse.getter(ListIamPolicyAssignmentsResponse::status)).setter(ListIamPolicyAssignmentsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_POLICY_ASSIGNMENTS_FIELD, NEXT_TOKEN_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private final List<IAMPolicyAssignmentSummary> iamPolicyAssignments;
    private final String nextToken;
    private final String requestId;
    private final Integer status;

    private ListIamPolicyAssignmentsResponse(BuilderImpl builder) {
        super(builder);
        this.iamPolicyAssignments = builder.iamPolicyAssignments;
        this.nextToken = builder.nextToken;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public final boolean hasIamPolicyAssignments() {
        return this.iamPolicyAssignments != null && !(this.iamPolicyAssignments instanceof SdkAutoConstructList);
    }

    public final List<IAMPolicyAssignmentSummary> iamPolicyAssignments() {
        return this.iamPolicyAssignments;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIamPolicyAssignments() ? this.iamPolicyAssignments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIamPolicyAssignmentsResponse)) {
            return false;
        }
        ListIamPolicyAssignmentsResponse other = (ListIamPolicyAssignmentsResponse)((Object)obj);
        return this.hasIamPolicyAssignments() == other.hasIamPolicyAssignments() && Objects.equals(this.iamPolicyAssignments(), other.iamPolicyAssignments()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"ListIamPolicyAssignmentsResponse").add("IAMPolicyAssignments", this.hasIamPolicyAssignments() ? this.iamPolicyAssignments() : null).add("NextToken", (Object)this.nextToken()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IAMPolicyAssignments": {
                return Optional.ofNullable(clazz.cast(this.iamPolicyAssignments()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIamPolicyAssignmentsResponse, T> g) {
        return obj -> g.apply((ListIamPolicyAssignmentsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private List<IAMPolicyAssignmentSummary> iamPolicyAssignments = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIamPolicyAssignmentsResponse model) {
            super(model);
            this.iamPolicyAssignments(model.iamPolicyAssignments);
            this.nextToken(model.nextToken);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final Collection<IAMPolicyAssignmentSummary.Builder> getIamPolicyAssignments() {
            if (this.iamPolicyAssignments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.iamPolicyAssignments != null ? (Collection)this.iamPolicyAssignments.stream().map(IAMPolicyAssignmentSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder iamPolicyAssignments(Collection<IAMPolicyAssignmentSummary> iamPolicyAssignments) {
            this.iamPolicyAssignments = IAMPolicyAssignmentSummaryListCopier.copy(iamPolicyAssignments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamPolicyAssignments(IAMPolicyAssignmentSummary ... iamPolicyAssignments) {
            this.iamPolicyAssignments(Arrays.asList(iamPolicyAssignments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamPolicyAssignments(Consumer<IAMPolicyAssignmentSummary.Builder> ... iamPolicyAssignments) {
            this.iamPolicyAssignments(Stream.of(iamPolicyAssignments).map(c -> (IAMPolicyAssignmentSummary)((IAMPolicyAssignmentSummary.Builder)IAMPolicyAssignmentSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIamPolicyAssignments(Collection<IAMPolicyAssignmentSummary.BuilderImpl> iamPolicyAssignments) {
            this.iamPolicyAssignments = IAMPolicyAssignmentSummaryListCopier.copyFromBuilder(iamPolicyAssignments);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public ListIamPolicyAssignmentsResponse build() {
            return new ListIamPolicyAssignmentsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIamPolicyAssignmentsResponse> {
        public Builder iamPolicyAssignments(Collection<IAMPolicyAssignmentSummary> var1);

        public Builder iamPolicyAssignments(IAMPolicyAssignmentSummary ... var1);

        public Builder iamPolicyAssignments(Consumer<IAMPolicyAssignmentSummary.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

