/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightClient;
import software.amazon.awssdk.services.quicksight.model.ListThemeVersionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListThemeVersionsResponse;
import software.amazon.awssdk.services.quicksight.model.ThemeVersionSummary;

public class ListThemeVersionsIterable
implements SdkIterable<ListThemeVersionsResponse> {
    private final QuickSightClient client;
    private final ListThemeVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListThemeVersionsIterable(QuickSightClient client, ListThemeVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListThemeVersionsResponseFetcher();
    }

    public Iterator<ListThemeVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ThemeVersionSummary> themeVersionSummaryList() {
        Function<ListThemeVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.themeVersionSummaryList() != null) {
                return response.themeVersionSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListThemeVersionsResponseFetcher
    implements SyncPageFetcher<ListThemeVersionsResponse> {
        private ListThemeVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListThemeVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListThemeVersionsResponse nextPage(ListThemeVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListThemeVersionsIterable.this.client.listThemeVersions(ListThemeVersionsIterable.this.firstRequest);
            }
            return ListThemeVersionsIterable.this.client.listThemeVersions((ListThemeVersionsRequest)((Object)ListThemeVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

