/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.services.quicksight.model.ThemeAlias;
import software.amazon.awssdk.services.quicksight.model.ThemeAliasListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListThemeAliasesResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, ListThemeAliasesResponse> {
    private static final SdkField<List<ThemeAlias>> THEME_ALIAS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ThemeAliasList").getter(ListThemeAliasesResponse.getter(ListThemeAliasesResponse::themeAliasList)).setter(ListThemeAliasesResponse.setter(Builder::themeAliasList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeAliasList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ThemeAlias::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(ListThemeAliasesResponse.getter(ListThemeAliasesResponse::status)).setter(ListThemeAliasesResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(ListThemeAliasesResponse.getter(ListThemeAliasesResponse::requestId)).setter(ListThemeAliasesResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListThemeAliasesResponse.getter(ListThemeAliasesResponse::nextToken)).setter(ListThemeAliasesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THEME_ALIAS_LIST_FIELD, STATUS_FIELD, REQUEST_ID_FIELD, NEXT_TOKEN_FIELD));
    private final List<ThemeAlias> themeAliasList;
    private final Integer status;
    private final String requestId;
    private final String nextToken;

    private ListThemeAliasesResponse(BuilderImpl builder) {
        super(builder);
        this.themeAliasList = builder.themeAliasList;
        this.status = builder.status;
        this.requestId = builder.requestId;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasThemeAliasList() {
        return this.themeAliasList != null && !(this.themeAliasList instanceof SdkAutoConstructList);
    }

    public final List<ThemeAlias> themeAliasList() {
        return this.themeAliasList;
    }

    public final Integer status() {
        return this.status;
    }

    public final String requestId() {
        return this.requestId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThemeAliasList() ? this.themeAliasList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThemeAliasesResponse)) {
            return false;
        }
        ListThemeAliasesResponse other = (ListThemeAliasesResponse)((Object)obj);
        return this.hasThemeAliasList() == other.hasThemeAliasList() && Objects.equals(this.themeAliasList(), other.themeAliasList()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListThemeAliasesResponse").add("ThemeAliasList", this.hasThemeAliasList() ? this.themeAliasList() : null).add("Status", (Object)this.status()).add("RequestId", (Object)this.requestId()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ThemeAliasList": {
                return Optional.ofNullable(clazz.cast(this.themeAliasList()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListThemeAliasesResponse, T> g) {
        return obj -> g.apply((ListThemeAliasesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private List<ThemeAlias> themeAliasList = DefaultSdkAutoConstructList.getInstance();
        private Integer status;
        private String requestId;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThemeAliasesResponse model) {
            super(model);
            this.themeAliasList(model.themeAliasList);
            this.status(model.status);
            this.requestId(model.requestId);
            this.nextToken(model.nextToken);
        }

        public final Collection<ThemeAlias.Builder> getThemeAliasList() {
            if (this.themeAliasList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.themeAliasList != null ? (Collection)this.themeAliasList.stream().map(ThemeAlias::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder themeAliasList(Collection<ThemeAlias> themeAliasList) {
            this.themeAliasList = ThemeAliasListCopier.copy(themeAliasList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder themeAliasList(ThemeAlias ... themeAliasList) {
            this.themeAliasList(Arrays.asList(themeAliasList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder themeAliasList(Consumer<ThemeAlias.Builder> ... themeAliasList) {
            this.themeAliasList(Stream.of(themeAliasList).map(c -> (ThemeAlias)((ThemeAlias.Builder)ThemeAlias.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setThemeAliasList(Collection<ThemeAlias.BuilderImpl> themeAliasList) {
            this.themeAliasList = ThemeAliasListCopier.copyFromBuilder(themeAliasList);
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListThemeAliasesResponse build() {
            return new ListThemeAliasesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListThemeAliasesResponse> {
        public Builder themeAliasList(Collection<ThemeAlias> var1);

        public Builder themeAliasList(ThemeAlias ... var1);

        public Builder themeAliasList(Consumer<ThemeAlias.Builder> ... var1);

        public Builder status(Integer var1);

        public Builder requestId(String var1);

        public Builder nextToken(String var1);
    }
}

