/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.AnalysisSourceEntity;
import software.amazon.awssdk.services.quicksight.model.Parameters;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.ResourcePermission;
import software.amazon.awssdk.services.quicksight.model.ResourcePermissionListCopier;
import software.amazon.awssdk.services.quicksight.model.Tag;
import software.amazon.awssdk.services.quicksight.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAnalysisRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, CreateAnalysisRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(CreateAnalysisRequest.getter(CreateAnalysisRequest::awsAccountId)).setter(CreateAnalysisRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final SdkField<String> ANALYSIS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisId").getter(CreateAnalysisRequest.getter(CreateAnalysisRequest::analysisId)).setter(CreateAnalysisRequest.setter(Builder::analysisId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AnalysisId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateAnalysisRequest.getter(CreateAnalysisRequest::name)).setter(CreateAnalysisRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Parameters> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Parameters").getter(CreateAnalysisRequest.getter(CreateAnalysisRequest::parameters)).setter(CreateAnalysisRequest.setter(Builder::parameters)).constructor(Parameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()}).build();
    private static final SdkField<List<ResourcePermission>> PERMISSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Permissions").getter(CreateAnalysisRequest.getter(CreateAnalysisRequest::permissions)).setter(CreateAnalysisRequest.setter(Builder::permissions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcePermission::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AnalysisSourceEntity> SOURCE_ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceEntity").getter(CreateAnalysisRequest.getter(CreateAnalysisRequest::sourceEntity)).setter(CreateAnalysisRequest.setter(Builder::sourceEntity)).constructor(AnalysisSourceEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEntity").build()}).build();
    private static final SdkField<String> THEME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ThemeArn").getter(CreateAnalysisRequest.getter(CreateAnalysisRequest::themeArn)).setter(CreateAnalysisRequest.setter(Builder::themeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeArn").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateAnalysisRequest.getter(CreateAnalysisRequest::tags)).setter(CreateAnalysisRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD, ANALYSIS_ID_FIELD, NAME_FIELD, PARAMETERS_FIELD, PERMISSIONS_FIELD, SOURCE_ENTITY_FIELD, THEME_ARN_FIELD, TAGS_FIELD));
    private final String awsAccountId;
    private final String analysisId;
    private final String name;
    private final Parameters parameters;
    private final List<ResourcePermission> permissions;
    private final AnalysisSourceEntity sourceEntity;
    private final String themeArn;
    private final List<Tag> tags;

    private CreateAnalysisRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.analysisId = builder.analysisId;
        this.name = builder.name;
        this.parameters = builder.parameters;
        this.permissions = builder.permissions;
        this.sourceEntity = builder.sourceEntity;
        this.themeArn = builder.themeArn;
        this.tags = builder.tags;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String analysisId() {
        return this.analysisId;
    }

    public final String name() {
        return this.name;
    }

    public final Parameters parameters() {
        return this.parameters;
    }

    public final boolean hasPermissions() {
        return this.permissions != null && !(this.permissions instanceof SdkAutoConstructList);
    }

    public final List<ResourcePermission> permissions() {
        return this.permissions;
    }

    public final AnalysisSourceEntity sourceEntity() {
        return this.sourceEntity;
    }

    public final String themeArn() {
        return this.themeArn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPermissions() ? this.permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEntity());
        hashCode = 31 * hashCode + Objects.hashCode(this.themeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnalysisRequest)) {
            return false;
        }
        CreateAnalysisRequest other = (CreateAnalysisRequest)((Object)obj);
        return Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.analysisId(), other.analysisId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.parameters(), other.parameters()) && this.hasPermissions() == other.hasPermissions() && Objects.equals(this.permissions(), other.permissions()) && Objects.equals(this.sourceEntity(), other.sourceEntity()) && Objects.equals(this.themeArn(), other.themeArn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAnalysisRequest").add("AwsAccountId", (Object)this.awsAccountId()).add("AnalysisId", (Object)this.analysisId()).add("Name", (Object)this.name()).add("Parameters", (Object)this.parameters()).add("Permissions", this.hasPermissions() ? this.permissions() : null).add("SourceEntity", (Object)this.sourceEntity()).add("ThemeArn", (Object)this.themeArn()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "AnalysisId": {
                return Optional.ofNullable(clazz.cast(this.analysisId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "Permissions": {
                return Optional.ofNullable(clazz.cast(this.permissions()));
            }
            case "SourceEntity": {
                return Optional.ofNullable(clazz.cast(this.sourceEntity()));
            }
            case "ThemeArn": {
                return Optional.ofNullable(clazz.cast(this.themeArn()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAnalysisRequest, T> g) {
        return obj -> g.apply((CreateAnalysisRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String awsAccountId;
        private String analysisId;
        private String name;
        private Parameters parameters;
        private List<ResourcePermission> permissions = DefaultSdkAutoConstructList.getInstance();
        private AnalysisSourceEntity sourceEntity;
        private String themeArn;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnalysisRequest model) {
            super(model);
            this.awsAccountId(model.awsAccountId);
            this.analysisId(model.analysisId);
            this.name(model.name);
            this.parameters(model.parameters);
            this.permissions(model.permissions);
            this.sourceEntity(model.sourceEntity);
            this.themeArn(model.themeArn);
            this.tags(model.tags);
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getAnalysisId() {
            return this.analysisId;
        }

        @Override
        public final Builder analysisId(String analysisId) {
            this.analysisId = analysisId;
            return this;
        }

        public final void setAnalysisId(String analysisId) {
            this.analysisId = analysisId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Parameters.Builder getParameters() {
            return this.parameters != null ? this.parameters.toBuilder() : null;
        }

        @Override
        public final Builder parameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public final void setParameters(Parameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        public final Collection<ResourcePermission.Builder> getPermissions() {
            if (this.permissions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.permissions != null ? (Collection)this.permissions.stream().map(ResourcePermission::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder permissions(Collection<ResourcePermission> permissions) {
            this.permissions = ResourcePermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(ResourcePermission ... permissions) {
            this.permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<ResourcePermission.Builder> ... permissions) {
            this.permissions(Stream.of(permissions).map(c -> (ResourcePermission)((ResourcePermission.Builder)ResourcePermission.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPermissions(Collection<ResourcePermission.BuilderImpl> permissions) {
            this.permissions = ResourcePermissionListCopier.copyFromBuilder(permissions);
        }

        public final AnalysisSourceEntity.Builder getSourceEntity() {
            return this.sourceEntity != null ? this.sourceEntity.toBuilder() : null;
        }

        @Override
        public final Builder sourceEntity(AnalysisSourceEntity sourceEntity) {
            this.sourceEntity = sourceEntity;
            return this;
        }

        public final void setSourceEntity(AnalysisSourceEntity.BuilderImpl sourceEntity) {
            this.sourceEntity = sourceEntity != null ? sourceEntity.build() : null;
        }

        public final String getThemeArn() {
            return this.themeArn;
        }

        @Override
        public final Builder themeArn(String themeArn) {
            this.themeArn = themeArn;
            return this;
        }

        public final void setThemeArn(String themeArn) {
            this.themeArn = themeArn;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAnalysisRequest build() {
            return new CreateAnalysisRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAnalysisRequest> {
        public Builder awsAccountId(String var1);

        public Builder analysisId(String var1);

        public Builder name(String var1);

        public Builder parameters(Parameters var1);

        default public Builder parameters(Consumer<Parameters.Builder> parameters) {
            return this.parameters((Parameters)((Parameters.Builder)Parameters.builder().applyMutation(parameters)).build());
        }

        public Builder permissions(Collection<ResourcePermission> var1);

        public Builder permissions(ResourcePermission ... var1);

        public Builder permissions(Consumer<ResourcePermission.Builder> ... var1);

        public Builder sourceEntity(AnalysisSourceEntity var1);

        default public Builder sourceEntity(Consumer<AnalysisSourceEntity.Builder> sourceEntity) {
            return this.sourceEntity((AnalysisSourceEntity)((AnalysisSourceEntity.Builder)AnalysisSourceEntity.builder().applyMutation(sourceEntity)).build());
        }

        public Builder themeArn(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

