/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccountCustomizationRequest extends QuickSightRequest implements
        ToCopyableBuilder<DescribeAccountCustomizationRequest.Builder, DescribeAccountCustomizationRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(DescribeAccountCustomizationRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(DescribeAccountCustomizationRequest::namespace))
            .setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("namespace").build()).build();

    private static final SdkField<Boolean> RESOLVED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Resolved").getter(getter(DescribeAccountCustomizationRequest::resolved))
            .setter(setter(Builder::resolved))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resolved").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            NAMESPACE_FIELD, RESOLVED_FIELD));

    private final String awsAccountId;

    private final String namespace;

    private final Boolean resolved;

    private DescribeAccountCustomizationRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.namespace = builder.namespace;
        this.resolved = builder.resolved;
    }

    /**
     * <p>
     * The ID for the AWS account that you want to describe QuickSight customizations for.
     * </p>
     * 
     * @return The ID for the AWS account that you want to describe QuickSight customizations for.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The QuickSight namespace that you want to describe QuickSight customizations for.
     * </p>
     * 
     * @return The QuickSight namespace that you want to describe QuickSight customizations for.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The <code>Resolved</code> flag works with the other parameters to determine which view of QuickSight
     * customizations is returned. You can add this flag to your command to use the same view that QuickSight uses to
     * identify which customizations to apply to the console. Omit this flag, or set it to <code>no-resolved</code>, to
     * reveal customizations that are configured at different levels.
     * </p>
     * 
     * @return The <code>Resolved</code> flag works with the other parameters to determine which view of QuickSight
     *         customizations is returned. You can add this flag to your command to use the same view that QuickSight
     *         uses to identify which customizations to apply to the console. Omit this flag, or set it to
     *         <code>no-resolved</code>, to reveal customizations that are configured at different levels.
     */
    public final Boolean resolved() {
        return resolved;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(resolved());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountCustomizationRequest)) {
            return false;
        }
        DescribeAccountCustomizationRequest other = (DescribeAccountCustomizationRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(namespace(), other.namespace())
                && Objects.equals(resolved(), other.resolved());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAccountCustomizationRequest").add("AwsAccountId", awsAccountId())
                .add("Namespace", namespace()).add("Resolved", resolved()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "Resolved":
            return Optional.ofNullable(clazz.cast(resolved()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountCustomizationRequest, T> g) {
        return obj -> g.apply((DescribeAccountCustomizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAccountCustomizationRequest> {
        /**
         * <p>
         * The ID for the AWS account that you want to describe QuickSight customizations for.
         * </p>
         * 
         * @param awsAccountId
         *        The ID for the AWS account that you want to describe QuickSight customizations for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The QuickSight namespace that you want to describe QuickSight customizations for.
         * </p>
         * 
         * @param namespace
         *        The QuickSight namespace that you want to describe QuickSight customizations for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The <code>Resolved</code> flag works with the other parameters to determine which view of QuickSight
         * customizations is returned. You can add this flag to your command to use the same view that QuickSight uses
         * to identify which customizations to apply to the console. Omit this flag, or set it to
         * <code>no-resolved</code>, to reveal customizations that are configured at different levels.
         * </p>
         * 
         * @param resolved
         *        The <code>Resolved</code> flag works with the other parameters to determine which view of QuickSight
         *        customizations is returned. You can add this flag to your command to use the same view that QuickSight
         *        uses to identify which customizations to apply to the console. Omit this flag, or set it to
         *        <code>no-resolved</code>, to reveal customizations that are configured at different levels.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolved(Boolean resolved);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String namespace;

        private Boolean resolved;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountCustomizationRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            namespace(model.namespace);
            resolved(model.resolved);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getNamespace() {
            return namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final Boolean getResolved() {
            return resolved;
        }

        @Override
        public final Builder resolved(Boolean resolved) {
            this.resolved = resolved;
            return this;
        }

        public final void setResolved(Boolean resolved) {
            this.resolved = resolved;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAccountCustomizationRequest build() {
            return new DescribeAccountCustomizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
