/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAnalysisResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DeleteAnalysisResponse> {
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(DeleteAnalysisResponse.getter(DeleteAnalysisResponse::status)).setter(DeleteAnalysisResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DeleteAnalysisResponse.getter(DeleteAnalysisResponse::arn)).setter(DeleteAnalysisResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ANALYSIS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisId").getter(DeleteAnalysisResponse.getter(DeleteAnalysisResponse::analysisId)).setter(DeleteAnalysisResponse.setter(Builder::analysisId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisId").build()}).build();
    private static final SdkField<Instant> DELETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("DeletionTime").getter(DeleteAnalysisResponse.getter(DeleteAnalysisResponse::deletionTime)).setter(DeleteAnalysisResponse.setter(Builder::deletionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionTime").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(DeleteAnalysisResponse.getter(DeleteAnalysisResponse::requestId)).setter(DeleteAnalysisResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ARN_FIELD, ANALYSIS_ID_FIELD, DELETION_TIME_FIELD, REQUEST_ID_FIELD));
    private final Integer status;
    private final String arn;
    private final String analysisId;
    private final Instant deletionTime;
    private final String requestId;

    private DeleteAnalysisResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.arn = builder.arn;
        this.analysisId = builder.analysisId;
        this.deletionTime = builder.deletionTime;
        this.requestId = builder.requestId;
    }

    public Integer status() {
        return this.status;
    }

    public String arn() {
        return this.arn;
    }

    public String analysisId() {
        return this.analysisId;
    }

    public Instant deletionTime() {
        return this.deletionTime;
    }

    public String requestId() {
        return this.requestId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAnalysisResponse)) {
            return false;
        }
        DeleteAnalysisResponse other = (DeleteAnalysisResponse)((Object)obj);
        return Objects.equals(this.status(), other.status()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.analysisId(), other.analysisId()) && Objects.equals(this.deletionTime(), other.deletionTime()) && Objects.equals(this.requestId(), other.requestId());
    }

    public String toString() {
        return ToString.builder((String)"DeleteAnalysisResponse").add("Status", (Object)this.status()).add("Arn", (Object)this.arn()).add("AnalysisId", (Object)this.analysisId()).add("DeletionTime", (Object)this.deletionTime()).add("RequestId", (Object)this.requestId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AnalysisId": {
                return Optional.ofNullable(clazz.cast(this.analysisId()));
            }
            case "DeletionTime": {
                return Optional.ofNullable(clazz.cast(this.deletionTime()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAnalysisResponse, T> g) {
        return obj -> g.apply((DeleteAnalysisResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private Integer status;
        private String arn;
        private String analysisId;
        private Instant deletionTime;
        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAnalysisResponse model) {
            super(model);
            this.status(model.status);
            this.arn(model.arn);
            this.analysisId(model.analysisId);
            this.deletionTime(model.deletionTime);
            this.requestId(model.requestId);
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getAnalysisId() {
            return this.analysisId;
        }

        @Override
        public final Builder analysisId(String analysisId) {
            this.analysisId = analysisId;
            return this;
        }

        public final void setAnalysisId(String analysisId) {
            this.analysisId = analysisId;
        }

        public final Instant getDeletionTime() {
            return this.deletionTime;
        }

        @Override
        public final Builder deletionTime(Instant deletionTime) {
            this.deletionTime = deletionTime;
            return this;
        }

        public final void setDeletionTime(Instant deletionTime) {
            this.deletionTime = deletionTime;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public DeleteAnalysisResponse build() {
            return new DeleteAnalysisResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAnalysisResponse> {
        public Builder status(Integer var1);

        public Builder arn(String var1);

        public Builder analysisId(String var1);

        public Builder deletionTime(Instant var1);

        public Builder requestId(String var1);
    }
}

