/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.AccountSettings;
import software.amazon.awssdk.services.quicksight.model.QuickSightResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAccountSettingsResponse
extends QuickSightResponse
implements ToCopyableBuilder<Builder, DescribeAccountSettingsResponse> {
    private static final SdkField<AccountSettings> ACCOUNT_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccountSettings").getter(DescribeAccountSettingsResponse.getter(DescribeAccountSettingsResponse::accountSettings)).setter(DescribeAccountSettingsResponse.setter(Builder::accountSettings)).constructor(AccountSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountSettings").build()}).build();
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequestId").getter(DescribeAccountSettingsResponse.getter(DescribeAccountSettingsResponse::requestId)).setter(DescribeAccountSettingsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()}).build();
    private static final SdkField<Integer> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Status").getter(DescribeAccountSettingsResponse.getter(DescribeAccountSettingsResponse::status)).setter(DescribeAccountSettingsResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SETTINGS_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));
    private final AccountSettings accountSettings;
    private final String requestId;
    private final Integer status;

    private DescribeAccountSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.accountSettings = builder.accountSettings;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    public AccountSettings accountSettings() {
        return this.accountSettings;
    }

    public String requestId() {
        return this.requestId;
    }

    public Integer status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountSettingsResponse)) {
            return false;
        }
        DescribeAccountSettingsResponse other = (DescribeAccountSettingsResponse)((Object)obj);
        return Objects.equals(this.accountSettings(), other.accountSettings()) && Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.status(), other.status());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAccountSettingsResponse").add("AccountSettings", (Object)this.accountSettings()).add("RequestId", (Object)this.requestId()).add("Status", (Object)this.status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountSettings": {
                return Optional.ofNullable(clazz.cast(this.accountSettings()));
            }
            case "RequestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountSettingsResponse, T> g) {
        return obj -> g.apply((DescribeAccountSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightResponse.BuilderImpl
    implements Builder {
        private AccountSettings accountSettings;
        private String requestId;
        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountSettingsResponse model) {
            super(model);
            this.accountSettings(model.accountSettings);
            this.requestId(model.requestId);
            this.status(model.status);
        }

        public final AccountSettings.Builder getAccountSettings() {
            return this.accountSettings != null ? this.accountSettings.toBuilder() : null;
        }

        @Override
        public final Builder accountSettings(AccountSettings accountSettings) {
            this.accountSettings = accountSettings;
            return this;
        }

        public final void setAccountSettings(AccountSettings.BuilderImpl accountSettings) {
            this.accountSettings = accountSettings != null ? accountSettings.build() : null;
        }

        public final String getRequestId() {
            return this.requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public final Integer getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public DescribeAccountSettingsResponse build() {
            return new DescribeAccountSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAccountSettingsResponse> {
        public Builder accountSettings(AccountSettings var1);

        default public Builder accountSettings(Consumer<AccountSettings.Builder> accountSettings) {
            return this.accountSettings((AccountSettings)((AccountSettings.Builder)AccountSettings.builder().applyMutation(accountSettings)).build());
        }

        public Builder requestId(String var1);

        public Builder status(Integer var1);
    }
}

