/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ColorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataColorPalette
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataColorPalette> {
    private static final SdkField<List<String>> COLORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Colors").getter(DataColorPalette.getter(DataColorPalette::colors)).setter(DataColorPalette.setter(Builder::colors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Colors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MIN_MAX_GRADIENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MinMaxGradient").getter(DataColorPalette.getter(DataColorPalette::minMaxGradient)).setter(DataColorPalette.setter(Builder::minMaxGradient)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinMaxGradient").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EMPTY_FILL_COLOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EmptyFillColor").getter(DataColorPalette.getter(DataColorPalette::emptyFillColor)).setter(DataColorPalette.setter(Builder::emptyFillColor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmptyFillColor").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLORS_FIELD, MIN_MAX_GRADIENT_FIELD, EMPTY_FILL_COLOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> colors;
    private final List<String> minMaxGradient;
    private final String emptyFillColor;

    private DataColorPalette(BuilderImpl builder) {
        this.colors = builder.colors;
        this.minMaxGradient = builder.minMaxGradient;
        this.emptyFillColor = builder.emptyFillColor;
    }

    public boolean hasColors() {
        return this.colors != null && !(this.colors instanceof SdkAutoConstructList);
    }

    public List<String> colors() {
        return this.colors;
    }

    public boolean hasMinMaxGradient() {
        return this.minMaxGradient != null && !(this.minMaxGradient instanceof SdkAutoConstructList);
    }

    public List<String> minMaxGradient() {
        return this.minMaxGradient;
    }

    public String emptyFillColor() {
        return this.emptyFillColor;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasColors() ? this.colors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMinMaxGradient() ? this.minMaxGradient() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.emptyFillColor());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataColorPalette)) {
            return false;
        }
        DataColorPalette other = (DataColorPalette)obj;
        return this.hasColors() == other.hasColors() && Objects.equals(this.colors(), other.colors()) && this.hasMinMaxGradient() == other.hasMinMaxGradient() && Objects.equals(this.minMaxGradient(), other.minMaxGradient()) && Objects.equals(this.emptyFillColor(), other.emptyFillColor());
    }

    public String toString() {
        return ToString.builder((String)"DataColorPalette").add("Colors", this.hasColors() ? this.colors() : null).add("MinMaxGradient", this.hasMinMaxGradient() ? this.minMaxGradient() : null).add("EmptyFillColor", (Object)this.emptyFillColor()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Colors": {
                return Optional.ofNullable(clazz.cast(this.colors()));
            }
            case "MinMaxGradient": {
                return Optional.ofNullable(clazz.cast(this.minMaxGradient()));
            }
            case "EmptyFillColor": {
                return Optional.ofNullable(clazz.cast(this.emptyFillColor()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataColorPalette, T> g) {
        return obj -> g.apply((DataColorPalette)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> colors = DefaultSdkAutoConstructList.getInstance();
        private List<String> minMaxGradient = DefaultSdkAutoConstructList.getInstance();
        private String emptyFillColor;

        private BuilderImpl() {
        }

        private BuilderImpl(DataColorPalette model) {
            this.colors(model.colors);
            this.minMaxGradient(model.minMaxGradient);
            this.emptyFillColor(model.emptyFillColor);
        }

        public final Collection<String> getColors() {
            if (this.colors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.colors;
        }

        @Override
        public final Builder colors(Collection<String> colors) {
            this.colors = ColorListCopier.copy(colors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder colors(String ... colors) {
            this.colors(Arrays.asList(colors));
            return this;
        }

        public final void setColors(Collection<String> colors) {
            this.colors = ColorListCopier.copy(colors);
        }

        public final Collection<String> getMinMaxGradient() {
            if (this.minMaxGradient instanceof SdkAutoConstructList) {
                return null;
            }
            return this.minMaxGradient;
        }

        @Override
        public final Builder minMaxGradient(Collection<String> minMaxGradient) {
            this.minMaxGradient = ColorListCopier.copy(minMaxGradient);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder minMaxGradient(String ... minMaxGradient) {
            this.minMaxGradient(Arrays.asList(minMaxGradient));
            return this;
        }

        public final void setMinMaxGradient(Collection<String> minMaxGradient) {
            this.minMaxGradient = ColorListCopier.copy(minMaxGradient);
        }

        public final String getEmptyFillColor() {
            return this.emptyFillColor;
        }

        @Override
        public final Builder emptyFillColor(String emptyFillColor) {
            this.emptyFillColor = emptyFillColor;
            return this;
        }

        public final void setEmptyFillColor(String emptyFillColor) {
            this.emptyFillColor = emptyFillColor;
        }

        public DataColorPalette build() {
            return new DataColorPalette(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataColorPalette> {
        public Builder colors(Collection<String> var1);

        public Builder colors(String ... var1);

        public Builder minMaxGradient(Collection<String> var1);

        public Builder minMaxGradient(String ... var1);

        public Builder emptyFillColor(String var1);
    }
}

