/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateIngestionRequest
extends QuickSightRequest
implements ToCopyableBuilder<Builder, CreateIngestionRequest> {
    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataSetId").getter(CreateIngestionRequest.getter(CreateIngestionRequest::dataSetId)).setter(CreateIngestionRequest.setter(Builder::dataSetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DataSetId").build()}).build();
    private static final SdkField<String> INGESTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IngestionId").getter(CreateIngestionRequest.getter(CreateIngestionRequest::ingestionId)).setter(CreateIngestionRequest.setter(Builder::ingestionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("IngestionId").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(CreateIngestionRequest.getter(CreateIngestionRequest::awsAccountId)).setter(CreateIngestionRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_ID_FIELD, INGESTION_ID_FIELD, AWS_ACCOUNT_ID_FIELD));
    private final String dataSetId;
    private final String ingestionId;
    private final String awsAccountId;

    private CreateIngestionRequest(BuilderImpl builder) {
        super(builder);
        this.dataSetId = builder.dataSetId;
        this.ingestionId = builder.ingestionId;
        this.awsAccountId = builder.awsAccountId;
    }

    public String dataSetId() {
        return this.dataSetId;
    }

    public String ingestionId() {
        return this.ingestionId;
    }

    public String awsAccountId() {
        return this.awsAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ingestionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIngestionRequest)) {
            return false;
        }
        CreateIngestionRequest other = (CreateIngestionRequest)((Object)obj);
        return Objects.equals(this.dataSetId(), other.dataSetId()) && Objects.equals(this.ingestionId(), other.ingestionId()) && Objects.equals(this.awsAccountId(), other.awsAccountId());
    }

    public String toString() {
        return ToString.builder((String)"CreateIngestionRequest").add("DataSetId", (Object)this.dataSetId()).add("IngestionId", (Object)this.ingestionId()).add("AwsAccountId", (Object)this.awsAccountId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSetId": {
                return Optional.ofNullable(clazz.cast(this.dataSetId()));
            }
            case "IngestionId": {
                return Optional.ofNullable(clazz.cast(this.ingestionId()));
            }
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIngestionRequest, T> g) {
        return obj -> g.apply((CreateIngestionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QuickSightRequest.BuilderImpl
    implements Builder {
        private String dataSetId;
        private String ingestionId;
        private String awsAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIngestionRequest model) {
            super(model);
            this.dataSetId(model.dataSetId);
            this.ingestionId(model.ingestionId);
            this.awsAccountId(model.awsAccountId);
        }

        public final String getDataSetId() {
            return this.dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        public final String getIngestionId() {
            return this.ingestionId;
        }

        @Override
        public final Builder ingestionId(String ingestionId) {
            this.ingestionId = ingestionId;
            return this;
        }

        public final void setIngestionId(String ingestionId) {
            this.ingestionId = ingestionId;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIngestionRequest build() {
            return new CreateIngestionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends QuickSightRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateIngestionRequest> {
        public Builder dataSetId(String var1);

        public Builder ingestionId(String var1);

        public Builder awsAccountId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

