/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActiveIAMPolicyAssignment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActiveIAMPolicyAssignment> {
    private static final SdkField<String> ASSIGNMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssignmentName").getter(ActiveIAMPolicyAssignment.getter(ActiveIAMPolicyAssignment::assignmentName)).setter(ActiveIAMPolicyAssignment.setter(Builder::assignmentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentName").build()}).build();
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyArn").getter(ActiveIAMPolicyAssignment.getter(ActiveIAMPolicyAssignment::policyArn)).setter(ActiveIAMPolicyAssignment.setter(Builder::policyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSIGNMENT_NAME_FIELD, POLICY_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String assignmentName;
    private final String policyArn;

    private ActiveIAMPolicyAssignment(BuilderImpl builder) {
        this.assignmentName = builder.assignmentName;
        this.policyArn = builder.policyArn;
    }

    public String assignmentName() {
        return this.assignmentName;
    }

    public String policyArn() {
        return this.policyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assignmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveIAMPolicyAssignment)) {
            return false;
        }
        ActiveIAMPolicyAssignment other = (ActiveIAMPolicyAssignment)obj;
        return Objects.equals(this.assignmentName(), other.assignmentName()) && Objects.equals(this.policyArn(), other.policyArn());
    }

    public String toString() {
        return ToString.builder((String)"ActiveIAMPolicyAssignment").add("AssignmentName", (Object)this.assignmentName()).add("PolicyArn", (Object)this.policyArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssignmentName": {
                return Optional.ofNullable(clazz.cast(this.assignmentName()));
            }
            case "PolicyArn": {
                return Optional.ofNullable(clazz.cast(this.policyArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActiveIAMPolicyAssignment, T> g) {
        return obj -> g.apply((ActiveIAMPolicyAssignment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assignmentName;
        private String policyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveIAMPolicyAssignment model) {
            this.assignmentName(model.assignmentName);
            this.policyArn(model.policyArn);
        }

        public final String getAssignmentName() {
            return this.assignmentName;
        }

        @Override
        public final Builder assignmentName(String assignmentName) {
            this.assignmentName = assignmentName;
            return this;
        }

        public final void setAssignmentName(String assignmentName) {
            this.assignmentName = assignmentName;
        }

        public final String getPolicyArn() {
            return this.policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        public ActiveIAMPolicyAssignment build() {
            return new ActiveIAMPolicyAssignment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActiveIAMPolicyAssignment> {
        public Builder assignmentName(String var1);

        public Builder policyArn(String var1);
    }
}

