/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SnowflakeParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SnowflakeParameters> {
    private static final SdkField<String> HOST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SnowflakeParameters.getter(SnowflakeParameters::host)).setter(SnowflakeParameters.setter(Builder::host)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SnowflakeParameters.getter(SnowflakeParameters::database)).setter(SnowflakeParameters.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()}).build();
    private static final SdkField<String> WAREHOUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(SnowflakeParameters.getter(SnowflakeParameters::warehouse)).setter(SnowflakeParameters.setter(Builder::warehouse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warehouse").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD, DATABASE_FIELD, WAREHOUSE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String host;
    private final String database;
    private final String warehouse;

    private SnowflakeParameters(BuilderImpl builder) {
        this.host = builder.host;
        this.database = builder.database;
        this.warehouse = builder.warehouse;
    }

    public String host() {
        return this.host;
    }

    public String database() {
        return this.database;
    }

    public String warehouse() {
        return this.warehouse;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.host());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.warehouse());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeParameters)) {
            return false;
        }
        SnowflakeParameters other = (SnowflakeParameters)obj;
        return Objects.equals(this.host(), other.host()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.warehouse(), other.warehouse());
    }

    public String toString() {
        return ToString.builder((String)"SnowflakeParameters").add("Host", (Object)this.host()).add("Database", (Object)this.database()).add("Warehouse", (Object)this.warehouse()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Host": {
                return Optional.ofNullable(clazz.cast(this.host()));
            }
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "Warehouse": {
                return Optional.ofNullable(clazz.cast(this.warehouse()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnowflakeParameters, T> g) {
        return obj -> g.apply((SnowflakeParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String host;
        private String database;
        private String warehouse;

        private BuilderImpl() {
        }

        private BuilderImpl(SnowflakeParameters model) {
            this.host(model.host);
            this.database(model.database);
            this.warehouse(model.warehouse);
        }

        public final String getHost() {
            return this.host;
        }

        @Override
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        public final String getDatabase() {
            return this.database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        public final String getWarehouse() {
            return this.warehouse;
        }

        @Override
        public final Builder warehouse(String warehouse) {
            this.warehouse = warehouse;
            return this;
        }

        public final void setWarehouse(String warehouse) {
            this.warehouse = warehouse;
        }

        public SnowflakeParameters build() {
            return new SnowflakeParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SnowflakeParameters> {
        public Builder host(String var1);

        public Builder database(String var1);

        public Builder warehouse(String var1);
    }
}

