/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ThemeAlias
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ThemeAlias> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ThemeAlias.getter(ThemeAlias::arn)).setter(ThemeAlias.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ALIAS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ThemeAlias.getter(ThemeAlias::aliasName)).setter(ThemeAlias.setter(Builder::aliasName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasName").build()}).build();
    private static final SdkField<Long> THEME_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(ThemeAlias.getter(ThemeAlias::themeVersionNumber)).setter(ThemeAlias.setter(Builder::themeVersionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeVersionNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ALIAS_NAME_FIELD, THEME_VERSION_NUMBER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String aliasName;
    private final Long themeVersionNumber;

    private ThemeAlias(BuilderImpl builder) {
        this.arn = builder.arn;
        this.aliasName = builder.aliasName;
        this.themeVersionNumber = builder.themeVersionNumber;
    }

    public String arn() {
        return this.arn;
    }

    public String aliasName() {
        return this.aliasName;
    }

    public Long themeVersionNumber() {
        return this.themeVersionNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.aliasName());
        hashCode = 31 * hashCode + Objects.hashCode(this.themeVersionNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThemeAlias)) {
            return false;
        }
        ThemeAlias other = (ThemeAlias)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.aliasName(), other.aliasName()) && Objects.equals(this.themeVersionNumber(), other.themeVersionNumber());
    }

    public String toString() {
        return ToString.builder((String)"ThemeAlias").add("Arn", (Object)this.arn()).add("AliasName", (Object)this.aliasName()).add("ThemeVersionNumber", (Object)this.themeVersionNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "AliasName": {
                return Optional.ofNullable(clazz.cast(this.aliasName()));
            }
            case "ThemeVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.themeVersionNumber()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThemeAlias, T> g) {
        return obj -> g.apply((ThemeAlias)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String aliasName;
        private Long themeVersionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(ThemeAlias model) {
            this.arn(model.arn);
            this.aliasName(model.aliasName);
            this.themeVersionNumber(model.themeVersionNumber);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getAliasName() {
            return this.aliasName;
        }

        @Override
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        public final Long getThemeVersionNumber() {
            return this.themeVersionNumber;
        }

        @Override
        public final Builder themeVersionNumber(Long themeVersionNumber) {
            this.themeVersionNumber = themeVersionNumber;
            return this;
        }

        public final void setThemeVersionNumber(Long themeVersionNumber) {
            this.themeVersionNumber = themeVersionNumber;
        }

        public ThemeAlias build() {
            return new ThemeAlias(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ThemeAlias> {
        public Builder arn(String var1);

        public Builder aliasName(String var1);

        public Builder themeVersionNumber(Long var1);
    }
}

