/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.quicksight.QuickSightAsyncClient;
import software.amazon.awssdk.services.quicksight.model.ListDataSetsRequest;
import software.amazon.awssdk.services.quicksight.model.ListDataSetsResponse;

public class ListDataSetsPublisher
implements SdkPublisher<ListDataSetsResponse> {
    private final QuickSightAsyncClient client;
    private final ListDataSetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDataSetsPublisher(QuickSightAsyncClient client, ListDataSetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDataSetsPublisher(QuickSightAsyncClient client, ListDataSetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDataSetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDataSetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListDataSetsResponseFetcher
    implements AsyncPageFetcher<ListDataSetsResponse> {
        private ListDataSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDataSetsResponse> nextPage(ListDataSetsResponse previousPage) {
            if (previousPage == null) {
                return ListDataSetsPublisher.this.client.listDataSets(ListDataSetsPublisher.this.firstRequest);
            }
            return ListDataSetsPublisher.this.client.listDataSets((ListDataSetsRequest)((Object)ListDataSetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

