/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum IdentityStore {
    QUICKSIGHT("QUICKSIGHT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private IdentityStore(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IdentityStore fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(IdentityStore.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IdentityStore> knownValues() {
        return Stream.of(IdentityStore.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

