/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSetReference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSetReference> {
    private static final SdkField<String> DATA_SET_PLACEHOLDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DataSetReference.getter(DataSetReference::dataSetPlaceholder)).setter(DataSetReference.setter(Builder::dataSetPlaceholder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetPlaceholder").build()}).build();
    private static final SdkField<String> DATA_SET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DataSetReference.getter(DataSetReference::dataSetArn)).setter(DataSetReference.setter(Builder::dataSetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_PLACEHOLDER_FIELD, DATA_SET_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dataSetPlaceholder;
    private final String dataSetArn;

    private DataSetReference(BuilderImpl builder) {
        this.dataSetPlaceholder = builder.dataSetPlaceholder;
        this.dataSetArn = builder.dataSetArn;
    }

    public String dataSetPlaceholder() {
        return this.dataSetPlaceholder;
    }

    public String dataSetArn() {
        return this.dataSetArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetPlaceholder());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSetArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSetReference)) {
            return false;
        }
        DataSetReference other = (DataSetReference)obj;
        return Objects.equals(this.dataSetPlaceholder(), other.dataSetPlaceholder()) && Objects.equals(this.dataSetArn(), other.dataSetArn());
    }

    public String toString() {
        return ToString.builder((String)"DataSetReference").add("DataSetPlaceholder", (Object)this.dataSetPlaceholder()).add("DataSetArn", (Object)this.dataSetArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataSetPlaceholder": {
                return Optional.ofNullable(clazz.cast(this.dataSetPlaceholder()));
            }
            case "DataSetArn": {
                return Optional.ofNullable(clazz.cast(this.dataSetArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSetReference, T> g) {
        return obj -> g.apply((DataSetReference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataSetPlaceholder;
        private String dataSetArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSetReference model) {
            this.dataSetPlaceholder(model.dataSetPlaceholder);
            this.dataSetArn(model.dataSetArn);
        }

        public final String getDataSetPlaceholder() {
            return this.dataSetPlaceholder;
        }

        @Override
        public final Builder dataSetPlaceholder(String dataSetPlaceholder) {
            this.dataSetPlaceholder = dataSetPlaceholder;
            return this;
        }

        public final void setDataSetPlaceholder(String dataSetPlaceholder) {
            this.dataSetPlaceholder = dataSetPlaceholder;
        }

        public final String getDataSetArn() {
            return this.dataSetArn;
        }

        @Override
        public final Builder dataSetArn(String dataSetArn) {
            this.dataSetArn = dataSetArn;
            return this;
        }

        public final void setDataSetArn(String dataSetArn) {
            this.dataSetArn = dataSetArn;
        }

        public DataSetReference build() {
            return new DataSetReference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSetReference> {
        public Builder dataSetPlaceholder(String var1);

        public Builder dataSetArn(String var1);
    }
}

