/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DashboardUIState {
    EXPANDED("EXPANDED"),
    COLLAPSED("COLLAPSED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DashboardUIState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DashboardUIState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DashboardUIState.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DashboardUIState> knownValues() {
        return Stream.of(DashboardUIState.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

