/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.ColumnGroupColumnSchema;
import software.amazon.awssdk.services.quicksight.model.ColumnGroupColumnSchemaListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ColumnGroupSchema
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ColumnGroupSchema> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ColumnGroupSchema.getter(ColumnGroupSchema::name)).setter(ColumnGroupSchema.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<ColumnGroupColumnSchema>> COLUMN_GROUP_COLUMN_SCHEMA_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ColumnGroupSchema.getter(ColumnGroupSchema::columnGroupColumnSchemaList)).setter(ColumnGroupSchema.setter(Builder::columnGroupColumnSchemaList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnGroupColumnSchemaList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ColumnGroupColumnSchema::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, COLUMN_GROUP_COLUMN_SCHEMA_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<ColumnGroupColumnSchema> columnGroupColumnSchemaList;

    private ColumnGroupSchema(BuilderImpl builder) {
        this.name = builder.name;
        this.columnGroupColumnSchemaList = builder.columnGroupColumnSchemaList;
    }

    public String name() {
        return this.name;
    }

    public boolean hasColumnGroupColumnSchemaList() {
        return this.columnGroupColumnSchemaList != null && !(this.columnGroupColumnSchemaList instanceof SdkAutoConstructList);
    }

    public List<ColumnGroupColumnSchema> columnGroupColumnSchemaList() {
        return this.columnGroupColumnSchemaList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.columnGroupColumnSchemaList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnGroupSchema)) {
            return false;
        }
        ColumnGroupSchema other = (ColumnGroupSchema)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.columnGroupColumnSchemaList(), other.columnGroupColumnSchemaList());
    }

    public String toString() {
        return ToString.builder((String)"ColumnGroupSchema").add("Name", (Object)this.name()).add("ColumnGroupColumnSchemaList", this.columnGroupColumnSchemaList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ColumnGroupColumnSchemaList": {
                return Optional.ofNullable(clazz.cast(this.columnGroupColumnSchemaList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ColumnGroupSchema, T> g) {
        return obj -> g.apply((ColumnGroupSchema)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<ColumnGroupColumnSchema> columnGroupColumnSchemaList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnGroupSchema model) {
            this.name(model.name);
            this.columnGroupColumnSchemaList(model.columnGroupColumnSchemaList);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<ColumnGroupColumnSchema.Builder> getColumnGroupColumnSchemaList() {
            return this.columnGroupColumnSchemaList != null ? (Collection)this.columnGroupColumnSchemaList.stream().map(ColumnGroupColumnSchema::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder columnGroupColumnSchemaList(Collection<ColumnGroupColumnSchema> columnGroupColumnSchemaList) {
            this.columnGroupColumnSchemaList = ColumnGroupColumnSchemaListCopier.copy(columnGroupColumnSchemaList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnGroupColumnSchemaList(ColumnGroupColumnSchema ... columnGroupColumnSchemaList) {
            this.columnGroupColumnSchemaList(Arrays.asList(columnGroupColumnSchemaList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder columnGroupColumnSchemaList(Consumer<ColumnGroupColumnSchema.Builder> ... columnGroupColumnSchemaList) {
            this.columnGroupColumnSchemaList(Stream.of(columnGroupColumnSchemaList).map(c -> (ColumnGroupColumnSchema)((ColumnGroupColumnSchema.Builder)ColumnGroupColumnSchema.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setColumnGroupColumnSchemaList(Collection<ColumnGroupColumnSchema.BuilderImpl> columnGroupColumnSchemaList) {
            this.columnGroupColumnSchemaList = ColumnGroupColumnSchemaListCopier.copyFromBuilder(columnGroupColumnSchemaList);
        }

        public ColumnGroupSchema build() {
            return new ColumnGroupSchema(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ColumnGroupSchema> {
        public Builder name(String var1);

        public Builder columnGroupColumnSchemaList(Collection<ColumnGroupColumnSchema> var1);

        public Builder columnGroupColumnSchemaList(ColumnGroupColumnSchema ... var1);

        public Builder columnGroupColumnSchemaList(Consumer<ColumnGroupColumnSchema.Builder> ... var1);
    }
}

