/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ExceptionResourceType {
    USER("USER"),
    GROUP("GROUP"),
    NAMESPACE("NAMESPACE"),
    DATA_SOURCE("DATA_SOURCE"),
    DATA_SET("DATA_SET"),
    VPC_CONNECTION("VPC_CONNECTION"),
    INGESTION("INGESTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ExceptionResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExceptionResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ExceptionResourceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExceptionResourceType> knownValues() {
        return Stream.of(ExceptionResourceType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

