/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qldb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The information about an Amazon QLDB journal stream, including the Amazon Resource Name (ARN), stream name, creation
 * time, current status, and the parameters of your original stream creation request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JournalKinesisStreamDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<JournalKinesisStreamDescription.Builder, JournalKinesisStreamDescription> {
    private static final SdkField<String> LEDGER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LedgerName").getter(getter(JournalKinesisStreamDescription::ledgerName))
            .setter(setter(Builder::ledgerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LedgerName").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(JournalKinesisStreamDescription::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> INCLUSIVE_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("InclusiveStartTime").getter(getter(JournalKinesisStreamDescription::inclusiveStartTime))
            .setter(setter(Builder::inclusiveStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusiveStartTime").build())
            .build();

    private static final SdkField<Instant> EXCLUSIVE_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExclusiveEndTime").getter(getter(JournalKinesisStreamDescription::exclusiveEndTime))
            .setter(setter(Builder::exclusiveEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExclusiveEndTime").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(JournalKinesisStreamDescription::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> STREAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamId").getter(getter(JournalKinesisStreamDescription::streamId)).setter(setter(Builder::streamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(JournalKinesisStreamDescription::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(JournalKinesisStreamDescription::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<KinesisConfiguration> KINESIS_CONFIGURATION_FIELD = SdkField
            .<KinesisConfiguration> builder(MarshallingType.SDK_POJO).memberName("KinesisConfiguration")
            .getter(getter(JournalKinesisStreamDescription::kinesisConfiguration)).setter(setter(Builder::kinesisConfiguration))
            .constructor(KinesisConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisConfiguration").build())
            .build();

    private static final SdkField<String> ERROR_CAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ErrorCause").getter(getter(JournalKinesisStreamDescription::errorCauseAsString))
            .setter(setter(Builder::errorCause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCause").build()).build();

    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(JournalKinesisStreamDescription::streamName))
            .setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEDGER_NAME_FIELD,
            CREATION_TIME_FIELD, INCLUSIVE_START_TIME_FIELD, EXCLUSIVE_END_TIME_FIELD, ROLE_ARN_FIELD, STREAM_ID_FIELD,
            ARN_FIELD, STATUS_FIELD, KINESIS_CONFIGURATION_FIELD, ERROR_CAUSE_FIELD, STREAM_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ledgerName;

    private final Instant creationTime;

    private final Instant inclusiveStartTime;

    private final Instant exclusiveEndTime;

    private final String roleArn;

    private final String streamId;

    private final String arn;

    private final String status;

    private final KinesisConfiguration kinesisConfiguration;

    private final String errorCause;

    private final String streamName;

    private JournalKinesisStreamDescription(BuilderImpl builder) {
        this.ledgerName = builder.ledgerName;
        this.creationTime = builder.creationTime;
        this.inclusiveStartTime = builder.inclusiveStartTime;
        this.exclusiveEndTime = builder.exclusiveEndTime;
        this.roleArn = builder.roleArn;
        this.streamId = builder.streamId;
        this.arn = builder.arn;
        this.status = builder.status;
        this.kinesisConfiguration = builder.kinesisConfiguration;
        this.errorCause = builder.errorCause;
        this.streamName = builder.streamName;
    }

    /**
     * <p>
     * The name of the ledger.
     * </p>
     * 
     * @return The name of the ledger.
     */
    public final String ledgerName() {
        return ledgerName;
    }

    /**
     * <p>
     * The date and time, in epoch time format, when the QLDB journal stream was created. (Epoch time format is the
     * number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
     * </p>
     * 
     * @return The date and time, in epoch time format, when the QLDB journal stream was created. (Epoch time format is
     *         the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The inclusive start date and time from which to start streaming journal data.
     * </p>
     * 
     * @return The inclusive start date and time from which to start streaming journal data.
     */
    public final Instant inclusiveStartTime() {
        return inclusiveStartTime;
    }

    /**
     * <p>
     * The exclusive date and time that specifies when the stream ends. If this parameter is blank, the stream runs
     * indefinitely until you cancel it.
     * </p>
     * 
     * @return The exclusive date and time that specifies when the stream ends. If this parameter is blank, the stream
     *         runs indefinitely until you cancel it.
     */
    public final Instant exclusiveEndTime() {
        return exclusiveEndTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal stream to write data
     * records to a Kinesis Data Streams resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal stream to write
     *         data records to a Kinesis Data Streams resource.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The unique ID that QLDB assigns to each QLDB journal stream.
     * </p>
     * 
     * @return The unique ID that QLDB assigns to each QLDB journal stream.
     */
    public final String streamId() {
        return streamId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the QLDB journal stream.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the QLDB journal stream.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The current state of the QLDB journal stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StreamStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the QLDB journal stream.
     * @see StreamStatus
     */
    public final StreamStatus status() {
        return StreamStatus.fromValue(status);
    }

    /**
     * <p>
     * The current state of the QLDB journal stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StreamStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the QLDB journal stream.
     * @see StreamStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The configuration settings of the Amazon Kinesis Data Streams destination for your QLDB journal stream.
     * </p>
     * 
     * @return The configuration settings of the Amazon Kinesis Data Streams destination for your QLDB journal stream.
     */
    public final KinesisConfiguration kinesisConfiguration() {
        return kinesisConfiguration;
    }

    /**
     * <p>
     * The error message that describes the reason that a stream has a status of <code>IMPAIRED</code> or
     * <code>FAILED</code>. This is not applicable to streams that have other status values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCause} will
     * return {@link ErrorCause#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCauseAsString}.
     * </p>
     * 
     * @return The error message that describes the reason that a stream has a status of <code>IMPAIRED</code> or
     *         <code>FAILED</code>. This is not applicable to streams that have other status values.
     * @see ErrorCause
     */
    public final ErrorCause errorCause() {
        return ErrorCause.fromValue(errorCause);
    }

    /**
     * <p>
     * The error message that describes the reason that a stream has a status of <code>IMPAIRED</code> or
     * <code>FAILED</code>. This is not applicable to streams that have other status values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCause} will
     * return {@link ErrorCause#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorCauseAsString}.
     * </p>
     * 
     * @return The error message that describes the reason that a stream has a status of <code>IMPAIRED</code> or
     *         <code>FAILED</code>. This is not applicable to streams that have other status values.
     * @see ErrorCause
     */
    public final String errorCauseAsString() {
        return errorCause;
    }

    /**
     * <p>
     * The user-defined name of the QLDB journal stream.
     * </p>
     * 
     * @return The user-defined name of the QLDB journal stream.
     */
    public final String streamName() {
        return streamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ledgerName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(inclusiveStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(exclusiveEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(streamId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kinesisConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(errorCauseAsString());
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JournalKinesisStreamDescription)) {
            return false;
        }
        JournalKinesisStreamDescription other = (JournalKinesisStreamDescription) obj;
        return Objects.equals(ledgerName(), other.ledgerName()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(inclusiveStartTime(), other.inclusiveStartTime())
                && Objects.equals(exclusiveEndTime(), other.exclusiveEndTime()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(streamId(), other.streamId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(kinesisConfiguration(), other.kinesisConfiguration())
                && Objects.equals(errorCauseAsString(), other.errorCauseAsString())
                && Objects.equals(streamName(), other.streamName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JournalKinesisStreamDescription").add("LedgerName", ledgerName())
                .add("CreationTime", creationTime()).add("InclusiveStartTime", inclusiveStartTime())
                .add("ExclusiveEndTime", exclusiveEndTime()).add("RoleArn", roleArn()).add("StreamId", streamId())
                .add("Arn", arn()).add("Status", statusAsString()).add("KinesisConfiguration", kinesisConfiguration())
                .add("ErrorCause", errorCauseAsString()).add("StreamName", streamName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LedgerName":
            return Optional.ofNullable(clazz.cast(ledgerName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "InclusiveStartTime":
            return Optional.ofNullable(clazz.cast(inclusiveStartTime()));
        case "ExclusiveEndTime":
            return Optional.ofNullable(clazz.cast(exclusiveEndTime()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "StreamId":
            return Optional.ofNullable(clazz.cast(streamId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "KinesisConfiguration":
            return Optional.ofNullable(clazz.cast(kinesisConfiguration()));
        case "ErrorCause":
            return Optional.ofNullable(clazz.cast(errorCauseAsString()));
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JournalKinesisStreamDescription, T> g) {
        return obj -> g.apply((JournalKinesisStreamDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JournalKinesisStreamDescription> {
        /**
         * <p>
         * The name of the ledger.
         * </p>
         * 
         * @param ledgerName
         *        The name of the ledger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ledgerName(String ledgerName);

        /**
         * <p>
         * The date and time, in epoch time format, when the QLDB journal stream was created. (Epoch time format is the
         * number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
         * </p>
         * 
         * @param creationTime
         *        The date and time, in epoch time format, when the QLDB journal stream was created. (Epoch time format
         *        is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The inclusive start date and time from which to start streaming journal data.
         * </p>
         * 
         * @param inclusiveStartTime
         *        The inclusive start date and time from which to start streaming journal data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusiveStartTime(Instant inclusiveStartTime);

        /**
         * <p>
         * The exclusive date and time that specifies when the stream ends. If this parameter is blank, the stream runs
         * indefinitely until you cancel it.
         * </p>
         * 
         * @param exclusiveEndTime
         *        The exclusive date and time that specifies when the stream ends. If this parameter is blank, the
         *        stream runs indefinitely until you cancel it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exclusiveEndTime(Instant exclusiveEndTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal stream to write
         * data records to a Kinesis Data Streams resource.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal stream to
         *        write data records to a Kinesis Data Streams resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The unique ID that QLDB assigns to each QLDB journal stream.
         * </p>
         * 
         * @param streamId
         *        The unique ID that QLDB assigns to each QLDB journal stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamId(String streamId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the QLDB journal stream.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the QLDB journal stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The current state of the QLDB journal stream.
         * </p>
         * 
         * @param status
         *        The current state of the QLDB journal stream.
         * @see StreamStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current state of the QLDB journal stream.
         * </p>
         * 
         * @param status
         *        The current state of the QLDB journal stream.
         * @see StreamStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamStatus
         */
        Builder status(StreamStatus status);

        /**
         * <p>
         * The configuration settings of the Amazon Kinesis Data Streams destination for your QLDB journal stream.
         * </p>
         * 
         * @param kinesisConfiguration
         *        The configuration settings of the Amazon Kinesis Data Streams destination for your QLDB journal
         *        stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kinesisConfiguration(KinesisConfiguration kinesisConfiguration);

        /**
         * <p>
         * The configuration settings of the Amazon Kinesis Data Streams destination for your QLDB journal stream.
         * </p>
         * This is a convenience that creates an instance of the {@link KinesisConfiguration.Builder} avoiding the need
         * to create one manually via {@link KinesisConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link KinesisConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #kinesisConfiguration(KinesisConfiguration)}.
         * 
         * @param kinesisConfiguration
         *        a consumer that will call methods on {@link KinesisConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kinesisConfiguration(KinesisConfiguration)
         */
        default Builder kinesisConfiguration(Consumer<KinesisConfiguration.Builder> kinesisConfiguration) {
            return kinesisConfiguration(KinesisConfiguration.builder().applyMutation(kinesisConfiguration).build());
        }

        /**
         * <p>
         * The error message that describes the reason that a stream has a status of <code>IMPAIRED</code> or
         * <code>FAILED</code>. This is not applicable to streams that have other status values.
         * </p>
         * 
         * @param errorCause
         *        The error message that describes the reason that a stream has a status of <code>IMPAIRED</code> or
         *        <code>FAILED</code>. This is not applicable to streams that have other status values.
         * @see ErrorCause
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCause
         */
        Builder errorCause(String errorCause);

        /**
         * <p>
         * The error message that describes the reason that a stream has a status of <code>IMPAIRED</code> or
         * <code>FAILED</code>. This is not applicable to streams that have other status values.
         * </p>
         * 
         * @param errorCause
         *        The error message that describes the reason that a stream has a status of <code>IMPAIRED</code> or
         *        <code>FAILED</code>. This is not applicable to streams that have other status values.
         * @see ErrorCause
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorCause
         */
        Builder errorCause(ErrorCause errorCause);

        /**
         * <p>
         * The user-defined name of the QLDB journal stream.
         * </p>
         * 
         * @param streamName
         *        The user-defined name of the QLDB journal stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);
    }

    static final class BuilderImpl implements Builder {
        private String ledgerName;

        private Instant creationTime;

        private Instant inclusiveStartTime;

        private Instant exclusiveEndTime;

        private String roleArn;

        private String streamId;

        private String arn;

        private String status;

        private KinesisConfiguration kinesisConfiguration;

        private String errorCause;

        private String streamName;

        private BuilderImpl() {
        }

        private BuilderImpl(JournalKinesisStreamDescription model) {
            ledgerName(model.ledgerName);
            creationTime(model.creationTime);
            inclusiveStartTime(model.inclusiveStartTime);
            exclusiveEndTime(model.exclusiveEndTime);
            roleArn(model.roleArn);
            streamId(model.streamId);
            arn(model.arn);
            status(model.status);
            kinesisConfiguration(model.kinesisConfiguration);
            errorCause(model.errorCause);
            streamName(model.streamName);
        }

        public final String getLedgerName() {
            return ledgerName;
        }

        @Override
        public final Builder ledgerName(String ledgerName) {
            this.ledgerName = ledgerName;
            return this;
        }

        public final void setLedgerName(String ledgerName) {
            this.ledgerName = ledgerName;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getInclusiveStartTime() {
            return inclusiveStartTime;
        }

        @Override
        public final Builder inclusiveStartTime(Instant inclusiveStartTime) {
            this.inclusiveStartTime = inclusiveStartTime;
            return this;
        }

        public final void setInclusiveStartTime(Instant inclusiveStartTime) {
            this.inclusiveStartTime = inclusiveStartTime;
        }

        public final Instant getExclusiveEndTime() {
            return exclusiveEndTime;
        }

        @Override
        public final Builder exclusiveEndTime(Instant exclusiveEndTime) {
            this.exclusiveEndTime = exclusiveEndTime;
            return this;
        }

        public final void setExclusiveEndTime(Instant exclusiveEndTime) {
            this.exclusiveEndTime = exclusiveEndTime;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getStreamId() {
            return streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StreamStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final KinesisConfiguration.Builder getKinesisConfiguration() {
            return kinesisConfiguration != null ? kinesisConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder kinesisConfiguration(KinesisConfiguration kinesisConfiguration) {
            this.kinesisConfiguration = kinesisConfiguration;
            return this;
        }

        public final void setKinesisConfiguration(KinesisConfiguration.BuilderImpl kinesisConfiguration) {
            this.kinesisConfiguration = kinesisConfiguration != null ? kinesisConfiguration.build() : null;
        }

        public final String getErrorCause() {
            return errorCause;
        }

        @Override
        public final Builder errorCause(String errorCause) {
            this.errorCause = errorCause;
            return this;
        }

        @Override
        public final Builder errorCause(ErrorCause errorCause) {
            this.errorCause(errorCause == null ? null : errorCause.toString());
            return this;
        }

        public final void setErrorCause(String errorCause) {
            this.errorCause = errorCause;
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public JournalKinesisStreamDescription build() {
            return new JournalKinesisStreamDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
