/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateQAppSessionMetadataResponse extends QAppsResponse implements
        ToCopyableBuilder<UpdateQAppSessionMetadataResponse.Builder, UpdateQAppSessionMetadataResponse> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(UpdateQAppSessionMetadataResponse::sessionId))
            .setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionArn").getter(getter(UpdateQAppSessionMetadataResponse::sessionArn))
            .setter(setter(Builder::sessionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionArn").build()).build();

    private static final SdkField<String> SESSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionName").getter(getter(UpdateQAppSessionMetadataResponse::sessionName))
            .setter(setter(Builder::sessionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionName").build()).build();

    private static final SdkField<SessionSharingConfiguration> SHARING_CONFIGURATION_FIELD = SdkField
            .<SessionSharingConfiguration> builder(MarshallingType.SDK_POJO).memberName("sharingConfiguration")
            .getter(getter(UpdateQAppSessionMetadataResponse::sharingConfiguration))
            .setter(setter(Builder::sharingConfiguration)).constructor(SessionSharingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharingConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD,
            SESSION_ARN_FIELD, SESSION_NAME_FIELD, SHARING_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sessionId;

    private final String sessionArn;

    private final String sessionName;

    private final SessionSharingConfiguration sharingConfiguration;

    private UpdateQAppSessionMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.sessionArn = builder.sessionArn;
        this.sessionName = builder.sessionName;
        this.sharingConfiguration = builder.sharingConfiguration;
    }

    /**
     * <p>
     * The unique identifier of the updated Q App session.
     * </p>
     * 
     * @return The unique identifier of the updated Q App session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the updated Q App session.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the updated Q App session.
     */
    public final String sessionArn() {
        return sessionArn;
    }

    /**
     * <p>
     * The new name of the updated Q App session.
     * </p>
     * 
     * @return The new name of the updated Q App session.
     */
    public final String sessionName() {
        return sessionName;
    }

    /**
     * <p>
     * The new sharing configuration of the updated Q App data collection session.
     * </p>
     * 
     * @return The new sharing configuration of the updated Q App data collection session.
     */
    public final SessionSharingConfiguration sharingConfiguration() {
        return sharingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(sessionName());
        hashCode = 31 * hashCode + Objects.hashCode(sharingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQAppSessionMetadataResponse)) {
            return false;
        }
        UpdateQAppSessionMetadataResponse other = (UpdateQAppSessionMetadataResponse) obj;
        return Objects.equals(sessionId(), other.sessionId()) && Objects.equals(sessionArn(), other.sessionArn())
                && Objects.equals(sessionName(), other.sessionName())
                && Objects.equals(sharingConfiguration(), other.sharingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateQAppSessionMetadataResponse").add("SessionId", sessionId())
                .add("SessionArn", sessionArn()).add("SessionName", sessionName())
                .add("SharingConfiguration", sharingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "sessionArn":
            return Optional.ofNullable(clazz.cast(sessionArn()));
        case "sessionName":
            return Optional.ofNullable(clazz.cast(sessionName()));
        case "sharingConfiguration":
            return Optional.ofNullable(clazz.cast(sharingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("sessionArn", SESSION_ARN_FIELD);
        map.put("sessionName", SESSION_NAME_FIELD);
        map.put("sharingConfiguration", SHARING_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateQAppSessionMetadataResponse, T> g) {
        return obj -> g.apply((UpdateQAppSessionMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends QAppsResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateQAppSessionMetadataResponse> {
        /**
         * <p>
         * The unique identifier of the updated Q App session.
         * </p>
         * 
         * @param sessionId
         *        The unique identifier of the updated Q App session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the updated Q App session.
         * </p>
         * 
         * @param sessionArn
         *        The Amazon Resource Name (ARN) of the updated Q App session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionArn(String sessionArn);

        /**
         * <p>
         * The new name of the updated Q App session.
         * </p>
         * 
         * @param sessionName
         *        The new name of the updated Q App session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionName(String sessionName);

        /**
         * <p>
         * The new sharing configuration of the updated Q App data collection session.
         * </p>
         * 
         * @param sharingConfiguration
         *        The new sharing configuration of the updated Q App data collection session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharingConfiguration(SessionSharingConfiguration sharingConfiguration);

        /**
         * <p>
         * The new sharing configuration of the updated Q App data collection session.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionSharingConfiguration.Builder}
         * avoiding the need to create one manually via {@link SessionSharingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionSharingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #sharingConfiguration(SessionSharingConfiguration)}.
         * 
         * @param sharingConfiguration
         *        a consumer that will call methods on {@link SessionSharingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sharingConfiguration(SessionSharingConfiguration)
         */
        default Builder sharingConfiguration(Consumer<SessionSharingConfiguration.Builder> sharingConfiguration) {
            return sharingConfiguration(SessionSharingConfiguration.builder().applyMutation(sharingConfiguration).build());
        }
    }

    static final class BuilderImpl extends QAppsResponse.BuilderImpl implements Builder {
        private String sessionId;

        private String sessionArn;

        private String sessionName;

        private SessionSharingConfiguration sharingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQAppSessionMetadataResponse model) {
            super(model);
            sessionId(model.sessionId);
            sessionArn(model.sessionArn);
            sessionName(model.sessionName);
            sharingConfiguration(model.sharingConfiguration);
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getSessionArn() {
            return sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        public final String getSessionName() {
            return sessionName;
        }

        public final void setSessionName(String sessionName) {
            this.sessionName = sessionName;
        }

        @Override
        public final Builder sessionName(String sessionName) {
            this.sessionName = sessionName;
            return this;
        }

        public final SessionSharingConfiguration.Builder getSharingConfiguration() {
            return sharingConfiguration != null ? sharingConfiguration.toBuilder() : null;
        }

        public final void setSharingConfiguration(SessionSharingConfiguration.BuilderImpl sharingConfiguration) {
            this.sharingConfiguration = sharingConfiguration != null ? sharingConfiguration.build() : null;
        }

        @Override
        public final Builder sharingConfiguration(SessionSharingConfiguration sharingConfiguration) {
            this.sharingConfiguration = sharingConfiguration;
            return this;
        }

        @Override
        public UpdateQAppSessionMetadataResponse build() {
            return new UpdateQAppSessionMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
