/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an action performed on a submission.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubmissionMutation implements SdkPojo, Serializable,
        ToCopyableBuilder<SubmissionMutation.Builder, SubmissionMutation> {
    private static final SdkField<String> SUBMISSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("submissionId").getter(getter(SubmissionMutation::submissionId)).setter(setter(Builder::submissionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submissionId").build()).build();

    private static final SdkField<String> MUTATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mutationType").getter(getter(SubmissionMutation::mutationTypeAsString))
            .setter(setter(Builder::mutationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mutationType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBMISSION_ID_FIELD,
            MUTATION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String submissionId;

    private final String mutationType;

    private SubmissionMutation(BuilderImpl builder) {
        this.submissionId = builder.submissionId;
        this.mutationType = builder.mutationType;
    }

    /**
     * <p>
     * The unique identifier of the submission.
     * </p>
     * 
     * @return The unique identifier of the submission.
     */
    public final String submissionId() {
        return submissionId;
    }

    /**
     * <p>
     * The operation that is performed on a submission.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mutationType} will
     * return {@link SubmissionMutationKind#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mutationTypeAsString}.
     * </p>
     * 
     * @return The operation that is performed on a submission.
     * @see SubmissionMutationKind
     */
    public final SubmissionMutationKind mutationType() {
        return SubmissionMutationKind.fromValue(mutationType);
    }

    /**
     * <p>
     * The operation that is performed on a submission.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mutationType} will
     * return {@link SubmissionMutationKind#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #mutationTypeAsString}.
     * </p>
     * 
     * @return The operation that is performed on a submission.
     * @see SubmissionMutationKind
     */
    public final String mutationTypeAsString() {
        return mutationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(submissionId());
        hashCode = 31 * hashCode + Objects.hashCode(mutationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmissionMutation)) {
            return false;
        }
        SubmissionMutation other = (SubmissionMutation) obj;
        return Objects.equals(submissionId(), other.submissionId())
                && Objects.equals(mutationTypeAsString(), other.mutationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubmissionMutation").add("SubmissionId", submissionId())
                .add("MutationType", mutationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "submissionId":
            return Optional.ofNullable(clazz.cast(submissionId()));
        case "mutationType":
            return Optional.ofNullable(clazz.cast(mutationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("submissionId", SUBMISSION_ID_FIELD);
        map.put("mutationType", MUTATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubmissionMutation, T> g) {
        return obj -> g.apply((SubmissionMutation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubmissionMutation> {
        /**
         * <p>
         * The unique identifier of the submission.
         * </p>
         * 
         * @param submissionId
         *        The unique identifier of the submission.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder submissionId(String submissionId);

        /**
         * <p>
         * The operation that is performed on a submission.
         * </p>
         * 
         * @param mutationType
         *        The operation that is performed on a submission.
         * @see SubmissionMutationKind
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubmissionMutationKind
         */
        Builder mutationType(String mutationType);

        /**
         * <p>
         * The operation that is performed on a submission.
         * </p>
         * 
         * @param mutationType
         *        The operation that is performed on a submission.
         * @see SubmissionMutationKind
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SubmissionMutationKind
         */
        Builder mutationType(SubmissionMutationKind mutationType);
    }

    static final class BuilderImpl implements Builder {
        private String submissionId;

        private String mutationType;

        private BuilderImpl() {
        }

        private BuilderImpl(SubmissionMutation model) {
            submissionId(model.submissionId);
            mutationType(model.mutationType);
        }

        public final String getSubmissionId() {
            return submissionId;
        }

        public final void setSubmissionId(String submissionId) {
            this.submissionId = submissionId;
        }

        @Override
        public final Builder submissionId(String submissionId) {
            this.submissionId = submissionId;
            return this;
        }

        public final String getMutationType() {
            return mutationType;
        }

        public final void setMutationType(String mutationType) {
            this.mutationType = mutationType;
        }

        @Override
        public final Builder mutationType(String mutationType) {
            this.mutationType = mutationType;
            return this;
        }

        @Override
        public final Builder mutationType(SubmissionMutationKind mutationType) {
            this.mutationType(mutationType == null ? null : mutationType.toString());
            return this;
        }

        @Override
        public SubmissionMutation build() {
            return new SubmissionMutation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
