/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A card in an Q App that integrates with a third-party plugin or service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QPluginCard implements SdkPojo, Serializable, ToCopyableBuilder<QPluginCard.Builder, QPluginCard> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(QPluginCard::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(QPluginCard::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<List<String>> DEPENDENCIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("dependencies")
            .getter(getter(QPluginCard::dependencies))
            .setter(setter(Builder::dependencies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependencies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(QPluginCard::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> PROMPT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("prompt")
            .getter(getter(QPluginCard::prompt)).setter(setter(Builder::prompt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("prompt").build()).build();

    private static final SdkField<String> PLUGIN_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pluginType").getter(getter(QPluginCard::pluginTypeAsString)).setter(setter(Builder::pluginType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginType").build()).build();

    private static final SdkField<String> PLUGIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pluginId").getter(getter(QPluginCard::pluginId)).setter(setter(Builder::pluginId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pluginId").build()).build();

    private static final SdkField<String> ACTION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionIdentifier").getter(getter(QPluginCard::actionIdentifier))
            .setter(setter(Builder::actionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TITLE_FIELD,
            DEPENDENCIES_FIELD, TYPE_FIELD, PROMPT_FIELD, PLUGIN_TYPE_FIELD, PLUGIN_ID_FIELD, ACTION_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String title;

    private final List<String> dependencies;

    private final String type;

    private final String prompt;

    private final String pluginType;

    private final String pluginId;

    private final String actionIdentifier;

    private QPluginCard(BuilderImpl builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.dependencies = builder.dependencies;
        this.type = builder.type;
        this.prompt = builder.prompt;
        this.pluginType = builder.pluginType;
        this.pluginId = builder.pluginId;
        this.actionIdentifier = builder.actionIdentifier;
    }

    /**
     * <p>
     * The unique identifier of the plugin card.
     * </p>
     * 
     * @return The unique identifier of the plugin card.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The title or label of the plugin card.
     * </p>
     * 
     * @return The title or label of the plugin card.
     */
    public final String title() {
        return title;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dependencies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDependencies() {
        return dependencies != null && !(dependencies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any dependencies or requirements for the plugin card.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDependencies} method.
     * </p>
     * 
     * @return Any dependencies or requirements for the plugin card.
     */
    public final List<String> dependencies() {
        return dependencies;
    }

    /**
     * <p>
     * The type of the card.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CardType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the card.
     * @see CardType
     */
    public final CardType type() {
        return CardType.fromValue(type);
    }

    /**
     * <p>
     * The type of the card.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CardType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the card.
     * @see CardType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The prompt or instructions displayed for the plugin card.
     * </p>
     * 
     * @return The prompt or instructions displayed for the plugin card.
     */
    public final String prompt() {
        return prompt;
    }

    /**
     * <p>
     * The type or category of the plugin used by the card.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pluginType} will
     * return {@link PluginType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pluginTypeAsString}.
     * </p>
     * 
     * @return The type or category of the plugin used by the card.
     * @see PluginType
     */
    public final PluginType pluginType() {
        return PluginType.fromValue(pluginType);
    }

    /**
     * <p>
     * The type or category of the plugin used by the card.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pluginType} will
     * return {@link PluginType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pluginTypeAsString}.
     * </p>
     * 
     * @return The type or category of the plugin used by the card.
     * @see PluginType
     */
    public final String pluginTypeAsString() {
        return pluginType;
    }

    /**
     * <p>
     * The unique identifier of the plugin used by the card.
     * </p>
     * 
     * @return The unique identifier of the plugin used by the card.
     */
    public final String pluginId() {
        return pluginId;
    }

    /**
     * <p>
     * The action identifier of the action to be performed by the plugin card.
     * </p>
     * 
     * @return The action identifier of the action to be performed by the plugin card.
     */
    public final String actionIdentifier() {
        return actionIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(hasDependencies() ? dependencies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(prompt());
        hashCode = 31 * hashCode + Objects.hashCode(pluginTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pluginId());
        hashCode = 31 * hashCode + Objects.hashCode(actionIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QPluginCard)) {
            return false;
        }
        QPluginCard other = (QPluginCard) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(title(), other.title())
                && hasDependencies() == other.hasDependencies() && Objects.equals(dependencies(), other.dependencies())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(prompt(), other.prompt())
                && Objects.equals(pluginTypeAsString(), other.pluginTypeAsString())
                && Objects.equals(pluginId(), other.pluginId()) && Objects.equals(actionIdentifier(), other.actionIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QPluginCard").add("Id", id()).add("Title", title())
                .add("Dependencies", hasDependencies() ? dependencies() : null).add("Type", typeAsString())
                .add("Prompt", prompt()).add("PluginType", pluginTypeAsString()).add("PluginId", pluginId())
                .add("ActionIdentifier", actionIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "dependencies":
            return Optional.ofNullable(clazz.cast(dependencies()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "prompt":
            return Optional.ofNullable(clazz.cast(prompt()));
        case "pluginType":
            return Optional.ofNullable(clazz.cast(pluginTypeAsString()));
        case "pluginId":
            return Optional.ofNullable(clazz.cast(pluginId()));
        case "actionIdentifier":
            return Optional.ofNullable(clazz.cast(actionIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("dependencies", DEPENDENCIES_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("prompt", PROMPT_FIELD);
        map.put("pluginType", PLUGIN_TYPE_FIELD);
        map.put("pluginId", PLUGIN_ID_FIELD);
        map.put("actionIdentifier", ACTION_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QPluginCard, T> g) {
        return obj -> g.apply((QPluginCard) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QPluginCard> {
        /**
         * <p>
         * The unique identifier of the plugin card.
         * </p>
         * 
         * @param id
         *        The unique identifier of the plugin card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The title or label of the plugin card.
         * </p>
         * 
         * @param title
         *        The title or label of the plugin card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * Any dependencies or requirements for the plugin card.
         * </p>
         * 
         * @param dependencies
         *        Any dependencies or requirements for the plugin card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencies(Collection<String> dependencies);

        /**
         * <p>
         * Any dependencies or requirements for the plugin card.
         * </p>
         * 
         * @param dependencies
         *        Any dependencies or requirements for the plugin card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencies(String... dependencies);

        /**
         * <p>
         * The type of the card.
         * </p>
         * 
         * @param type
         *        The type of the card.
         * @see CardType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CardType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the card.
         * </p>
         * 
         * @param type
         *        The type of the card.
         * @see CardType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CardType
         */
        Builder type(CardType type);

        /**
         * <p>
         * The prompt or instructions displayed for the plugin card.
         * </p>
         * 
         * @param prompt
         *        The prompt or instructions displayed for the plugin card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prompt(String prompt);

        /**
         * <p>
         * The type or category of the plugin used by the card.
         * </p>
         * 
         * @param pluginType
         *        The type or category of the plugin used by the card.
         * @see PluginType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PluginType
         */
        Builder pluginType(String pluginType);

        /**
         * <p>
         * The type or category of the plugin used by the card.
         * </p>
         * 
         * @param pluginType
         *        The type or category of the plugin used by the card.
         * @see PluginType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PluginType
         */
        Builder pluginType(PluginType pluginType);

        /**
         * <p>
         * The unique identifier of the plugin used by the card.
         * </p>
         * 
         * @param pluginId
         *        The unique identifier of the plugin used by the card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginId(String pluginId);

        /**
         * <p>
         * The action identifier of the action to be performed by the plugin card.
         * </p>
         * 
         * @param actionIdentifier
         *        The action identifier of the action to be performed by the plugin card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionIdentifier(String actionIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String title;

        private List<String> dependencies = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private String prompt;

        private String pluginType;

        private String pluginId;

        private String actionIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(QPluginCard model) {
            id(model.id);
            title(model.title);
            dependencies(model.dependencies);
            type(model.type);
            prompt(model.prompt);
            pluginType(model.pluginType);
            pluginId(model.pluginId);
            actionIdentifier(model.actionIdentifier);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Collection<String> getDependencies() {
            if (dependencies instanceof SdkAutoConstructList) {
                return null;
            }
            return dependencies;
        }

        public final void setDependencies(Collection<String> dependencies) {
            this.dependencies = DependencyListCopier.copy(dependencies);
        }

        @Override
        public final Builder dependencies(Collection<String> dependencies) {
            this.dependencies = DependencyListCopier.copy(dependencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(String... dependencies) {
            dependencies(Arrays.asList(dependencies));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CardType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getPrompt() {
            return prompt;
        }

        public final void setPrompt(String prompt) {
            this.prompt = prompt;
        }

        @Override
        public final Builder prompt(String prompt) {
            this.prompt = prompt;
            return this;
        }

        public final String getPluginType() {
            return pluginType;
        }

        public final void setPluginType(String pluginType) {
            this.pluginType = pluginType;
        }

        @Override
        public final Builder pluginType(String pluginType) {
            this.pluginType = pluginType;
            return this;
        }

        @Override
        public final Builder pluginType(PluginType pluginType) {
            this.pluginType(pluginType == null ? null : pluginType.toString());
            return this;
        }

        public final String getPluginId() {
            return pluginId;
        }

        public final void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        @Override
        public final Builder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        public final String getActionIdentifier() {
            return actionIdentifier;
        }

        public final void setActionIdentifier(String actionIdentifier) {
            this.actionIdentifier = actionIdentifier;
        }

        @Override
        public final Builder actionIdentifier(String actionIdentifier) {
            this.actionIdentifier = actionIdentifier;
            return this;
        }

        @Override
        public QPluginCard build() {
            return new QPluginCard(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
