/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a form input card for an Amazon Q App.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FormInputCardInput implements SdkPojo, Serializable,
        ToCopyableBuilder<FormInputCardInput.Builder, FormInputCardInput> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(FormInputCardInput::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(FormInputCardInput::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(FormInputCardInput::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<FormInputCardMetadata> METADATA_FIELD = SdkField
            .<FormInputCardMetadata> builder(MarshallingType.SDK_POJO).memberName("metadata")
            .getter(getter(FormInputCardInput::metadata)).setter(setter(Builder::metadata))
            .constructor(FormInputCardMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<String> COMPUTE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("computeMode").getter(getter(FormInputCardInput::computeModeAsString))
            .setter(setter(Builder::computeMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, ID_FIELD,
            TYPE_FIELD, METADATA_FIELD, COMPUTE_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String title;

    private final String id;

    private final String type;

    private final FormInputCardMetadata metadata;

    private final String computeMode;

    private FormInputCardInput(BuilderImpl builder) {
        this.title = builder.title;
        this.id = builder.id;
        this.type = builder.type;
        this.metadata = builder.metadata;
        this.computeMode = builder.computeMode;
    }

    /**
     * <p>
     * The title or label of the form input card.
     * </p>
     * 
     * @return The title or label of the form input card.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * The unique identifier of the form input card.
     * </p>
     * 
     * @return The unique identifier of the form input card.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of the card.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CardType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the card.
     * @see CardType
     */
    public final CardType type() {
        return CardType.fromValue(type);
    }

    /**
     * <p>
     * The type of the card.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CardType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the card.
     * @see CardType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The metadata that defines the form input card data.
     * </p>
     * 
     * @return The metadata that defines the form input card data.
     */
    public final FormInputCardMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * The compute mode of the form input card. This property determines whether individual participants of a data
     * collection session can submit multiple response or one response. A compute mode of <code>append</code> shall
     * allow participants to submit the same form multiple times with different values. A compute mode of
     * <code>replace</code>code&gt; shall overwrite the current value for each participant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeMode} will
     * return {@link InputCardComputeMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #computeModeAsString}.
     * </p>
     * 
     * @return The compute mode of the form input card. This property determines whether individual participants of a
     *         data collection session can submit multiple response or one response. A compute mode of
     *         <code>append</code> shall allow participants to submit the same form multiple times with different
     *         values. A compute mode of <code>replace</code>code&gt; shall overwrite the current value for each
     *         participant.
     * @see InputCardComputeMode
     */
    public final InputCardComputeMode computeMode() {
        return InputCardComputeMode.fromValue(computeMode);
    }

    /**
     * <p>
     * The compute mode of the form input card. This property determines whether individual participants of a data
     * collection session can submit multiple response or one response. A compute mode of <code>append</code> shall
     * allow participants to submit the same form multiple times with different values. A compute mode of
     * <code>replace</code>code&gt; shall overwrite the current value for each participant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #computeMode} will
     * return {@link InputCardComputeMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #computeModeAsString}.
     * </p>
     * 
     * @return The compute mode of the form input card. This property determines whether individual participants of a
     *         data collection session can submit multiple response or one response. A compute mode of
     *         <code>append</code> shall allow participants to submit the same form multiple times with different
     *         values. A compute mode of <code>replace</code>code&gt; shall overwrite the current value for each
     *         participant.
     * @see InputCardComputeMode
     */
    public final String computeModeAsString() {
        return computeMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(computeModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormInputCardInput)) {
            return false;
        }
        FormInputCardInput other = (FormInputCardInput) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(id(), other.id())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(metadata(), other.metadata())
                && Objects.equals(computeModeAsString(), other.computeModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FormInputCardInput").add("Title", title()).add("Id", id()).add("Type", typeAsString())
                .add("Metadata", metadata()).add("ComputeMode", computeModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "computeMode":
            return Optional.ofNullable(clazz.cast(computeModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("title", TITLE_FIELD);
        map.put("id", ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("computeMode", COMPUTE_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FormInputCardInput, T> g) {
        return obj -> g.apply((FormInputCardInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FormInputCardInput> {
        /**
         * <p>
         * The title or label of the form input card.
         * </p>
         * 
         * @param title
         *        The title or label of the form input card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * The unique identifier of the form input card.
         * </p>
         * 
         * @param id
         *        The unique identifier of the form input card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of the card.
         * </p>
         * 
         * @param type
         *        The type of the card.
         * @see CardType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CardType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the card.
         * </p>
         * 
         * @param type
         *        The type of the card.
         * @see CardType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CardType
         */
        Builder type(CardType type);

        /**
         * <p>
         * The metadata that defines the form input card data.
         * </p>
         * 
         * @param metadata
         *        The metadata that defines the form input card data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(FormInputCardMetadata metadata);

        /**
         * <p>
         * The metadata that defines the form input card data.
         * </p>
         * This is a convenience method that creates an instance of the {@link FormInputCardMetadata.Builder} avoiding
         * the need to create one manually via {@link FormInputCardMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FormInputCardMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #metadata(FormInputCardMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link FormInputCardMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(FormInputCardMetadata)
         */
        default Builder metadata(Consumer<FormInputCardMetadata.Builder> metadata) {
            return metadata(FormInputCardMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * The compute mode of the form input card. This property determines whether individual participants of a data
         * collection session can submit multiple response or one response. A compute mode of <code>append</code> shall
         * allow participants to submit the same form multiple times with different values. A compute mode of
         * <code>replace</code>code&gt; shall overwrite the current value for each participant.
         * </p>
         * 
         * @param computeMode
         *        The compute mode of the form input card. This property determines whether individual participants of a
         *        data collection session can submit multiple response or one response. A compute mode of
         *        <code>append</code> shall allow participants to submit the same form multiple times with different
         *        values. A compute mode of <code>replace</code>code&gt; shall overwrite the current value for each
         *        participant.
         * @see InputCardComputeMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputCardComputeMode
         */
        Builder computeMode(String computeMode);

        /**
         * <p>
         * The compute mode of the form input card. This property determines whether individual participants of a data
         * collection session can submit multiple response or one response. A compute mode of <code>append</code> shall
         * allow participants to submit the same form multiple times with different values. A compute mode of
         * <code>replace</code>code&gt; shall overwrite the current value for each participant.
         * </p>
         * 
         * @param computeMode
         *        The compute mode of the form input card. This property determines whether individual participants of a
         *        data collection session can submit multiple response or one response. A compute mode of
         *        <code>append</code> shall allow participants to submit the same form multiple times with different
         *        values. A compute mode of <code>replace</code>code&gt; shall overwrite the current value for each
         *        participant.
         * @see InputCardComputeMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputCardComputeMode
         */
        Builder computeMode(InputCardComputeMode computeMode);
    }

    static final class BuilderImpl implements Builder {
        private String title;

        private String id;

        private String type;

        private FormInputCardMetadata metadata;

        private String computeMode;

        private BuilderImpl() {
        }

        private BuilderImpl(FormInputCardInput model) {
            title(model.title);
            id(model.id);
            type(model.type);
            metadata(model.metadata);
            computeMode(model.computeMode);
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CardType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final FormInputCardMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(FormInputCardMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(FormInputCardMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getComputeMode() {
            return computeMode;
        }

        public final void setComputeMode(String computeMode) {
            this.computeMode = computeMode;
        }

        @Override
        public final Builder computeMode(String computeMode) {
            this.computeMode = computeMode;
            return this;
        }

        @Override
        public final Builder computeMode(InputCardComputeMode computeMode) {
            this.computeMode(computeMode == null ? null : computeMode.toString());
            return this;
        }

        @Override
        public FormInputCardInput build() {
            return new FormInputCardInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
