/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.qapps.model.AccessDeniedException;
import software.amazon.awssdk.services.qapps.model.AssociateLibraryItemReviewRequest;
import software.amazon.awssdk.services.qapps.model.AssociateLibraryItemReviewResponse;
import software.amazon.awssdk.services.qapps.model.AssociateQAppWithUserRequest;
import software.amazon.awssdk.services.qapps.model.AssociateQAppWithUserResponse;
import software.amazon.awssdk.services.qapps.model.BatchCreateCategoryRequest;
import software.amazon.awssdk.services.qapps.model.BatchCreateCategoryResponse;
import software.amazon.awssdk.services.qapps.model.BatchDeleteCategoryRequest;
import software.amazon.awssdk.services.qapps.model.BatchDeleteCategoryResponse;
import software.amazon.awssdk.services.qapps.model.BatchUpdateCategoryRequest;
import software.amazon.awssdk.services.qapps.model.BatchUpdateCategoryResponse;
import software.amazon.awssdk.services.qapps.model.ConflictException;
import software.amazon.awssdk.services.qapps.model.ContentTooLargeException;
import software.amazon.awssdk.services.qapps.model.CreateLibraryItemRequest;
import software.amazon.awssdk.services.qapps.model.CreateLibraryItemResponse;
import software.amazon.awssdk.services.qapps.model.CreatePresignedUrlRequest;
import software.amazon.awssdk.services.qapps.model.CreatePresignedUrlResponse;
import software.amazon.awssdk.services.qapps.model.CreateQAppRequest;
import software.amazon.awssdk.services.qapps.model.CreateQAppResponse;
import software.amazon.awssdk.services.qapps.model.DeleteLibraryItemRequest;
import software.amazon.awssdk.services.qapps.model.DeleteLibraryItemResponse;
import software.amazon.awssdk.services.qapps.model.DeleteQAppRequest;
import software.amazon.awssdk.services.qapps.model.DeleteQAppResponse;
import software.amazon.awssdk.services.qapps.model.DescribeQAppPermissionsRequest;
import software.amazon.awssdk.services.qapps.model.DescribeQAppPermissionsResponse;
import software.amazon.awssdk.services.qapps.model.DisassociateLibraryItemReviewRequest;
import software.amazon.awssdk.services.qapps.model.DisassociateLibraryItemReviewResponse;
import software.amazon.awssdk.services.qapps.model.DisassociateQAppFromUserRequest;
import software.amazon.awssdk.services.qapps.model.DisassociateQAppFromUserResponse;
import software.amazon.awssdk.services.qapps.model.ExportQAppSessionDataRequest;
import software.amazon.awssdk.services.qapps.model.ExportQAppSessionDataResponse;
import software.amazon.awssdk.services.qapps.model.GetLibraryItemRequest;
import software.amazon.awssdk.services.qapps.model.GetLibraryItemResponse;
import software.amazon.awssdk.services.qapps.model.GetQAppRequest;
import software.amazon.awssdk.services.qapps.model.GetQAppResponse;
import software.amazon.awssdk.services.qapps.model.GetQAppSessionMetadataRequest;
import software.amazon.awssdk.services.qapps.model.GetQAppSessionMetadataResponse;
import software.amazon.awssdk.services.qapps.model.GetQAppSessionRequest;
import software.amazon.awssdk.services.qapps.model.GetQAppSessionResponse;
import software.amazon.awssdk.services.qapps.model.ImportDocumentRequest;
import software.amazon.awssdk.services.qapps.model.ImportDocumentResponse;
import software.amazon.awssdk.services.qapps.model.InternalServerException;
import software.amazon.awssdk.services.qapps.model.ListCategoriesRequest;
import software.amazon.awssdk.services.qapps.model.ListCategoriesResponse;
import software.amazon.awssdk.services.qapps.model.ListLibraryItemsRequest;
import software.amazon.awssdk.services.qapps.model.ListLibraryItemsResponse;
import software.amazon.awssdk.services.qapps.model.ListQAppSessionDataRequest;
import software.amazon.awssdk.services.qapps.model.ListQAppSessionDataResponse;
import software.amazon.awssdk.services.qapps.model.ListQAppsRequest;
import software.amazon.awssdk.services.qapps.model.ListQAppsResponse;
import software.amazon.awssdk.services.qapps.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.qapps.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.qapps.model.PredictQAppRequest;
import software.amazon.awssdk.services.qapps.model.PredictQAppResponse;
import software.amazon.awssdk.services.qapps.model.QAppsException;
import software.amazon.awssdk.services.qapps.model.ResourceNotFoundException;
import software.amazon.awssdk.services.qapps.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.qapps.model.StartQAppSessionRequest;
import software.amazon.awssdk.services.qapps.model.StartQAppSessionResponse;
import software.amazon.awssdk.services.qapps.model.StopQAppSessionRequest;
import software.amazon.awssdk.services.qapps.model.StopQAppSessionResponse;
import software.amazon.awssdk.services.qapps.model.TagResourceRequest;
import software.amazon.awssdk.services.qapps.model.TagResourceResponse;
import software.amazon.awssdk.services.qapps.model.ThrottlingException;
import software.amazon.awssdk.services.qapps.model.UnauthorizedException;
import software.amazon.awssdk.services.qapps.model.UntagResourceRequest;
import software.amazon.awssdk.services.qapps.model.UntagResourceResponse;
import software.amazon.awssdk.services.qapps.model.UpdateLibraryItemMetadataRequest;
import software.amazon.awssdk.services.qapps.model.UpdateLibraryItemMetadataResponse;
import software.amazon.awssdk.services.qapps.model.UpdateLibraryItemRequest;
import software.amazon.awssdk.services.qapps.model.UpdateLibraryItemResponse;
import software.amazon.awssdk.services.qapps.model.UpdateQAppPermissionsRequest;
import software.amazon.awssdk.services.qapps.model.UpdateQAppPermissionsResponse;
import software.amazon.awssdk.services.qapps.model.UpdateQAppRequest;
import software.amazon.awssdk.services.qapps.model.UpdateQAppResponse;
import software.amazon.awssdk.services.qapps.model.UpdateQAppSessionMetadataRequest;
import software.amazon.awssdk.services.qapps.model.UpdateQAppSessionMetadataResponse;
import software.amazon.awssdk.services.qapps.model.UpdateQAppSessionRequest;
import software.amazon.awssdk.services.qapps.model.UpdateQAppSessionResponse;
import software.amazon.awssdk.services.qapps.model.ValidationException;
import software.amazon.awssdk.services.qapps.paginators.ListLibraryItemsIterable;
import software.amazon.awssdk.services.qapps.paginators.ListQAppsIterable;

/**
 * Service client for accessing QApps. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * The Amazon Q Apps feature capability within Amazon Q Business allows web experience users to create lightweight,
 * purpose-built AI apps to fulfill specific tasks from within their web experience. For example, users can create a Q
 * App that exclusively generates marketing-related content to improve your marketing team's productivity or a Q App for
 * writing customer emails and creating promotional content using a certain style of voice, tone, and branding. For more
 * information on the capabilities, see <a
 * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/deploy-experience-iam-role.html#q-apps-actions">Amazon
 * Q Apps capabilities</a> in the <i>Amazon Q Business User Guide</i>.
 * </p>
 * <p>
 * For an overview of the Amazon Q App APIs, see <a
 * href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_Operations_QApps.html">Overview of Amazon Q Apps
 * API operations</a>.
 * </p>
 * <p>
 * For information about the IAM access control permissions you need to use the Amazon Q Apps API, see <a
 * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/deploy-experience-iam-role.html"> IAM role for the
 * Amazon Q Business web experience including Amazon Q Apps</a> in the <i>Amazon Q Business User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface QAppsClient extends AwsClient {
    String SERVICE_NAME = "qapps";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "data.qapps";

    /**
     * <p>
     * Associates a rating or review for a library item with the user submitting the request. This increments the rating
     * count for the specified library item.
     * </p>
     *
     * @param associateLibraryItemReviewRequest
     * @return Result of the AssociateLibraryItemReview operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.AssociateLibraryItemReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/AssociateLibraryItemReview"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateLibraryItemReviewResponse associateLibraryItemReview(
            AssociateLibraryItemReviewRequest associateLibraryItemReviewRequest) throws ResourceNotFoundException,
            AccessDeniedException, ConflictException, ValidationException, InternalServerException, UnauthorizedException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a rating or review for a library item with the user submitting the request. This increments the rating
     * count for the specified library item.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateLibraryItemReviewRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateLibraryItemReviewRequest#builder()}
     * </p>
     *
     * @param associateLibraryItemReviewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.AssociateLibraryItemReviewRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateLibraryItemReview operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.AssociateLibraryItemReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/AssociateLibraryItemReview"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateLibraryItemReviewResponse associateLibraryItemReview(
            Consumer<AssociateLibraryItemReviewRequest.Builder> associateLibraryItemReviewRequest)
            throws ResourceNotFoundException, AccessDeniedException, ConflictException, ValidationException,
            InternalServerException, UnauthorizedException, ServiceQuotaExceededException, ThrottlingException,
            AwsServiceException, SdkClientException, QAppsException {
        return associateLibraryItemReview(AssociateLibraryItemReviewRequest.builder()
                .applyMutation(associateLibraryItemReviewRequest).build());
    }

    /**
     * <p>
     * This operation creates a link between the user's identity calling the operation and a specific Q App. This is
     * useful to mark the Q App as a <i>favorite</i> for the user if the user doesn't own the Amazon Q App so they can
     * still run it and see it in their inventory of Q Apps.
     * </p>
     *
     * @param associateQAppWithUserRequest
     * @return Result of the AssociateQAppWithUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.AssociateQAppWithUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/AssociateQAppWithUser" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateQAppWithUserResponse associateQAppWithUser(AssociateQAppWithUserRequest associateQAppWithUserRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation creates a link between the user's identity calling the operation and a specific Q App. This is
     * useful to mark the Q App as a <i>favorite</i> for the user if the user doesn't own the Amazon Q App so they can
     * still run it and see it in their inventory of Q Apps.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateQAppWithUserRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateQAppWithUserRequest#builder()}
     * </p>
     *
     * @param associateQAppWithUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.AssociateQAppWithUserRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateQAppWithUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.AssociateQAppWithUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/AssociateQAppWithUser" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateQAppWithUserResponse associateQAppWithUser(
            Consumer<AssociateQAppWithUserRequest.Builder> associateQAppWithUserRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        return associateQAppWithUser(AssociateQAppWithUserRequest.builder().applyMutation(associateQAppWithUserRequest).build());
    }

    /**
     * <p>
     * Creates Categories for the Amazon Q Business application environment instance. Web experience users use
     * Categories to tag and filter library items. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/qapps-custom-labels.html">Custom labels for Amazon
     * Q Apps</a>.
     * </p>
     *
     * @param batchCreateCategoryRequest
     * @return Result of the BatchCreateCategory operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.BatchCreateCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/BatchCreateCategory" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchCreateCategoryResponse batchCreateCategory(BatchCreateCategoryRequest batchCreateCategoryRequest)
            throws ResourceNotFoundException, AccessDeniedException, ConflictException, ValidationException,
            InternalServerException, UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates Categories for the Amazon Q Business application environment instance. Web experience users use
     * Categories to tag and filter library items. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/qapps-custom-labels.html">Custom labels for Amazon
     * Q Apps</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCreateCategoryRequest.Builder} avoiding the
     * need to create one manually via {@link BatchCreateCategoryRequest#builder()}
     * </p>
     *
     * @param batchCreateCategoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.BatchCreateCategoryRequest.Builder} to create a
     *        request.
     * @return Result of the BatchCreateCategory operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.BatchCreateCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/BatchCreateCategory" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchCreateCategoryResponse batchCreateCategory(
            Consumer<BatchCreateCategoryRequest.Builder> batchCreateCategoryRequest) throws ResourceNotFoundException,
            AccessDeniedException, ConflictException, ValidationException, InternalServerException, UnauthorizedException,
            ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        return batchCreateCategory(BatchCreateCategoryRequest.builder().applyMutation(batchCreateCategoryRequest).build());
    }

    /**
     * <p>
     * Deletes Categories for the Amazon Q Business application environment instance. Web experience users use
     * Categories to tag and filter library items. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/qapps-custom-labels.html">Custom labels for Amazon
     * Q Apps</a>.
     * </p>
     *
     * @param batchDeleteCategoryRequest
     * @return Result of the BatchDeleteCategory operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.BatchDeleteCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/BatchDeleteCategory" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchDeleteCategoryResponse batchDeleteCategory(BatchDeleteCategoryRequest batchDeleteCategoryRequest)
            throws ResourceNotFoundException, AccessDeniedException, ConflictException, ValidationException,
            InternalServerException, UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes Categories for the Amazon Q Business application environment instance. Web experience users use
     * Categories to tag and filter library items. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/qapps-custom-labels.html">Custom labels for Amazon
     * Q Apps</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteCategoryRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDeleteCategoryRequest#builder()}
     * </p>
     *
     * @param batchDeleteCategoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.BatchDeleteCategoryRequest.Builder} to create a
     *        request.
     * @return Result of the BatchDeleteCategory operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.BatchDeleteCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/BatchDeleteCategory" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchDeleteCategoryResponse batchDeleteCategory(
            Consumer<BatchDeleteCategoryRequest.Builder> batchDeleteCategoryRequest) throws ResourceNotFoundException,
            AccessDeniedException, ConflictException, ValidationException, InternalServerException, UnauthorizedException,
            ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        return batchDeleteCategory(BatchDeleteCategoryRequest.builder().applyMutation(batchDeleteCategoryRequest).build());
    }

    /**
     * <p>
     * Updates Categories for the Amazon Q Business application environment instance. Web experience users use
     * Categories to tag and filter library items. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/qapps-custom-labels.html">Custom labels for Amazon
     * Q Apps</a>.
     * </p>
     *
     * @param batchUpdateCategoryRequest
     * @return Result of the BatchUpdateCategory operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.BatchUpdateCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/BatchUpdateCategory" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchUpdateCategoryResponse batchUpdateCategory(BatchUpdateCategoryRequest batchUpdateCategoryRequest)
            throws ResourceNotFoundException, AccessDeniedException, ConflictException, ValidationException,
            InternalServerException, UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates Categories for the Amazon Q Business application environment instance. Web experience users use
     * Categories to tag and filter library items. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/qapps-custom-labels.html">Custom labels for Amazon
     * Q Apps</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateCategoryRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUpdateCategoryRequest#builder()}
     * </p>
     *
     * @param batchUpdateCategoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.BatchUpdateCategoryRequest.Builder} to create a
     *        request.
     * @return Result of the BatchUpdateCategory operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.BatchUpdateCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/BatchUpdateCategory" target="_top">AWS API
     *      Documentation</a>
     */
    default BatchUpdateCategoryResponse batchUpdateCategory(
            Consumer<BatchUpdateCategoryRequest.Builder> batchUpdateCategoryRequest) throws ResourceNotFoundException,
            AccessDeniedException, ConflictException, ValidationException, InternalServerException, UnauthorizedException,
            ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        return batchUpdateCategory(BatchUpdateCategoryRequest.builder().applyMutation(batchUpdateCategoryRequest).build());
    }

    /**
     * <p>
     * Creates a new library item for an Amazon Q App, allowing it to be discovered and used by other allowed users.
     * </p>
     *
     * @param createLibraryItemRequest
     * @return Result of the CreateLibraryItem operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.CreateLibraryItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/CreateLibraryItem" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLibraryItemResponse createLibraryItem(CreateLibraryItemRequest createLibraryItemRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new library item for an Amazon Q App, allowing it to be discovered and used by other allowed users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLibraryItemRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLibraryItemRequest#builder()}
     * </p>
     *
     * @param createLibraryItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.CreateLibraryItemRequest.Builder} to create a request.
     * @return Result of the CreateLibraryItem operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.CreateLibraryItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/CreateLibraryItem" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateLibraryItemResponse createLibraryItem(Consumer<CreateLibraryItemRequest.Builder> createLibraryItemRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        return createLibraryItem(CreateLibraryItemRequest.builder().applyMutation(createLibraryItemRequest).build());
    }

    /**
     * <p>
     * Creates a presigned URL for an S3 POST operation to upload a file. You can use this URL to set a default file for
     * a <code>FileUploadCard</code> in a Q App definition or to provide a file for a single Q App run. The
     * <code>scope</code> parameter determines how the file will be used, either at the app definition level or the app
     * session level.
     * </p>
     * <note>
     * <p>
     * The IAM permissions are derived from the <code>qapps:ImportDocument</code> action. For more information on the
     * IAM policy for Amazon Q Apps, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/deploy-q-apps-iam-permissions.html">IAM permissions
     * for using Amazon Q Apps</a>.
     * </p>
     * </note>
     *
     * @param createPresignedUrlRequest
     * @return Result of the CreatePresignedUrl operation returned by the service.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.CreatePresignedUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/CreatePresignedUrl" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePresignedUrlResponse createPresignedUrl(CreatePresignedUrlRequest createPresignedUrlRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException,
            ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a presigned URL for an S3 POST operation to upload a file. You can use this URL to set a default file for
     * a <code>FileUploadCard</code> in a Q App definition or to provide a file for a single Q App run. The
     * <code>scope</code> parameter determines how the file will be used, either at the app definition level or the app
     * session level.
     * </p>
     * <note>
     * <p>
     * The IAM permissions are derived from the <code>qapps:ImportDocument</code> action. For more information on the
     * IAM policy for Amazon Q Apps, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/deploy-q-apps-iam-permissions.html">IAM permissions
     * for using Amazon Q Apps</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePresignedUrlRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePresignedUrlRequest#builder()}
     * </p>
     *
     * @param createPresignedUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.CreatePresignedUrlRequest.Builder} to create a request.
     * @return Result of the CreatePresignedUrl operation returned by the service.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.CreatePresignedUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/CreatePresignedUrl" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePresignedUrlResponse createPresignedUrl(Consumer<CreatePresignedUrlRequest.Builder> createPresignedUrlRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException,
            ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        return createPresignedUrl(CreatePresignedUrlRequest.builder().applyMutation(createPresignedUrlRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon Q App based on the provided definition. The Q App definition specifies the cards and flow of
     * the Q App. This operation also calculates the dependencies between the cards by inspecting the references in the
     * prompts.
     * </p>
     *
     * @param createQAppRequest
     * @return Result of the CreateQApp operation returned by the service.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ContentTooLargeException
     *         The requested operation could not be completed because the content exceeds the maximum allowed size.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.CreateQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/CreateQApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateQAppResponse createQApp(CreateQAppRequest createQAppRequest) throws AccessDeniedException, ConflictException,
            ValidationException, InternalServerException, UnauthorizedException, ServiceQuotaExceededException,
            ContentTooLargeException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon Q App based on the provided definition. The Q App definition specifies the cards and flow of
     * the Q App. This operation also calculates the dependencies between the cards by inspecting the references in the
     * prompts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateQAppRequest.Builder} avoiding the need to
     * create one manually via {@link CreateQAppRequest#builder()}
     * </p>
     *
     * @param createQAppRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.CreateQAppRequest.Builder} to create a request.
     * @return Result of the CreateQApp operation returned by the service.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ContentTooLargeException
     *         The requested operation could not be completed because the content exceeds the maximum allowed size.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.CreateQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/CreateQApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateQAppResponse createQApp(Consumer<CreateQAppRequest.Builder> createQAppRequest) throws AccessDeniedException,
            ConflictException, ValidationException, InternalServerException, UnauthorizedException,
            ServiceQuotaExceededException, ContentTooLargeException, ThrottlingException, AwsServiceException,
            SdkClientException, QAppsException {
        return createQApp(CreateQAppRequest.builder().applyMutation(createQAppRequest).build());
    }

    /**
     * <p>
     * Deletes a library item for an Amazon Q App, removing it from the library so it can no longer be discovered or
     * used by other users.
     * </p>
     *
     * @param deleteLibraryItemRequest
     * @return Result of the DeleteLibraryItem operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.DeleteLibraryItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DeleteLibraryItem" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLibraryItemResponse deleteLibraryItem(DeleteLibraryItemRequest deleteLibraryItemRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a library item for an Amazon Q App, removing it from the library so it can no longer be discovered or
     * used by other users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLibraryItemRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteLibraryItemRequest#builder()}
     * </p>
     *
     * @param deleteLibraryItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.DeleteLibraryItemRequest.Builder} to create a request.
     * @return Result of the DeleteLibraryItem operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.DeleteLibraryItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DeleteLibraryItem" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteLibraryItemResponse deleteLibraryItem(Consumer<DeleteLibraryItemRequest.Builder> deleteLibraryItemRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        return deleteLibraryItem(DeleteLibraryItemRequest.builder().applyMutation(deleteLibraryItemRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Q App owned by the user. If the Q App was previously published to the library, it is also
     * removed from the library.
     * </p>
     *
     * @param deleteQAppRequest
     * @return Result of the DeleteQApp operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.DeleteQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DeleteQApp" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteQAppResponse deleteQApp(DeleteQAppRequest deleteQAppRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException, ThrottlingException,
            AwsServiceException, SdkClientException, QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Q App owned by the user. If the Q App was previously published to the library, it is also
     * removed from the library.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQAppRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteQAppRequest#builder()}
     * </p>
     *
     * @param deleteQAppRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.DeleteQAppRequest.Builder} to create a request.
     * @return Result of the DeleteQApp operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.DeleteQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DeleteQApp" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteQAppResponse deleteQApp(Consumer<DeleteQAppRequest.Builder> deleteQAppRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        return deleteQApp(DeleteQAppRequest.builder().applyMutation(deleteQAppRequest).build());
    }

    /**
     * <p>
     * Describes read permissions for a Amazon Q App in Amazon Q Business application environment instance.
     * </p>
     *
     * @param describeQAppPermissionsRequest
     * @return Result of the DescribeQAppPermissions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.DescribeQAppPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DescribeQAppPermissions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeQAppPermissionsResponse describeQAppPermissions(DescribeQAppPermissionsRequest describeQAppPermissionsRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes read permissions for a Amazon Q App in Amazon Q Business application environment instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeQAppPermissionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeQAppPermissionsRequest#builder()}
     * </p>
     *
     * @param describeQAppPermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.DescribeQAppPermissionsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeQAppPermissions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.DescribeQAppPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DescribeQAppPermissions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeQAppPermissionsResponse describeQAppPermissions(
            Consumer<DescribeQAppPermissionsRequest.Builder> describeQAppPermissionsRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException, ThrottlingException,
            AwsServiceException, SdkClientException, QAppsException {
        return describeQAppPermissions(DescribeQAppPermissionsRequest.builder().applyMutation(describeQAppPermissionsRequest)
                .build());
    }

    /**
     * <p>
     * Removes a rating or review previously submitted by the user for a library item.
     * </p>
     *
     * @param disassociateLibraryItemReviewRequest
     * @return Result of the DisassociateLibraryItemReview operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.DisassociateLibraryItemReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DisassociateLibraryItemReview"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateLibraryItemReviewResponse disassociateLibraryItemReview(
            DisassociateLibraryItemReviewRequest disassociateLibraryItemReviewRequest) throws ResourceNotFoundException,
            AccessDeniedException, ConflictException, ValidationException, InternalServerException, UnauthorizedException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a rating or review previously submitted by the user for a library item.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateLibraryItemReviewRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateLibraryItemReviewRequest#builder()}
     * </p>
     *
     * @param disassociateLibraryItemReviewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.DisassociateLibraryItemReviewRequest.Builder} to create
     *        a request.
     * @return Result of the DisassociateLibraryItemReview operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.DisassociateLibraryItemReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DisassociateLibraryItemReview"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateLibraryItemReviewResponse disassociateLibraryItemReview(
            Consumer<DisassociateLibraryItemReviewRequest.Builder> disassociateLibraryItemReviewRequest)
            throws ResourceNotFoundException, AccessDeniedException, ConflictException, ValidationException,
            InternalServerException, UnauthorizedException, ServiceQuotaExceededException, ThrottlingException,
            AwsServiceException, SdkClientException, QAppsException {
        return disassociateLibraryItemReview(DisassociateLibraryItemReviewRequest.builder()
                .applyMutation(disassociateLibraryItemReviewRequest).build());
    }

    /**
     * <p>
     * Disassociates a Q App from a user removing the user's access to run the Q App.
     * </p>
     *
     * @param disassociateQAppFromUserRequest
     * @return Result of the DisassociateQAppFromUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.DisassociateQAppFromUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DisassociateQAppFromUser"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateQAppFromUserResponse disassociateQAppFromUser(
            DisassociateQAppFromUserRequest disassociateQAppFromUserRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException, ThrottlingException,
            AwsServiceException, SdkClientException, QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a Q App from a user removing the user's access to run the Q App.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateQAppFromUserRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateQAppFromUserRequest#builder()}
     * </p>
     *
     * @param disassociateQAppFromUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.DisassociateQAppFromUserRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateQAppFromUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.DisassociateQAppFromUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DisassociateQAppFromUser"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateQAppFromUserResponse disassociateQAppFromUser(
            Consumer<DisassociateQAppFromUserRequest.Builder> disassociateQAppFromUserRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException, ThrottlingException,
            AwsServiceException, SdkClientException, QAppsException {
        return disassociateQAppFromUser(DisassociateQAppFromUserRequest.builder().applyMutation(disassociateQAppFromUserRequest)
                .build());
    }

    /**
     * <p>
     * Exports the collected data of a Q App data collection session.
     * </p>
     *
     * @param exportQAppSessionDataRequest
     * @return Result of the ExportQAppSessionData operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ExportQAppSessionData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ExportQAppSessionData" target="_top">AWS
     *      API Documentation</a>
     */
    default ExportQAppSessionDataResponse exportQAppSessionData(ExportQAppSessionDataRequest exportQAppSessionDataRequest)
            throws ResourceNotFoundException, AccessDeniedException, ConflictException, ValidationException,
            InternalServerException, UnauthorizedException, ServiceQuotaExceededException, ThrottlingException,
            AwsServiceException, SdkClientException, QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports the collected data of a Q App data collection session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportQAppSessionDataRequest.Builder} avoiding the
     * need to create one manually via {@link ExportQAppSessionDataRequest#builder()}
     * </p>
     *
     * @param exportQAppSessionDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.ExportQAppSessionDataRequest.Builder} to create a
     *        request.
     * @return Result of the ExportQAppSessionData operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ExportQAppSessionData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ExportQAppSessionData" target="_top">AWS
     *      API Documentation</a>
     */
    default ExportQAppSessionDataResponse exportQAppSessionData(
            Consumer<ExportQAppSessionDataRequest.Builder> exportQAppSessionDataRequest) throws ResourceNotFoundException,
            AccessDeniedException, ConflictException, ValidationException, InternalServerException, UnauthorizedException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        return exportQAppSessionData(ExportQAppSessionDataRequest.builder().applyMutation(exportQAppSessionDataRequest).build());
    }

    /**
     * <p>
     * Retrieves details about a library item for an Amazon Q App, including its metadata, categories, ratings, and
     * usage statistics.
     * </p>
     *
     * @param getLibraryItemRequest
     * @return Result of the GetLibraryItem operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.GetLibraryItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetLibraryItem" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLibraryItemResponse getLibraryItem(GetLibraryItemRequest getLibraryItemRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException, ThrottlingException,
            AwsServiceException, SdkClientException, QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about a library item for an Amazon Q App, including its metadata, categories, ratings, and
     * usage statistics.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLibraryItemRequest.Builder} avoiding the need to
     * create one manually via {@link GetLibraryItemRequest#builder()}
     * </p>
     *
     * @param getLibraryItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.GetLibraryItemRequest.Builder} to create a request.
     * @return Result of the GetLibraryItem operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.GetLibraryItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetLibraryItem" target="_top">AWS API
     *      Documentation</a>
     */
    default GetLibraryItemResponse getLibraryItem(Consumer<GetLibraryItemRequest.Builder> getLibraryItemRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        return getLibraryItem(GetLibraryItemRequest.builder().applyMutation(getLibraryItemRequest).build());
    }

    /**
     * <p>
     * Retrieves the full details of an Q App, including its definition specifying the cards and flow.
     * </p>
     *
     * @param getQAppRequest
     * @return Result of the GetQApp operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.GetQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetQApp" target="_top">AWS API
     *      Documentation</a>
     */
    default GetQAppResponse getQApp(GetQAppRequest getQAppRequest) throws ResourceNotFoundException, AccessDeniedException,
            ValidationException, InternalServerException, UnauthorizedException, ThrottlingException, AwsServiceException,
            SdkClientException, QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the full details of an Q App, including its definition specifying the cards and flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQAppRequest.Builder} avoiding the need to create
     * one manually via {@link GetQAppRequest#builder()}
     * </p>
     *
     * @param getQAppRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.GetQAppRequest.Builder} to create a request.
     * @return Result of the GetQApp operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.GetQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetQApp" target="_top">AWS API
     *      Documentation</a>
     */
    default GetQAppResponse getQApp(Consumer<GetQAppRequest.Builder> getQAppRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException, ThrottlingException,
            AwsServiceException, SdkClientException, QAppsException {
        return getQApp(GetQAppRequest.builder().applyMutation(getQAppRequest).build());
    }

    /**
     * <p>
     * Retrieves the current state and results for an active session of an Amazon Q App.
     * </p>
     *
     * @param getQAppSessionRequest
     * @return Result of the GetQAppSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.GetQAppSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetQAppSession" target="_top">AWS API
     *      Documentation</a>
     */
    default GetQAppSessionResponse getQAppSession(GetQAppSessionRequest getQAppSessionRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current state and results for an active session of an Amazon Q App.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQAppSessionRequest.Builder} avoiding the need to
     * create one manually via {@link GetQAppSessionRequest#builder()}
     * </p>
     *
     * @param getQAppSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.GetQAppSessionRequest.Builder} to create a request.
     * @return Result of the GetQAppSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.GetQAppSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetQAppSession" target="_top">AWS API
     *      Documentation</a>
     */
    default GetQAppSessionResponse getQAppSession(Consumer<GetQAppSessionRequest.Builder> getQAppSessionRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        return getQAppSession(GetQAppSessionRequest.builder().applyMutation(getQAppSessionRequest).build());
    }

    /**
     * <p>
     * Retrieves the current configuration of a Q App session.
     * </p>
     *
     * @param getQAppSessionMetadataRequest
     * @return Result of the GetQAppSessionMetadata operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.GetQAppSessionMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetQAppSessionMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default GetQAppSessionMetadataResponse getQAppSessionMetadata(GetQAppSessionMetadataRequest getQAppSessionMetadataRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current configuration of a Q App session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQAppSessionMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link GetQAppSessionMetadataRequest#builder()}
     * </p>
     *
     * @param getQAppSessionMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.GetQAppSessionMetadataRequest.Builder} to create a
     *        request.
     * @return Result of the GetQAppSessionMetadata operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.GetQAppSessionMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetQAppSessionMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default GetQAppSessionMetadataResponse getQAppSessionMetadata(
            Consumer<GetQAppSessionMetadataRequest.Builder> getQAppSessionMetadataRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        return getQAppSessionMetadata(GetQAppSessionMetadataRequest.builder().applyMutation(getQAppSessionMetadataRequest)
                .build());
    }

    /**
     * <p>
     * Uploads a file that can then be used either as a default in a <code>FileUploadCard</code> from Q App definition
     * or as a file that is used inside a single Q App run. The purpose of the document is determined by a scope
     * parameter that indicates whether it is at the app definition level or at the app session level.
     * </p>
     *
     * @param importDocumentRequest
     * @return Result of the ImportDocument operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ContentTooLargeException
     *         The requested operation could not be completed because the content exceeds the maximum allowed size.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ImportDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ImportDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default ImportDocumentResponse importDocument(ImportDocumentRequest importDocumentRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException,
            ServiceQuotaExceededException, ContentTooLargeException, ThrottlingException, AwsServiceException,
            SdkClientException, QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads a file that can then be used either as a default in a <code>FileUploadCard</code> from Q App definition
     * or as a file that is used inside a single Q App run. The purpose of the document is determined by a scope
     * parameter that indicates whether it is at the app definition level or at the app session level.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportDocumentRequest.Builder} avoiding the need to
     * create one manually via {@link ImportDocumentRequest#builder()}
     * </p>
     *
     * @param importDocumentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.ImportDocumentRequest.Builder} to create a request.
     * @return Result of the ImportDocument operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ContentTooLargeException
     *         The requested operation could not be completed because the content exceeds the maximum allowed size.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ImportDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ImportDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default ImportDocumentResponse importDocument(Consumer<ImportDocumentRequest.Builder> importDocumentRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ServiceQuotaExceededException, ContentTooLargeException, ThrottlingException,
            AwsServiceException, SdkClientException, QAppsException {
        return importDocument(ImportDocumentRequest.builder().applyMutation(importDocumentRequest).build());
    }

    /**
     * <p>
     * Lists the categories of a Amazon Q Business application environment instance. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/qapps-custom-labels.html">Custom labels for Amazon
     * Q Apps</a>.
     * </p>
     *
     * @param listCategoriesRequest
     * @return Result of the ListCategories operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ListCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListCategories" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCategoriesResponse listCategories(ListCategoriesRequest listCategoriesRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException, ThrottlingException,
            AwsServiceException, SdkClientException, QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the categories of a Amazon Q Business application environment instance. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/qapps-custom-labels.html">Custom labels for Amazon
     * Q Apps</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCategoriesRequest.Builder} avoiding the need to
     * create one manually via {@link ListCategoriesRequest#builder()}
     * </p>
     *
     * @param listCategoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.ListCategoriesRequest.Builder} to create a request.
     * @return Result of the ListCategories operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ListCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListCategories" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCategoriesResponse listCategories(Consumer<ListCategoriesRequest.Builder> listCategoriesRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        return listCategories(ListCategoriesRequest.builder().applyMutation(listCategoriesRequest).build());
    }

    /**
     * <p>
     * Lists the library items for Amazon Q Apps that are published and available for users in your Amazon Web Services
     * account.
     * </p>
     *
     * @param listLibraryItemsRequest
     * @return Result of the ListLibraryItems operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ListLibraryItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListLibraryItems" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLibraryItemsResponse listLibraryItems(ListLibraryItemsRequest listLibraryItemsRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the library items for Amazon Q Apps that are published and available for users in your Amazon Web Services
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLibraryItemsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLibraryItemsRequest#builder()}
     * </p>
     *
     * @param listLibraryItemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.ListLibraryItemsRequest.Builder} to create a request.
     * @return Result of the ListLibraryItems operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ListLibraryItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListLibraryItems" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLibraryItemsResponse listLibraryItems(Consumer<ListLibraryItemsRequest.Builder> listLibraryItemsRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        return listLibraryItems(ListLibraryItemsRequest.builder().applyMutation(listLibraryItemsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLibraryItems(software.amazon.awssdk.services.qapps.model.ListLibraryItemsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qapps.paginators.ListLibraryItemsIterable responses = client.listLibraryItemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qapps.paginators.ListLibraryItemsIterable responses = client
     *             .listLibraryItemsPaginator(request);
     *     for (software.amazon.awssdk.services.qapps.model.ListLibraryItemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qapps.paginators.ListLibraryItemsIterable responses = client.listLibraryItemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLibraryItems(software.amazon.awssdk.services.qapps.model.ListLibraryItemsRequest)} operation.</b>
     * </p>
     *
     * @param listLibraryItemsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ListLibraryItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListLibraryItems" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLibraryItemsIterable listLibraryItemsPaginator(ListLibraryItemsRequest listLibraryItemsRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        return new ListLibraryItemsIterable(this, listLibraryItemsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLibraryItems(software.amazon.awssdk.services.qapps.model.ListLibraryItemsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qapps.paginators.ListLibraryItemsIterable responses = client.listLibraryItemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qapps.paginators.ListLibraryItemsIterable responses = client
     *             .listLibraryItemsPaginator(request);
     *     for (software.amazon.awssdk.services.qapps.model.ListLibraryItemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qapps.paginators.ListLibraryItemsIterable responses = client.listLibraryItemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLibraryItems(software.amazon.awssdk.services.qapps.model.ListLibraryItemsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLibraryItemsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLibraryItemsRequest#builder()}
     * </p>
     *
     * @param listLibraryItemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.ListLibraryItemsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ListLibraryItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListLibraryItems" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLibraryItemsIterable listLibraryItemsPaginator(Consumer<ListLibraryItemsRequest.Builder> listLibraryItemsRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        return listLibraryItemsPaginator(ListLibraryItemsRequest.builder().applyMutation(listLibraryItemsRequest).build());
    }

    /**
     * <p>
     * Lists the collected data of a Q App data collection session.
     * </p>
     *
     * @param listQAppSessionDataRequest
     * @return Result of the ListQAppSessionData operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ListQAppSessionData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListQAppSessionData" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQAppSessionDataResponse listQAppSessionData(ListQAppSessionDataRequest listQAppSessionDataRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the collected data of a Q App data collection session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQAppSessionDataRequest.Builder} avoiding the
     * need to create one manually via {@link ListQAppSessionDataRequest#builder()}
     * </p>
     *
     * @param listQAppSessionDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.ListQAppSessionDataRequest.Builder} to create a
     *        request.
     * @return Result of the ListQAppSessionData operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ListQAppSessionData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListQAppSessionData" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQAppSessionDataResponse listQAppSessionData(
            Consumer<ListQAppSessionDataRequest.Builder> listQAppSessionDataRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        return listQAppSessionData(ListQAppSessionDataRequest.builder().applyMutation(listQAppSessionDataRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Q Apps owned by or associated with the user either because they created it or because they used
     * it from the library in the past. The user identity is extracted from the credentials used to invoke this
     * operation..
     * </p>
     *
     * @param listQAppsRequest
     * @return Result of the ListQApps operation returned by the service.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ListQApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListQApps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQAppsResponse listQApps(ListQAppsRequest listQAppsRequest) throws AccessDeniedException, ValidationException,
            InternalServerException, UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Q Apps owned by or associated with the user either because they created it or because they used
     * it from the library in the past. The user identity is extracted from the credentials used to invoke this
     * operation..
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQAppsRequest.Builder} avoiding the need to
     * create one manually via {@link ListQAppsRequest#builder()}
     * </p>
     *
     * @param listQAppsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.ListQAppsRequest.Builder} to create a request.
     * @return Result of the ListQApps operation returned by the service.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ListQApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListQApps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQAppsResponse listQApps(Consumer<ListQAppsRequest.Builder> listQAppsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, UnauthorizedException, ThrottlingException, AwsServiceException,
            SdkClientException, QAppsException {
        return listQApps(ListQAppsRequest.builder().applyMutation(listQAppsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listQApps(software.amazon.awssdk.services.qapps.model.ListQAppsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qapps.paginators.ListQAppsIterable responses = client.listQAppsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qapps.paginators.ListQAppsIterable responses = client.listQAppsPaginator(request);
     *     for (software.amazon.awssdk.services.qapps.model.ListQAppsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qapps.paginators.ListQAppsIterable responses = client.listQAppsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQApps(software.amazon.awssdk.services.qapps.model.ListQAppsRequest)} operation.</b>
     * </p>
     *
     * @param listQAppsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ListQApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListQApps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQAppsIterable listQAppsPaginator(ListQAppsRequest listQAppsRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, UnauthorizedException, ThrottlingException, AwsServiceException,
            SdkClientException, QAppsException {
        return new ListQAppsIterable(this, listQAppsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listQApps(software.amazon.awssdk.services.qapps.model.ListQAppsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qapps.paginators.ListQAppsIterable responses = client.listQAppsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.qapps.paginators.ListQAppsIterable responses = client.listQAppsPaginator(request);
     *     for (software.amazon.awssdk.services.qapps.model.ListQAppsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qapps.paginators.ListQAppsIterable responses = client.listQAppsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQApps(software.amazon.awssdk.services.qapps.model.ListQAppsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQAppsRequest.Builder} avoiding the need to
     * create one manually via {@link ListQAppsRequest#builder()}
     * </p>
     *
     * @param listQAppsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.ListQAppsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ListQApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListQApps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQAppsIterable listQAppsPaginator(Consumer<ListQAppsRequest.Builder> listQAppsRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException,
            ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        return listQAppsPaginator(ListQAppsRequest.builder().applyMutation(listQAppsRequest).build());
    }

    /**
     * <p>
     * Lists the tags associated with an Amazon Q Apps resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags associated with an Amazon Q Apps resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, QAppsException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Generates an Amazon Q App definition based on either a conversation or a problem statement provided as input.The
     * resulting app definition can be used to call <code>CreateQApp</code>. This API doesn't create Amazon Q Apps
     * directly.
     * </p>
     *
     * @param predictQAppRequest
     * @return Result of the PredictQApp operation returned by the service.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.PredictQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/PredictQApp" target="_top">AWS API
     *      Documentation</a>
     */
    default PredictQAppResponse predictQApp(PredictQAppRequest predictQAppRequest) throws AccessDeniedException,
            ValidationException, InternalServerException, UnauthorizedException, ThrottlingException, AwsServiceException,
            SdkClientException, QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates an Amazon Q App definition based on either a conversation or a problem statement provided as input.The
     * resulting app definition can be used to call <code>CreateQApp</code>. This API doesn't create Amazon Q Apps
     * directly.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PredictQAppRequest.Builder} avoiding the need to
     * create one manually via {@link PredictQAppRequest#builder()}
     * </p>
     *
     * @param predictQAppRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.PredictQAppRequest.Builder} to create a request.
     * @return Result of the PredictQApp operation returned by the service.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.PredictQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/PredictQApp" target="_top">AWS API
     *      Documentation</a>
     */
    default PredictQAppResponse predictQApp(Consumer<PredictQAppRequest.Builder> predictQAppRequest)
            throws AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException,
            ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        return predictQApp(PredictQAppRequest.builder().applyMutation(predictQAppRequest).build());
    }

    /**
     * <p>
     * Starts a new session for an Amazon Q App, allowing inputs to be provided and the app to be run.
     * </p>
     * <note>
     * <p>
     * Each Q App session will be condensed into a single conversation in the web experience.
     * </p>
     * </note>
     *
     * @param startQAppSessionRequest
     * @return Result of the StartQAppSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.StartQAppSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/StartQAppSession" target="_top">AWS API
     *      Documentation</a>
     */
    default StartQAppSessionResponse startQAppSession(StartQAppSessionRequest startQAppSessionRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a new session for an Amazon Q App, allowing inputs to be provided and the app to be run.
     * </p>
     * <note>
     * <p>
     * Each Q App session will be condensed into a single conversation in the web experience.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartQAppSessionRequest.Builder} avoiding the need
     * to create one manually via {@link StartQAppSessionRequest#builder()}
     * </p>
     *
     * @param startQAppSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.StartQAppSessionRequest.Builder} to create a request.
     * @return Result of the StartQAppSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.StartQAppSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/StartQAppSession" target="_top">AWS API
     *      Documentation</a>
     */
    default StartQAppSessionResponse startQAppSession(Consumer<StartQAppSessionRequest.Builder> startQAppSessionRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        return startQAppSession(StartQAppSessionRequest.builder().applyMutation(startQAppSessionRequest).build());
    }

    /**
     * <p>
     * Stops an active session for an Amazon Q App.This deletes all data related to the session and makes it invalid for
     * future uses. The results of the session will be persisted as part of the conversation.
     * </p>
     *
     * @param stopQAppSessionRequest
     * @return Result of the StopQAppSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.StopQAppSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/StopQAppSession" target="_top">AWS API
     *      Documentation</a>
     */
    default StopQAppSessionResponse stopQAppSession(StopQAppSessionRequest stopQAppSessionRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an active session for an Amazon Q App.This deletes all data related to the session and makes it invalid for
     * future uses. The results of the session will be persisted as part of the conversation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopQAppSessionRequest.Builder} avoiding the need
     * to create one manually via {@link StopQAppSessionRequest#builder()}
     * </p>
     *
     * @param stopQAppSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.StopQAppSessionRequest.Builder} to create a request.
     * @return Result of the StopQAppSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.StopQAppSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/StopQAppSession" target="_top">AWS API
     *      Documentation</a>
     */
    default StopQAppSessionResponse stopQAppSession(Consumer<StopQAppSessionRequest.Builder> stopQAppSessionRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        return stopQAppSession(StopQAppSessionRequest.builder().applyMutation(stopQAppSessionRequest).build());
    }

    /**
     * <p>
     * Associates tags with an Amazon Q Apps resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            AccessDeniedException, ConflictException, ValidationException, InternalServerException, ThrottlingException,
            AwsServiceException, SdkClientException, QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates tags with an Amazon Q Apps resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, AccessDeniedException, ConflictException, ValidationException,
            InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Disassociates tags from an Amazon Q Apps resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, ThrottlingException, AwsServiceException,
            SdkClientException, QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates tags from an Amazon Q Apps resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the library item for an Amazon Q App.
     * </p>
     *
     * @param updateLibraryItemRequest
     * @return Result of the UpdateLibraryItem operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.UpdateLibraryItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateLibraryItem" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateLibraryItemResponse updateLibraryItem(UpdateLibraryItemRequest updateLibraryItemRequest)
            throws ResourceNotFoundException, AccessDeniedException, ConflictException, ValidationException,
            InternalServerException, UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the library item for an Amazon Q App.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLibraryItemRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateLibraryItemRequest#builder()}
     * </p>
     *
     * @param updateLibraryItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.UpdateLibraryItemRequest.Builder} to create a request.
     * @return Result of the UpdateLibraryItem operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.UpdateLibraryItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateLibraryItem" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateLibraryItemResponse updateLibraryItem(Consumer<UpdateLibraryItemRequest.Builder> updateLibraryItemRequest)
            throws ResourceNotFoundException, AccessDeniedException, ConflictException, ValidationException,
            InternalServerException, UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        return updateLibraryItem(UpdateLibraryItemRequest.builder().applyMutation(updateLibraryItemRequest).build());
    }

    /**
     * <p>
     * Updates the verification status of a library item for an Amazon Q App.
     * </p>
     *
     * @param updateLibraryItemMetadataRequest
     * @return Result of the UpdateLibraryItemMetadata operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.UpdateLibraryItemMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateLibraryItemMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLibraryItemMetadataResponse updateLibraryItemMetadata(
            UpdateLibraryItemMetadataRequest updateLibraryItemMetadataRequest) throws ResourceNotFoundException,
            AccessDeniedException, ConflictException, ValidationException, InternalServerException, UnauthorizedException,
            ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the verification status of a library item for an Amazon Q App.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLibraryItemMetadataRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateLibraryItemMetadataRequest#builder()}
     * </p>
     *
     * @param updateLibraryItemMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.UpdateLibraryItemMetadataRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateLibraryItemMetadata operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ConflictException
     *         The requested operation could not be completed due to a conflict with the current state of the resource.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.UpdateLibraryItemMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateLibraryItemMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLibraryItemMetadataResponse updateLibraryItemMetadata(
            Consumer<UpdateLibraryItemMetadataRequest.Builder> updateLibraryItemMetadataRequest)
            throws ResourceNotFoundException, AccessDeniedException, ConflictException, ValidationException,
            InternalServerException, UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        return updateLibraryItemMetadata(UpdateLibraryItemMetadataRequest.builder()
                .applyMutation(updateLibraryItemMetadataRequest).build());
    }

    /**
     * <p>
     * Updates an existing Amazon Q App, allowing modifications to its title, description, and definition.
     * </p>
     *
     * @param updateQAppRequest
     * @return Result of the UpdateQApp operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ContentTooLargeException
     *         The requested operation could not be completed because the content exceeds the maximum allowed size.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.UpdateQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateQApp" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateQAppResponse updateQApp(UpdateQAppRequest updateQAppRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException, ContentTooLargeException,
            ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Amazon Q App, allowing modifications to its title, description, and definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQAppRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateQAppRequest#builder()}
     * </p>
     *
     * @param updateQAppRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.UpdateQAppRequest.Builder} to create a request.
     * @return Result of the UpdateQApp operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ContentTooLargeException
     *         The requested operation could not be completed because the content exceeds the maximum allowed size.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.UpdateQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateQApp" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateQAppResponse updateQApp(Consumer<UpdateQAppRequest.Builder> updateQAppRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ContentTooLargeException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        return updateQApp(UpdateQAppRequest.builder().applyMutation(updateQAppRequest).build());
    }

    /**
     * <p>
     * Updates read permissions for a Amazon Q App in Amazon Q Business application environment instance.
     * </p>
     *
     * @param updateQAppPermissionsRequest
     * @return Result of the UpdateQAppPermissions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.UpdateQAppPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateQAppPermissions" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateQAppPermissionsResponse updateQAppPermissions(UpdateQAppPermissionsRequest updateQAppPermissionsRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates read permissions for a Amazon Q App in Amazon Q Business application environment instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQAppPermissionsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateQAppPermissionsRequest#builder()}
     * </p>
     *
     * @param updateQAppPermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.UpdateQAppPermissionsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateQAppPermissions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.UpdateQAppPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateQAppPermissions" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateQAppPermissionsResponse updateQAppPermissions(
            Consumer<UpdateQAppPermissionsRequest.Builder> updateQAppPermissionsRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException, ThrottlingException,
            AwsServiceException, SdkClientException, QAppsException {
        return updateQAppPermissions(UpdateQAppPermissionsRequest.builder().applyMutation(updateQAppPermissionsRequest).build());
    }

    /**
     * <p>
     * Updates the session for a given Q App <code>sessionId</code>. This is only valid when at least one card of the
     * session is in the <code>WAITING</code> state. Data for each <code>WAITING</code> card can be provided as input.
     * If inputs are not provided, the call will be accepted but session will not move forward. Inputs for cards that
     * are not in the <code>WAITING</code> status will be ignored.
     * </p>
     *
     * @param updateQAppSessionRequest
     * @return Result of the UpdateQAppSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.UpdateQAppSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateQAppSession" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateQAppSessionResponse updateQAppSession(UpdateQAppSessionRequest updateQAppSessionRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the session for a given Q App <code>sessionId</code>. This is only valid when at least one card of the
     * session is in the <code>WAITING</code> state. Data for each <code>WAITING</code> card can be provided as input.
     * If inputs are not provided, the call will be accepted but session will not move forward. Inputs for cards that
     * are not in the <code>WAITING</code> status will be ignored.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQAppSessionRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateQAppSessionRequest#builder()}
     * </p>
     *
     * @param updateQAppSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.UpdateQAppSessionRequest.Builder} to create a request.
     * @return Result of the UpdateQAppSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.UpdateQAppSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateQAppSession" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateQAppSessionResponse updateQAppSession(Consumer<UpdateQAppSessionRequest.Builder> updateQAppSessionRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        return updateQAppSession(UpdateQAppSessionRequest.builder().applyMutation(updateQAppSessionRequest).build());
    }

    /**
     * <p>
     * Updates the configuration metadata of a session for a given Q App <code>sessionId</code>.
     * </p>
     *
     * @param updateQAppSessionMetadataRequest
     * @return Result of the UpdateQAppSessionMetadata operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.UpdateQAppSessionMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateQAppSessionMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateQAppSessionMetadataResponse updateQAppSessionMetadata(
            UpdateQAppSessionMetadataRequest updateQAppSessionMetadataRequest) throws ResourceNotFoundException,
            AccessDeniedException, ValidationException, InternalServerException, UnauthorizedException,
            ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException, QAppsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration metadata of a session for a given Q App <code>sessionId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQAppSessionMetadataRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateQAppSessionMetadataRequest#builder()}
     * </p>
     *
     * @param updateQAppSessionMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.UpdateQAppSessionMetadataRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateQAppSessionMetadata operation returned by the service.
     * @throws ResourceNotFoundException
     *         The requested resource could not be found.
     * @throws AccessDeniedException
     *         The client is not authorized to perform the requested operation.
     * @throws ValidationException
     *         The input failed to satisfy the constraints specified by the service.
     * @throws InternalServerException
     *         An internal service error occurred while processing the request.
     * @throws UnauthorizedException
     *         The client is not authenticated or authorized to perform the requested operation.
     * @throws ServiceQuotaExceededException
     *         The requested operation could not be completed because it would exceed the service's quota or limit.
     * @throws ThrottlingException
     *         The requested operation could not be completed because too many requests were sent at once. Wait a bit
     *         and try again later.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QAppsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QAppsClient.UpdateQAppSessionMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateQAppSessionMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateQAppSessionMetadataResponse updateQAppSessionMetadata(
            Consumer<UpdateQAppSessionMetadataRequest.Builder> updateQAppSessionMetadataRequest)
            throws ResourceNotFoundException, AccessDeniedException, ValidationException, InternalServerException,
            UnauthorizedException, ServiceQuotaExceededException, ThrottlingException, AwsServiceException, SdkClientException,
            QAppsException {
        return updateQAppSessionMetadata(UpdateQAppSessionMetadataRequest.builder()
                .applyMutation(updateQAppSessionMetadataRequest).build());
    }

    /**
     * Create a {@link QAppsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static QAppsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link QAppsClient}.
     */
    static QAppsClientBuilder builder() {
        return new DefaultQAppsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default QAppsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
