/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.qapps;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.qapps.model.AssociateLibraryItemReviewRequest;
import software.amazon.awssdk.services.qapps.model.AssociateLibraryItemReviewResponse;
import software.amazon.awssdk.services.qapps.model.AssociateQAppWithUserRequest;
import software.amazon.awssdk.services.qapps.model.AssociateQAppWithUserResponse;
import software.amazon.awssdk.services.qapps.model.BatchCreateCategoryRequest;
import software.amazon.awssdk.services.qapps.model.BatchCreateCategoryResponse;
import software.amazon.awssdk.services.qapps.model.BatchDeleteCategoryRequest;
import software.amazon.awssdk.services.qapps.model.BatchDeleteCategoryResponse;
import software.amazon.awssdk.services.qapps.model.BatchUpdateCategoryRequest;
import software.amazon.awssdk.services.qapps.model.BatchUpdateCategoryResponse;
import software.amazon.awssdk.services.qapps.model.CreateLibraryItemRequest;
import software.amazon.awssdk.services.qapps.model.CreateLibraryItemResponse;
import software.amazon.awssdk.services.qapps.model.CreatePresignedUrlRequest;
import software.amazon.awssdk.services.qapps.model.CreatePresignedUrlResponse;
import software.amazon.awssdk.services.qapps.model.CreateQAppRequest;
import software.amazon.awssdk.services.qapps.model.CreateQAppResponse;
import software.amazon.awssdk.services.qapps.model.DeleteLibraryItemRequest;
import software.amazon.awssdk.services.qapps.model.DeleteLibraryItemResponse;
import software.amazon.awssdk.services.qapps.model.DeleteQAppRequest;
import software.amazon.awssdk.services.qapps.model.DeleteQAppResponse;
import software.amazon.awssdk.services.qapps.model.DescribeQAppPermissionsRequest;
import software.amazon.awssdk.services.qapps.model.DescribeQAppPermissionsResponse;
import software.amazon.awssdk.services.qapps.model.DisassociateLibraryItemReviewRequest;
import software.amazon.awssdk.services.qapps.model.DisassociateLibraryItemReviewResponse;
import software.amazon.awssdk.services.qapps.model.DisassociateQAppFromUserRequest;
import software.amazon.awssdk.services.qapps.model.DisassociateQAppFromUserResponse;
import software.amazon.awssdk.services.qapps.model.ExportQAppSessionDataRequest;
import software.amazon.awssdk.services.qapps.model.ExportQAppSessionDataResponse;
import software.amazon.awssdk.services.qapps.model.GetLibraryItemRequest;
import software.amazon.awssdk.services.qapps.model.GetLibraryItemResponse;
import software.amazon.awssdk.services.qapps.model.GetQAppRequest;
import software.amazon.awssdk.services.qapps.model.GetQAppResponse;
import software.amazon.awssdk.services.qapps.model.GetQAppSessionMetadataRequest;
import software.amazon.awssdk.services.qapps.model.GetQAppSessionMetadataResponse;
import software.amazon.awssdk.services.qapps.model.GetQAppSessionRequest;
import software.amazon.awssdk.services.qapps.model.GetQAppSessionResponse;
import software.amazon.awssdk.services.qapps.model.ImportDocumentRequest;
import software.amazon.awssdk.services.qapps.model.ImportDocumentResponse;
import software.amazon.awssdk.services.qapps.model.ListCategoriesRequest;
import software.amazon.awssdk.services.qapps.model.ListCategoriesResponse;
import software.amazon.awssdk.services.qapps.model.ListLibraryItemsRequest;
import software.amazon.awssdk.services.qapps.model.ListLibraryItemsResponse;
import software.amazon.awssdk.services.qapps.model.ListQAppSessionDataRequest;
import software.amazon.awssdk.services.qapps.model.ListQAppSessionDataResponse;
import software.amazon.awssdk.services.qapps.model.ListQAppsRequest;
import software.amazon.awssdk.services.qapps.model.ListQAppsResponse;
import software.amazon.awssdk.services.qapps.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.qapps.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.qapps.model.PredictQAppRequest;
import software.amazon.awssdk.services.qapps.model.PredictQAppResponse;
import software.amazon.awssdk.services.qapps.model.StartQAppSessionRequest;
import software.amazon.awssdk.services.qapps.model.StartQAppSessionResponse;
import software.amazon.awssdk.services.qapps.model.StopQAppSessionRequest;
import software.amazon.awssdk.services.qapps.model.StopQAppSessionResponse;
import software.amazon.awssdk.services.qapps.model.TagResourceRequest;
import software.amazon.awssdk.services.qapps.model.TagResourceResponse;
import software.amazon.awssdk.services.qapps.model.UntagResourceRequest;
import software.amazon.awssdk.services.qapps.model.UntagResourceResponse;
import software.amazon.awssdk.services.qapps.model.UpdateLibraryItemMetadataRequest;
import software.amazon.awssdk.services.qapps.model.UpdateLibraryItemMetadataResponse;
import software.amazon.awssdk.services.qapps.model.UpdateLibraryItemRequest;
import software.amazon.awssdk.services.qapps.model.UpdateLibraryItemResponse;
import software.amazon.awssdk.services.qapps.model.UpdateQAppPermissionsRequest;
import software.amazon.awssdk.services.qapps.model.UpdateQAppPermissionsResponse;
import software.amazon.awssdk.services.qapps.model.UpdateQAppRequest;
import software.amazon.awssdk.services.qapps.model.UpdateQAppResponse;
import software.amazon.awssdk.services.qapps.model.UpdateQAppSessionMetadataRequest;
import software.amazon.awssdk.services.qapps.model.UpdateQAppSessionMetadataResponse;
import software.amazon.awssdk.services.qapps.model.UpdateQAppSessionRequest;
import software.amazon.awssdk.services.qapps.model.UpdateQAppSessionResponse;
import software.amazon.awssdk.services.qapps.paginators.ListLibraryItemsPublisher;
import software.amazon.awssdk.services.qapps.paginators.ListQAppsPublisher;

/**
 * Service client for accessing QApps asynchronously. This can be created using the static {@link #builder()} method.The
 * asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient} supported in the
 * SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in some cases such
 * as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * The Amazon Q Apps feature capability within Amazon Q Business allows web experience users to create lightweight,
 * purpose-built AI apps to fulfill specific tasks from within their web experience. For example, users can create a Q
 * App that exclusively generates marketing-related content to improve your marketing team's productivity or a Q App for
 * writing customer emails and creating promotional content using a certain style of voice, tone, and branding. For more
 * information on the capabilities, see <a
 * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/deploy-experience-iam-role.html#q-apps-actions">Amazon
 * Q Apps capabilities</a> in the <i>Amazon Q Business User Guide</i>.
 * </p>
 * <p>
 * For an overview of the Amazon Q App APIs, see <a
 * href="https://docs.aws.amazon.com/amazonq/latest/api-reference/API_Operations_QApps.html">Overview of Amazon Q Apps
 * API operations</a>.
 * </p>
 * <p>
 * For information about the IAM access control permissions you need to use the Amazon Q Apps API, see <a
 * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/deploy-experience-iam-role.html"> IAM role for the
 * Amazon Q Business web experience including Amazon Q Apps</a> in the <i>Amazon Q Business User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface QAppsAsyncClient extends AwsClient {
    String SERVICE_NAME = "qapps";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "data.qapps";

    /**
     * <p>
     * Associates a rating or review for a library item with the user submitting the request. This increments the rating
     * count for the specified library item.
     * </p>
     *
     * @param associateLibraryItemReviewRequest
     * @return A Java Future containing the result of the AssociateLibraryItemReview operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ConflictException The requested operation could not be completed due to a conflict with the current
     *         state of the resource.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.AssociateLibraryItemReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/AssociateLibraryItemReview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateLibraryItemReviewResponse> associateLibraryItemReview(
            AssociateLibraryItemReviewRequest associateLibraryItemReviewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a rating or review for a library item with the user submitting the request. This increments the rating
     * count for the specified library item.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateLibraryItemReviewRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateLibraryItemReviewRequest#builder()}
     * </p>
     *
     * @param associateLibraryItemReviewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.AssociateLibraryItemReviewRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateLibraryItemReview operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ConflictException The requested operation could not be completed due to a conflict with the current
     *         state of the resource.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.AssociateLibraryItemReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/AssociateLibraryItemReview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateLibraryItemReviewResponse> associateLibraryItemReview(
            Consumer<AssociateLibraryItemReviewRequest.Builder> associateLibraryItemReviewRequest) {
        return associateLibraryItemReview(AssociateLibraryItemReviewRequest.builder()
                .applyMutation(associateLibraryItemReviewRequest).build());
    }

    /**
     * <p>
     * This operation creates a link between the user's identity calling the operation and a specific Q App. This is
     * useful to mark the Q App as a <i>favorite</i> for the user if the user doesn't own the Amazon Q App so they can
     * still run it and see it in their inventory of Q Apps.
     * </p>
     *
     * @param associateQAppWithUserRequest
     * @return A Java Future containing the result of the AssociateQAppWithUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.AssociateQAppWithUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/AssociateQAppWithUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateQAppWithUserResponse> associateQAppWithUser(
            AssociateQAppWithUserRequest associateQAppWithUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This operation creates a link between the user's identity calling the operation and a specific Q App. This is
     * useful to mark the Q App as a <i>favorite</i> for the user if the user doesn't own the Amazon Q App so they can
     * still run it and see it in their inventory of Q Apps.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateQAppWithUserRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateQAppWithUserRequest#builder()}
     * </p>
     *
     * @param associateQAppWithUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.AssociateQAppWithUserRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateQAppWithUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.AssociateQAppWithUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/AssociateQAppWithUser" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateQAppWithUserResponse> associateQAppWithUser(
            Consumer<AssociateQAppWithUserRequest.Builder> associateQAppWithUserRequest) {
        return associateQAppWithUser(AssociateQAppWithUserRequest.builder().applyMutation(associateQAppWithUserRequest).build());
    }

    /**
     * <p>
     * Creates Categories for the Amazon Q Business application environment instance. Web experience users use
     * Categories to tag and filter library items. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/qapps-custom-labels.html">Custom labels for Amazon
     * Q Apps</a>.
     * </p>
     *
     * @param batchCreateCategoryRequest
     * @return A Java Future containing the result of the BatchCreateCategory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ConflictException The requested operation could not be completed due to a conflict with the current
     *         state of the resource.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.BatchCreateCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/BatchCreateCategory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchCreateCategoryResponse> batchCreateCategory(
            BatchCreateCategoryRequest batchCreateCategoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates Categories for the Amazon Q Business application environment instance. Web experience users use
     * Categories to tag and filter library items. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/qapps-custom-labels.html">Custom labels for Amazon
     * Q Apps</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchCreateCategoryRequest.Builder} avoiding the
     * need to create one manually via {@link BatchCreateCategoryRequest#builder()}
     * </p>
     *
     * @param batchCreateCategoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.BatchCreateCategoryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchCreateCategory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ConflictException The requested operation could not be completed due to a conflict with the current
     *         state of the resource.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.BatchCreateCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/BatchCreateCategory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchCreateCategoryResponse> batchCreateCategory(
            Consumer<BatchCreateCategoryRequest.Builder> batchCreateCategoryRequest) {
        return batchCreateCategory(BatchCreateCategoryRequest.builder().applyMutation(batchCreateCategoryRequest).build());
    }

    /**
     * <p>
     * Deletes Categories for the Amazon Q Business application environment instance. Web experience users use
     * Categories to tag and filter library items. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/qapps-custom-labels.html">Custom labels for Amazon
     * Q Apps</a>.
     * </p>
     *
     * @param batchDeleteCategoryRequest
     * @return A Java Future containing the result of the BatchDeleteCategory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ConflictException The requested operation could not be completed due to a conflict with the current
     *         state of the resource.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.BatchDeleteCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/BatchDeleteCategory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchDeleteCategoryResponse> batchDeleteCategory(
            BatchDeleteCategoryRequest batchDeleteCategoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes Categories for the Amazon Q Business application environment instance. Web experience users use
     * Categories to tag and filter library items. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/qapps-custom-labels.html">Custom labels for Amazon
     * Q Apps</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteCategoryRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDeleteCategoryRequest#builder()}
     * </p>
     *
     * @param batchDeleteCategoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.BatchDeleteCategoryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchDeleteCategory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ConflictException The requested operation could not be completed due to a conflict with the current
     *         state of the resource.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.BatchDeleteCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/BatchDeleteCategory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchDeleteCategoryResponse> batchDeleteCategory(
            Consumer<BatchDeleteCategoryRequest.Builder> batchDeleteCategoryRequest) {
        return batchDeleteCategory(BatchDeleteCategoryRequest.builder().applyMutation(batchDeleteCategoryRequest).build());
    }

    /**
     * <p>
     * Updates Categories for the Amazon Q Business application environment instance. Web experience users use
     * Categories to tag and filter library items. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/qapps-custom-labels.html">Custom labels for Amazon
     * Q Apps</a>.
     * </p>
     *
     * @param batchUpdateCategoryRequest
     * @return A Java Future containing the result of the BatchUpdateCategory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ConflictException The requested operation could not be completed due to a conflict with the current
     *         state of the resource.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.BatchUpdateCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/BatchUpdateCategory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchUpdateCategoryResponse> batchUpdateCategory(
            BatchUpdateCategoryRequest batchUpdateCategoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates Categories for the Amazon Q Business application environment instance. Web experience users use
     * Categories to tag and filter library items. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/qapps-custom-labels.html">Custom labels for Amazon
     * Q Apps</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateCategoryRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUpdateCategoryRequest#builder()}
     * </p>
     *
     * @param batchUpdateCategoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.BatchUpdateCategoryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the BatchUpdateCategory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ConflictException The requested operation could not be completed due to a conflict with the current
     *         state of the resource.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.BatchUpdateCategory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/BatchUpdateCategory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchUpdateCategoryResponse> batchUpdateCategory(
            Consumer<BatchUpdateCategoryRequest.Builder> batchUpdateCategoryRequest) {
        return batchUpdateCategory(BatchUpdateCategoryRequest.builder().applyMutation(batchUpdateCategoryRequest).build());
    }

    /**
     * <p>
     * Creates a new library item for an Amazon Q App, allowing it to be discovered and used by other allowed users.
     * </p>
     *
     * @param createLibraryItemRequest
     * @return A Java Future containing the result of the CreateLibraryItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.CreateLibraryItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/CreateLibraryItem" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLibraryItemResponse> createLibraryItem(CreateLibraryItemRequest createLibraryItemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new library item for an Amazon Q App, allowing it to be discovered and used by other allowed users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLibraryItemRequest.Builder} avoiding the need
     * to create one manually via {@link CreateLibraryItemRequest#builder()}
     * </p>
     *
     * @param createLibraryItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.CreateLibraryItemRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateLibraryItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.CreateLibraryItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/CreateLibraryItem" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateLibraryItemResponse> createLibraryItem(
            Consumer<CreateLibraryItemRequest.Builder> createLibraryItemRequest) {
        return createLibraryItem(CreateLibraryItemRequest.builder().applyMutation(createLibraryItemRequest).build());
    }

    /**
     * <p>
     * Creates a presigned URL for an S3 POST operation to upload a file. You can use this URL to set a default file for
     * a <code>FileUploadCard</code> in a Q App definition or to provide a file for a single Q App run. The
     * <code>scope</code> parameter determines how the file will be used, either at the app definition level or the app
     * session level.
     * </p>
     * <note>
     * <p>
     * The IAM permissions are derived from the <code>qapps:ImportDocument</code> action. For more information on the
     * IAM policy for Amazon Q Apps, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/deploy-q-apps-iam-permissions.html">IAM permissions
     * for using Amazon Q Apps</a>.
     * </p>
     * </note>
     *
     * @param createPresignedUrlRequest
     * @return A Java Future containing the result of the CreatePresignedUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.CreatePresignedUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/CreatePresignedUrl" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePresignedUrlResponse> createPresignedUrl(CreatePresignedUrlRequest createPresignedUrlRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a presigned URL for an S3 POST operation to upload a file. You can use this URL to set a default file for
     * a <code>FileUploadCard</code> in a Q App definition or to provide a file for a single Q App run. The
     * <code>scope</code> parameter determines how the file will be used, either at the app definition level or the app
     * session level.
     * </p>
     * <note>
     * <p>
     * The IAM permissions are derived from the <code>qapps:ImportDocument</code> action. For more information on the
     * IAM policy for Amazon Q Apps, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/deploy-q-apps-iam-permissions.html">IAM permissions
     * for using Amazon Q Apps</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePresignedUrlRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePresignedUrlRequest#builder()}
     * </p>
     *
     * @param createPresignedUrlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.CreatePresignedUrlRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreatePresignedUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.CreatePresignedUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/CreatePresignedUrl" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePresignedUrlResponse> createPresignedUrl(
            Consumer<CreatePresignedUrlRequest.Builder> createPresignedUrlRequest) {
        return createPresignedUrl(CreatePresignedUrlRequest.builder().applyMutation(createPresignedUrlRequest).build());
    }

    /**
     * <p>
     * Creates a new Amazon Q App based on the provided definition. The Q App definition specifies the cards and flow of
     * the Q App. This operation also calculates the dependencies between the cards by inspecting the references in the
     * prompts.
     * </p>
     *
     * @param createQAppRequest
     * @return A Java Future containing the result of the CreateQApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ConflictException The requested operation could not be completed due to a conflict with the current
     *         state of the resource.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ContentTooLargeException The requested operation could not be completed because the content exceeds
     *         the maximum allowed size.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.CreateQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/CreateQApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateQAppResponse> createQApp(CreateQAppRequest createQAppRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Amazon Q App based on the provided definition. The Q App definition specifies the cards and flow of
     * the Q App. This operation also calculates the dependencies between the cards by inspecting the references in the
     * prompts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateQAppRequest.Builder} avoiding the need to
     * create one manually via {@link CreateQAppRequest#builder()}
     * </p>
     *
     * @param createQAppRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.CreateQAppRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateQApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ConflictException The requested operation could not be completed due to a conflict with the current
     *         state of the resource.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ContentTooLargeException The requested operation could not be completed because the content exceeds
     *         the maximum allowed size.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.CreateQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/CreateQApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateQAppResponse> createQApp(Consumer<CreateQAppRequest.Builder> createQAppRequest) {
        return createQApp(CreateQAppRequest.builder().applyMutation(createQAppRequest).build());
    }

    /**
     * <p>
     * Deletes a library item for an Amazon Q App, removing it from the library so it can no longer be discovered or
     * used by other users.
     * </p>
     *
     * @param deleteLibraryItemRequest
     * @return A Java Future containing the result of the DeleteLibraryItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.DeleteLibraryItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DeleteLibraryItem" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLibraryItemResponse> deleteLibraryItem(DeleteLibraryItemRequest deleteLibraryItemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a library item for an Amazon Q App, removing it from the library so it can no longer be discovered or
     * used by other users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLibraryItemRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteLibraryItemRequest#builder()}
     * </p>
     *
     * @param deleteLibraryItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.DeleteLibraryItemRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteLibraryItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.DeleteLibraryItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DeleteLibraryItem" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteLibraryItemResponse> deleteLibraryItem(
            Consumer<DeleteLibraryItemRequest.Builder> deleteLibraryItemRequest) {
        return deleteLibraryItem(DeleteLibraryItemRequest.builder().applyMutation(deleteLibraryItemRequest).build());
    }

    /**
     * <p>
     * Deletes an Amazon Q App owned by the user. If the Q App was previously published to the library, it is also
     * removed from the library.
     * </p>
     *
     * @param deleteQAppRequest
     * @return A Java Future containing the result of the DeleteQApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.DeleteQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DeleteQApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteQAppResponse> deleteQApp(DeleteQAppRequest deleteQAppRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an Amazon Q App owned by the user. If the Q App was previously published to the library, it is also
     * removed from the library.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteQAppRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteQAppRequest#builder()}
     * </p>
     *
     * @param deleteQAppRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.DeleteQAppRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteQApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.DeleteQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DeleteQApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteQAppResponse> deleteQApp(Consumer<DeleteQAppRequest.Builder> deleteQAppRequest) {
        return deleteQApp(DeleteQAppRequest.builder().applyMutation(deleteQAppRequest).build());
    }

    /**
     * <p>
     * Describes read permissions for a Amazon Q App in Amazon Q Business application environment instance.
     * </p>
     *
     * @param describeQAppPermissionsRequest
     * @return A Java Future containing the result of the DescribeQAppPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.DescribeQAppPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DescribeQAppPermissions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeQAppPermissionsResponse> describeQAppPermissions(
            DescribeQAppPermissionsRequest describeQAppPermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes read permissions for a Amazon Q App in Amazon Q Business application environment instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeQAppPermissionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeQAppPermissionsRequest#builder()}
     * </p>
     *
     * @param describeQAppPermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.DescribeQAppPermissionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeQAppPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.DescribeQAppPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DescribeQAppPermissions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeQAppPermissionsResponse> describeQAppPermissions(
            Consumer<DescribeQAppPermissionsRequest.Builder> describeQAppPermissionsRequest) {
        return describeQAppPermissions(DescribeQAppPermissionsRequest.builder().applyMutation(describeQAppPermissionsRequest)
                .build());
    }

    /**
     * <p>
     * Removes a rating or review previously submitted by the user for a library item.
     * </p>
     *
     * @param disassociateLibraryItemReviewRequest
     * @return A Java Future containing the result of the DisassociateLibraryItemReview operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ConflictException The requested operation could not be completed due to a conflict with the current
     *         state of the resource.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.DisassociateLibraryItemReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DisassociateLibraryItemReview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateLibraryItemReviewResponse> disassociateLibraryItemReview(
            DisassociateLibraryItemReviewRequest disassociateLibraryItemReviewRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a rating or review previously submitted by the user for a library item.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateLibraryItemReviewRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateLibraryItemReviewRequest#builder()}
     * </p>
     *
     * @param disassociateLibraryItemReviewRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.DisassociateLibraryItemReviewRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DisassociateLibraryItemReview operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ConflictException The requested operation could not be completed due to a conflict with the current
     *         state of the resource.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.DisassociateLibraryItemReview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DisassociateLibraryItemReview"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateLibraryItemReviewResponse> disassociateLibraryItemReview(
            Consumer<DisassociateLibraryItemReviewRequest.Builder> disassociateLibraryItemReviewRequest) {
        return disassociateLibraryItemReview(DisassociateLibraryItemReviewRequest.builder()
                .applyMutation(disassociateLibraryItemReviewRequest).build());
    }

    /**
     * <p>
     * Disassociates a Q App from a user removing the user's access to run the Q App.
     * </p>
     *
     * @param disassociateQAppFromUserRequest
     * @return A Java Future containing the result of the DisassociateQAppFromUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.DisassociateQAppFromUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DisassociateQAppFromUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateQAppFromUserResponse> disassociateQAppFromUser(
            DisassociateQAppFromUserRequest disassociateQAppFromUserRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a Q App from a user removing the user's access to run the Q App.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateQAppFromUserRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateQAppFromUserRequest#builder()}
     * </p>
     *
     * @param disassociateQAppFromUserRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.DisassociateQAppFromUserRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateQAppFromUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.DisassociateQAppFromUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/DisassociateQAppFromUser"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateQAppFromUserResponse> disassociateQAppFromUser(
            Consumer<DisassociateQAppFromUserRequest.Builder> disassociateQAppFromUserRequest) {
        return disassociateQAppFromUser(DisassociateQAppFromUserRequest.builder().applyMutation(disassociateQAppFromUserRequest)
                .build());
    }

    /**
     * <p>
     * Exports the collected data of a Q App data collection session.
     * </p>
     *
     * @param exportQAppSessionDataRequest
     * @return A Java Future containing the result of the ExportQAppSessionData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ConflictException The requested operation could not be completed due to a conflict with the current
     *         state of the resource.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.ExportQAppSessionData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ExportQAppSessionData" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ExportQAppSessionDataResponse> exportQAppSessionData(
            ExportQAppSessionDataRequest exportQAppSessionDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Exports the collected data of a Q App data collection session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExportQAppSessionDataRequest.Builder} avoiding the
     * need to create one manually via {@link ExportQAppSessionDataRequest#builder()}
     * </p>
     *
     * @param exportQAppSessionDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.ExportQAppSessionDataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ExportQAppSessionData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ConflictException The requested operation could not be completed due to a conflict with the current
     *         state of the resource.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.ExportQAppSessionData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ExportQAppSessionData" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ExportQAppSessionDataResponse> exportQAppSessionData(
            Consumer<ExportQAppSessionDataRequest.Builder> exportQAppSessionDataRequest) {
        return exportQAppSessionData(ExportQAppSessionDataRequest.builder().applyMutation(exportQAppSessionDataRequest).build());
    }

    /**
     * <p>
     * Retrieves details about a library item for an Amazon Q App, including its metadata, categories, ratings, and
     * usage statistics.
     * </p>
     *
     * @param getLibraryItemRequest
     * @return A Java Future containing the result of the GetLibraryItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.GetLibraryItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetLibraryItem" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLibraryItemResponse> getLibraryItem(GetLibraryItemRequest getLibraryItemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about a library item for an Amazon Q App, including its metadata, categories, ratings, and
     * usage statistics.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLibraryItemRequest.Builder} avoiding the need to
     * create one manually via {@link GetLibraryItemRequest#builder()}
     * </p>
     *
     * @param getLibraryItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.GetLibraryItemRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetLibraryItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.GetLibraryItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetLibraryItem" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetLibraryItemResponse> getLibraryItem(Consumer<GetLibraryItemRequest.Builder> getLibraryItemRequest) {
        return getLibraryItem(GetLibraryItemRequest.builder().applyMutation(getLibraryItemRequest).build());
    }

    /**
     * <p>
     * Retrieves the full details of an Q App, including its definition specifying the cards and flow.
     * </p>
     *
     * @param getQAppRequest
     * @return A Java Future containing the result of the GetQApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.GetQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetQApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetQAppResponse> getQApp(GetQAppRequest getQAppRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the full details of an Q App, including its definition specifying the cards and flow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQAppRequest.Builder} avoiding the need to create
     * one manually via {@link GetQAppRequest#builder()}
     * </p>
     *
     * @param getQAppRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.GetQAppRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetQApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.GetQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetQApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetQAppResponse> getQApp(Consumer<GetQAppRequest.Builder> getQAppRequest) {
        return getQApp(GetQAppRequest.builder().applyMutation(getQAppRequest).build());
    }

    /**
     * <p>
     * Retrieves the current state and results for an active session of an Amazon Q App.
     * </p>
     *
     * @param getQAppSessionRequest
     * @return A Java Future containing the result of the GetQAppSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.GetQAppSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetQAppSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetQAppSessionResponse> getQAppSession(GetQAppSessionRequest getQAppSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current state and results for an active session of an Amazon Q App.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQAppSessionRequest.Builder} avoiding the need to
     * create one manually via {@link GetQAppSessionRequest#builder()}
     * </p>
     *
     * @param getQAppSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.GetQAppSessionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetQAppSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.GetQAppSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetQAppSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetQAppSessionResponse> getQAppSession(Consumer<GetQAppSessionRequest.Builder> getQAppSessionRequest) {
        return getQAppSession(GetQAppSessionRequest.builder().applyMutation(getQAppSessionRequest).build());
    }

    /**
     * <p>
     * Retrieves the current configuration of a Q App session.
     * </p>
     *
     * @param getQAppSessionMetadataRequest
     * @return A Java Future containing the result of the GetQAppSessionMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.GetQAppSessionMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetQAppSessionMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetQAppSessionMetadataResponse> getQAppSessionMetadata(
            GetQAppSessionMetadataRequest getQAppSessionMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current configuration of a Q App session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQAppSessionMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link GetQAppSessionMetadataRequest#builder()}
     * </p>
     *
     * @param getQAppSessionMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.GetQAppSessionMetadataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetQAppSessionMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.GetQAppSessionMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/GetQAppSessionMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetQAppSessionMetadataResponse> getQAppSessionMetadata(
            Consumer<GetQAppSessionMetadataRequest.Builder> getQAppSessionMetadataRequest) {
        return getQAppSessionMetadata(GetQAppSessionMetadataRequest.builder().applyMutation(getQAppSessionMetadataRequest)
                .build());
    }

    /**
     * <p>
     * Uploads a file that can then be used either as a default in a <code>FileUploadCard</code> from Q App definition
     * or as a file that is used inside a single Q App run. The purpose of the document is determined by a scope
     * parameter that indicates whether it is at the app definition level or at the app session level.
     * </p>
     *
     * @param importDocumentRequest
     * @return A Java Future containing the result of the ImportDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ContentTooLargeException The requested operation could not be completed because the content exceeds
     *         the maximum allowed size.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.ImportDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ImportDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ImportDocumentResponse> importDocument(ImportDocumentRequest importDocumentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads a file that can then be used either as a default in a <code>FileUploadCard</code> from Q App definition
     * or as a file that is used inside a single Q App run. The purpose of the document is determined by a scope
     * parameter that indicates whether it is at the app definition level or at the app session level.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ImportDocumentRequest.Builder} avoiding the need to
     * create one manually via {@link ImportDocumentRequest#builder()}
     * </p>
     *
     * @param importDocumentRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.ImportDocumentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ImportDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ContentTooLargeException The requested operation could not be completed because the content exceeds
     *         the maximum allowed size.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.ImportDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ImportDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ImportDocumentResponse> importDocument(Consumer<ImportDocumentRequest.Builder> importDocumentRequest) {
        return importDocument(ImportDocumentRequest.builder().applyMutation(importDocumentRequest).build());
    }

    /**
     * <p>
     * Lists the categories of a Amazon Q Business application environment instance. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/qapps-custom-labels.html">Custom labels for Amazon
     * Q Apps</a>.
     * </p>
     *
     * @param listCategoriesRequest
     * @return A Java Future containing the result of the ListCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.ListCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListCategories" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCategoriesResponse> listCategories(ListCategoriesRequest listCategoriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the categories of a Amazon Q Business application environment instance. For more information, see <a
     * href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/qapps-custom-labels.html">Custom labels for Amazon
     * Q Apps</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCategoriesRequest.Builder} avoiding the need to
     * create one manually via {@link ListCategoriesRequest#builder()}
     * </p>
     *
     * @param listCategoriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.ListCategoriesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListCategories operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.ListCategories
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListCategories" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCategoriesResponse> listCategories(Consumer<ListCategoriesRequest.Builder> listCategoriesRequest) {
        return listCategories(ListCategoriesRequest.builder().applyMutation(listCategoriesRequest).build());
    }

    /**
     * <p>
     * Lists the library items for Amazon Q Apps that are published and available for users in your Amazon Web Services
     * account.
     * </p>
     *
     * @param listLibraryItemsRequest
     * @return A Java Future containing the result of the ListLibraryItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.ListLibraryItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListLibraryItems" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLibraryItemsResponse> listLibraryItems(ListLibraryItemsRequest listLibraryItemsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the library items for Amazon Q Apps that are published and available for users in your Amazon Web Services
     * account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLibraryItemsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLibraryItemsRequest#builder()}
     * </p>
     *
     * @param listLibraryItemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.ListLibraryItemsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListLibraryItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.ListLibraryItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListLibraryItems" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListLibraryItemsResponse> listLibraryItems(
            Consumer<ListLibraryItemsRequest.Builder> listLibraryItemsRequest) {
        return listLibraryItems(ListLibraryItemsRequest.builder().applyMutation(listLibraryItemsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLibraryItems(software.amazon.awssdk.services.qapps.model.ListLibraryItemsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qapps.paginators.ListLibraryItemsPublisher publisher = client.listLibraryItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qapps.paginators.ListLibraryItemsPublisher publisher = client.listLibraryItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qapps.model.ListLibraryItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qapps.model.ListLibraryItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLibraryItems(software.amazon.awssdk.services.qapps.model.ListLibraryItemsRequest)} operation.</b>
     * </p>
     *
     * @param listLibraryItemsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.ListLibraryItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListLibraryItems" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLibraryItemsPublisher listLibraryItemsPaginator(ListLibraryItemsRequest listLibraryItemsRequest) {
        return new ListLibraryItemsPublisher(this, listLibraryItemsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLibraryItems(software.amazon.awssdk.services.qapps.model.ListLibraryItemsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qapps.paginators.ListLibraryItemsPublisher publisher = client.listLibraryItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qapps.paginators.ListLibraryItemsPublisher publisher = client.listLibraryItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qapps.model.ListLibraryItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qapps.model.ListLibraryItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLibraryItems(software.amazon.awssdk.services.qapps.model.ListLibraryItemsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLibraryItemsRequest.Builder} avoiding the need
     * to create one manually via {@link ListLibraryItemsRequest#builder()}
     * </p>
     *
     * @param listLibraryItemsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.ListLibraryItemsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.ListLibraryItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListLibraryItems" target="_top">AWS API
     *      Documentation</a>
     */
    default ListLibraryItemsPublisher listLibraryItemsPaginator(Consumer<ListLibraryItemsRequest.Builder> listLibraryItemsRequest) {
        return listLibraryItemsPaginator(ListLibraryItemsRequest.builder().applyMutation(listLibraryItemsRequest).build());
    }

    /**
     * <p>
     * Lists the collected data of a Q App data collection session.
     * </p>
     *
     * @param listQAppSessionDataRequest
     * @return A Java Future containing the result of the ListQAppSessionData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.ListQAppSessionData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListQAppSessionData" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListQAppSessionDataResponse> listQAppSessionData(
            ListQAppSessionDataRequest listQAppSessionDataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the collected data of a Q App data collection session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQAppSessionDataRequest.Builder} avoiding the
     * need to create one manually via {@link ListQAppSessionDataRequest#builder()}
     * </p>
     *
     * @param listQAppSessionDataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.ListQAppSessionDataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListQAppSessionData operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.ListQAppSessionData
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListQAppSessionData" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListQAppSessionDataResponse> listQAppSessionData(
            Consumer<ListQAppSessionDataRequest.Builder> listQAppSessionDataRequest) {
        return listQAppSessionData(ListQAppSessionDataRequest.builder().applyMutation(listQAppSessionDataRequest).build());
    }

    /**
     * <p>
     * Lists the Amazon Q Apps owned by or associated with the user either because they created it or because they used
     * it from the library in the past. The user identity is extracted from the credentials used to invoke this
     * operation..
     * </p>
     *
     * @param listQAppsRequest
     * @return A Java Future containing the result of the ListQApps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.ListQApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListQApps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListQAppsResponse> listQApps(ListQAppsRequest listQAppsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Amazon Q Apps owned by or associated with the user either because they created it or because they used
     * it from the library in the past. The user identity is extracted from the credentials used to invoke this
     * operation..
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQAppsRequest.Builder} avoiding the need to
     * create one manually via {@link ListQAppsRequest#builder()}
     * </p>
     *
     * @param listQAppsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.ListQAppsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListQApps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.ListQApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListQApps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListQAppsResponse> listQApps(Consumer<ListQAppsRequest.Builder> listQAppsRequest) {
        return listQApps(ListQAppsRequest.builder().applyMutation(listQAppsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listQApps(software.amazon.awssdk.services.qapps.model.ListQAppsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qapps.paginators.ListQAppsPublisher publisher = client.listQAppsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qapps.paginators.ListQAppsPublisher publisher = client.listQAppsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qapps.model.ListQAppsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qapps.model.ListQAppsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQApps(software.amazon.awssdk.services.qapps.model.ListQAppsRequest)} operation.</b>
     * </p>
     *
     * @param listQAppsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.ListQApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListQApps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQAppsPublisher listQAppsPaginator(ListQAppsRequest listQAppsRequest) {
        return new ListQAppsPublisher(this, listQAppsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listQApps(software.amazon.awssdk.services.qapps.model.ListQAppsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qapps.paginators.ListQAppsPublisher publisher = client.listQAppsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.qapps.paginators.ListQAppsPublisher publisher = client.listQAppsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.qapps.model.ListQAppsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.qapps.model.ListQAppsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of limit won't limit the number of results you get with the paginator. It
     * only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listQApps(software.amazon.awssdk.services.qapps.model.ListQAppsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQAppsRequest.Builder} avoiding the need to
     * create one manually via {@link ListQAppsRequest#builder()}
     * </p>
     *
     * @param listQAppsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.ListQAppsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.ListQApps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListQApps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQAppsPublisher listQAppsPaginator(Consumer<ListQAppsRequest.Builder> listQAppsRequest) {
        return listQAppsPaginator(ListQAppsRequest.builder().applyMutation(listQAppsRequest).build());
    }

    /**
     * <p>
     * Lists the tags associated with an Amazon Q Apps resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags associated with an Amazon Q Apps resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Generates an Amazon Q App definition based on either a conversation or a problem statement provided as input.The
     * resulting app definition can be used to call <code>CreateQApp</code>. This API doesn't create Amazon Q Apps
     * directly.
     * </p>
     *
     * @param predictQAppRequest
     * @return A Java Future containing the result of the PredictQApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.PredictQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/PredictQApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PredictQAppResponse> predictQApp(PredictQAppRequest predictQAppRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates an Amazon Q App definition based on either a conversation or a problem statement provided as input.The
     * resulting app definition can be used to call <code>CreateQApp</code>. This API doesn't create Amazon Q Apps
     * directly.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PredictQAppRequest.Builder} avoiding the need to
     * create one manually via {@link PredictQAppRequest#builder()}
     * </p>
     *
     * @param predictQAppRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.PredictQAppRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PredictQApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.PredictQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/PredictQApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PredictQAppResponse> predictQApp(Consumer<PredictQAppRequest.Builder> predictQAppRequest) {
        return predictQApp(PredictQAppRequest.builder().applyMutation(predictQAppRequest).build());
    }

    /**
     * <p>
     * Starts a new session for an Amazon Q App, allowing inputs to be provided and the app to be run.
     * </p>
     * <note>
     * <p>
     * Each Q App session will be condensed into a single conversation in the web experience.
     * </p>
     * </note>
     *
     * @param startQAppSessionRequest
     * @return A Java Future containing the result of the StartQAppSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.StartQAppSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/StartQAppSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartQAppSessionResponse> startQAppSession(StartQAppSessionRequest startQAppSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a new session for an Amazon Q App, allowing inputs to be provided and the app to be run.
     * </p>
     * <note>
     * <p>
     * Each Q App session will be condensed into a single conversation in the web experience.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartQAppSessionRequest.Builder} avoiding the need
     * to create one manually via {@link StartQAppSessionRequest#builder()}
     * </p>
     *
     * @param startQAppSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.StartQAppSessionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartQAppSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.StartQAppSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/StartQAppSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartQAppSessionResponse> startQAppSession(
            Consumer<StartQAppSessionRequest.Builder> startQAppSessionRequest) {
        return startQAppSession(StartQAppSessionRequest.builder().applyMutation(startQAppSessionRequest).build());
    }

    /**
     * <p>
     * Stops an active session for an Amazon Q App.This deletes all data related to the session and makes it invalid for
     * future uses. The results of the session will be persisted as part of the conversation.
     * </p>
     *
     * @param stopQAppSessionRequest
     * @return A Java Future containing the result of the StopQAppSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.StopQAppSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/StopQAppSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopQAppSessionResponse> stopQAppSession(StopQAppSessionRequest stopQAppSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops an active session for an Amazon Q App.This deletes all data related to the session and makes it invalid for
     * future uses. The results of the session will be persisted as part of the conversation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopQAppSessionRequest.Builder} avoiding the need
     * to create one manually via {@link StopQAppSessionRequest#builder()}
     * </p>
     *
     * @param stopQAppSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.StopQAppSessionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopQAppSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.StopQAppSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/StopQAppSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopQAppSessionResponse> stopQAppSession(
            Consumer<StopQAppSessionRequest.Builder> stopQAppSessionRequest) {
        return stopQAppSession(StopQAppSessionRequest.builder().applyMutation(stopQAppSessionRequest).build());
    }

    /**
     * <p>
     * Associates tags with an Amazon Q Apps resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ConflictException The requested operation could not be completed due to a conflict with the current
     *         state of the resource.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates tags with an Amazon Q Apps resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ConflictException The requested operation could not be completed due to a conflict with the current
     *         state of the resource.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Disassociates tags from an Amazon Q Apps resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates tags from an Amazon Q Apps resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the library item for an Amazon Q App.
     * </p>
     *
     * @param updateLibraryItemRequest
     * @return A Java Future containing the result of the UpdateLibraryItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ConflictException The requested operation could not be completed due to a conflict with the current
     *         state of the resource.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.UpdateLibraryItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateLibraryItem" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateLibraryItemResponse> updateLibraryItem(UpdateLibraryItemRequest updateLibraryItemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the library item for an Amazon Q App.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLibraryItemRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateLibraryItemRequest#builder()}
     * </p>
     *
     * @param updateLibraryItemRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.UpdateLibraryItemRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateLibraryItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ConflictException The requested operation could not be completed due to a conflict with the current
     *         state of the resource.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.UpdateLibraryItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateLibraryItem" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateLibraryItemResponse> updateLibraryItem(
            Consumer<UpdateLibraryItemRequest.Builder> updateLibraryItemRequest) {
        return updateLibraryItem(UpdateLibraryItemRequest.builder().applyMutation(updateLibraryItemRequest).build());
    }

    /**
     * <p>
     * Updates the verification status of a library item for an Amazon Q App.
     * </p>
     *
     * @param updateLibraryItemMetadataRequest
     * @return A Java Future containing the result of the UpdateLibraryItemMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ConflictException The requested operation could not be completed due to a conflict with the current
     *         state of the resource.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.UpdateLibraryItemMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateLibraryItemMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLibraryItemMetadataResponse> updateLibraryItemMetadata(
            UpdateLibraryItemMetadataRequest updateLibraryItemMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the verification status of a library item for an Amazon Q App.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLibraryItemMetadataRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateLibraryItemMetadataRequest#builder()}
     * </p>
     *
     * @param updateLibraryItemMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.UpdateLibraryItemMetadataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateLibraryItemMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ConflictException The requested operation could not be completed due to a conflict with the current
     *         state of the resource.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.UpdateLibraryItemMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateLibraryItemMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLibraryItemMetadataResponse> updateLibraryItemMetadata(
            Consumer<UpdateLibraryItemMetadataRequest.Builder> updateLibraryItemMetadataRequest) {
        return updateLibraryItemMetadata(UpdateLibraryItemMetadataRequest.builder()
                .applyMutation(updateLibraryItemMetadataRequest).build());
    }

    /**
     * <p>
     * Updates an existing Amazon Q App, allowing modifications to its title, description, and definition.
     * </p>
     *
     * @param updateQAppRequest
     * @return A Java Future containing the result of the UpdateQApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ContentTooLargeException The requested operation could not be completed because the content exceeds
     *         the maximum allowed size.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.UpdateQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateQApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateQAppResponse> updateQApp(UpdateQAppRequest updateQAppRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Amazon Q App, allowing modifications to its title, description, and definition.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQAppRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateQAppRequest#builder()}
     * </p>
     *
     * @param updateQAppRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.UpdateQAppRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateQApp operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ContentTooLargeException The requested operation could not be completed because the content exceeds
     *         the maximum allowed size.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.UpdateQApp
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateQApp" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateQAppResponse> updateQApp(Consumer<UpdateQAppRequest.Builder> updateQAppRequest) {
        return updateQApp(UpdateQAppRequest.builder().applyMutation(updateQAppRequest).build());
    }

    /**
     * <p>
     * Updates read permissions for a Amazon Q App in Amazon Q Business application environment instance.
     * </p>
     *
     * @param updateQAppPermissionsRequest
     * @return A Java Future containing the result of the UpdateQAppPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.UpdateQAppPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateQAppPermissions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateQAppPermissionsResponse> updateQAppPermissions(
            UpdateQAppPermissionsRequest updateQAppPermissionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates read permissions for a Amazon Q App in Amazon Q Business application environment instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQAppPermissionsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateQAppPermissionsRequest#builder()}
     * </p>
     *
     * @param updateQAppPermissionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.UpdateQAppPermissionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateQAppPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.UpdateQAppPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateQAppPermissions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateQAppPermissionsResponse> updateQAppPermissions(
            Consumer<UpdateQAppPermissionsRequest.Builder> updateQAppPermissionsRequest) {
        return updateQAppPermissions(UpdateQAppPermissionsRequest.builder().applyMutation(updateQAppPermissionsRequest).build());
    }

    /**
     * <p>
     * Updates the session for a given Q App <code>sessionId</code>. This is only valid when at least one card of the
     * session is in the <code>WAITING</code> state. Data for each <code>WAITING</code> card can be provided as input.
     * If inputs are not provided, the call will be accepted but session will not move forward. Inputs for cards that
     * are not in the <code>WAITING</code> status will be ignored.
     * </p>
     *
     * @param updateQAppSessionRequest
     * @return A Java Future containing the result of the UpdateQAppSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.UpdateQAppSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateQAppSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateQAppSessionResponse> updateQAppSession(UpdateQAppSessionRequest updateQAppSessionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the session for a given Q App <code>sessionId</code>. This is only valid when at least one card of the
     * session is in the <code>WAITING</code> state. Data for each <code>WAITING</code> card can be provided as input.
     * If inputs are not provided, the call will be accepted but session will not move forward. Inputs for cards that
     * are not in the <code>WAITING</code> status will be ignored.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQAppSessionRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateQAppSessionRequest#builder()}
     * </p>
     *
     * @param updateQAppSessionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.UpdateQAppSessionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateQAppSession operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.UpdateQAppSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateQAppSession" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateQAppSessionResponse> updateQAppSession(
            Consumer<UpdateQAppSessionRequest.Builder> updateQAppSessionRequest) {
        return updateQAppSession(UpdateQAppSessionRequest.builder().applyMutation(updateQAppSessionRequest).build());
    }

    /**
     * <p>
     * Updates the configuration metadata of a session for a given Q App <code>sessionId</code>.
     * </p>
     *
     * @param updateQAppSessionMetadataRequest
     * @return A Java Future containing the result of the UpdateQAppSessionMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.UpdateQAppSessionMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateQAppSessionMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateQAppSessionMetadataResponse> updateQAppSessionMetadata(
            UpdateQAppSessionMetadataRequest updateQAppSessionMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration metadata of a session for a given Q App <code>sessionId</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateQAppSessionMetadataRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateQAppSessionMetadataRequest#builder()}
     * </p>
     *
     * @param updateQAppSessionMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.qapps.model.UpdateQAppSessionMetadataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateQAppSessionMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ResourceNotFoundException The requested resource could not be found.</li>
     *         <li>AccessDeniedException The client is not authorized to perform the requested operation.</li>
     *         <li>ValidationException The input failed to satisfy the constraints specified by the service.</li>
     *         <li>InternalServerException An internal service error occurred while processing the request.</li>
     *         <li>UnauthorizedException The client is not authenticated or authorized to perform the requested
     *         operation.</li>
     *         <li>ServiceQuotaExceededException The requested operation could not be completed because it would exceed
     *         the service's quota or limit.</li>
     *         <li>ThrottlingException The requested operation could not be completed because too many requests were
     *         sent at once. Wait a bit and try again later.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QAppsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QAppsAsyncClient.UpdateQAppSessionMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/qapps-2023-11-27/UpdateQAppSessionMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateQAppSessionMetadataResponse> updateQAppSessionMetadata(
            Consumer<UpdateQAppSessionMetadataRequest.Builder> updateQAppSessionMetadataRequest) {
        return updateQAppSessionMetadata(UpdateQAppSessionMetadataRequest.builder()
                .applyMutation(updateQAppSessionMetadataRequest).build());
    }

    @Override
    default QAppsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link QAppsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static QAppsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link QAppsAsyncClient}.
     */
    static QAppsAsyncClientBuilder builder() {
        return new DefaultQAppsAsyncClientBuilder();
    }
}
