/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qapps.QAppsAsyncClient;
import software.amazon.awssdk.services.qapps.internal.UserAgentUtils;
import software.amazon.awssdk.services.qapps.model.LibraryItemMember;
import software.amazon.awssdk.services.qapps.model.ListLibraryItemsRequest;
import software.amazon.awssdk.services.qapps.model.ListLibraryItemsResponse;

public class ListLibraryItemsPublisher
implements SdkPublisher<ListLibraryItemsResponse> {
    private final QAppsAsyncClient client;
    private final ListLibraryItemsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLibraryItemsPublisher(QAppsAsyncClient client, ListLibraryItemsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLibraryItemsPublisher(QAppsAsyncClient client, ListLibraryItemsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLibraryItemsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLibraryItemsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LibraryItemMember> libraryItems() {
        Function<ListLibraryItemsResponse, Iterator> getIterator = response -> {
            if (response != null && response.libraryItems() != null) {
                return response.libraryItems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLibraryItemsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLibraryItemsResponseFetcher
    implements AsyncPageFetcher<ListLibraryItemsResponse> {
        private ListLibraryItemsResponseFetcher() {
        }

        public boolean hasNextPage(ListLibraryItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLibraryItemsResponse> nextPage(ListLibraryItemsResponse previousPage) {
            if (previousPage == null) {
                return ListLibraryItemsPublisher.this.client.listLibraryItems(ListLibraryItemsPublisher.this.firstRequest);
            }
            return ListLibraryItemsPublisher.this.client.listLibraryItems((ListLibraryItemsRequest)((Object)ListLibraryItemsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

