/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qapps.model.SubmissionMutationKind;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubmissionMutation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubmissionMutation> {
    private static final SdkField<String> SUBMISSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("submissionId").getter(SubmissionMutation.getter(SubmissionMutation::submissionId)).setter(SubmissionMutation.setter(Builder::submissionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submissionId").build()}).build();
    private static final SdkField<String> MUTATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mutationType").getter(SubmissionMutation.getter(SubmissionMutation::mutationTypeAsString)).setter(SubmissionMutation.setter(Builder::mutationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mutationType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBMISSION_ID_FIELD, MUTATION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SubmissionMutation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String submissionId;
    private final String mutationType;

    private SubmissionMutation(BuilderImpl builder) {
        this.submissionId = builder.submissionId;
        this.mutationType = builder.mutationType;
    }

    public final String submissionId() {
        return this.submissionId;
    }

    public final SubmissionMutationKind mutationType() {
        return SubmissionMutationKind.fromValue(this.mutationType);
    }

    public final String mutationTypeAsString() {
        return this.mutationType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.submissionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mutationTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubmissionMutation)) {
            return false;
        }
        SubmissionMutation other = (SubmissionMutation)obj;
        return Objects.equals(this.submissionId(), other.submissionId()) && Objects.equals(this.mutationTypeAsString(), other.mutationTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SubmissionMutation").add("SubmissionId", (Object)this.submissionId()).add("MutationType", (Object)this.mutationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "submissionId": {
                return Optional.ofNullable(clazz.cast(this.submissionId()));
            }
            case "mutationType": {
                return Optional.ofNullable(clazz.cast(this.mutationTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("submissionId", SUBMISSION_ID_FIELD);
        map.put("mutationType", MUTATION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubmissionMutation, T> g) {
        return obj -> g.apply((SubmissionMutation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String submissionId;
        private String mutationType;

        private BuilderImpl() {
        }

        private BuilderImpl(SubmissionMutation model) {
            this.submissionId(model.submissionId);
            this.mutationType(model.mutationType);
        }

        public final String getSubmissionId() {
            return this.submissionId;
        }

        public final void setSubmissionId(String submissionId) {
            this.submissionId = submissionId;
        }

        @Override
        public final Builder submissionId(String submissionId) {
            this.submissionId = submissionId;
            return this;
        }

        public final String getMutationType() {
            return this.mutationType;
        }

        public final void setMutationType(String mutationType) {
            this.mutationType = mutationType;
        }

        @Override
        public final Builder mutationType(String mutationType) {
            this.mutationType = mutationType;
            return this;
        }

        @Override
        public final Builder mutationType(SubmissionMutationKind mutationType) {
            this.mutationType(mutationType == null ? null : mutationType.toString());
            return this;
        }

        public SubmissionMutation build() {
            return new SubmissionMutation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubmissionMutation> {
        public Builder submissionId(String var1);

        public Builder mutationType(String var1);

        public Builder mutationType(SubmissionMutationKind var1);
    }
}

