/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qapps.model.FileUploadCardInput;
import software.amazon.awssdk.services.qapps.model.FormInputCardInput;
import software.amazon.awssdk.services.qapps.model.QPluginCardInput;
import software.amazon.awssdk.services.qapps.model.QQueryCardInput;
import software.amazon.awssdk.services.qapps.model.TextInputCardInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CardInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CardInput> {
    private static final SdkField<TextInputCardInput> TEXT_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("textInput").getter(CardInput.getter(CardInput::textInput)).setter(CardInput.setter(Builder::textInput)).constructor(TextInputCardInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textInput").build()}).build();
    private static final SdkField<QQueryCardInput> Q_QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("qQuery").getter(CardInput.getter(CardInput::qQuery)).setter(CardInput.setter(Builder::qQuery)).constructor(QQueryCardInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qQuery").build()}).build();
    private static final SdkField<QPluginCardInput> Q_PLUGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("qPlugin").getter(CardInput.getter(CardInput::qPlugin)).setter(CardInput.setter(Builder::qPlugin)).constructor(QPluginCardInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qPlugin").build()}).build();
    private static final SdkField<FileUploadCardInput> FILE_UPLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fileUpload").getter(CardInput.getter(CardInput::fileUpload)).setter(CardInput.setter(Builder::fileUpload)).constructor(FileUploadCardInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileUpload").build()}).build();
    private static final SdkField<FormInputCardInput> FORM_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("formInput").getter(CardInput.getter(CardInput::formInput)).setter(CardInput.setter(Builder::formInput)).constructor(FormInputCardInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formInput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_INPUT_FIELD, Q_QUERY_FIELD, Q_PLUGIN_FIELD, FILE_UPLOAD_FIELD, FORM_INPUT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CardInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final TextInputCardInput textInput;
    private final QQueryCardInput qQuery;
    private final QPluginCardInput qPlugin;
    private final FileUploadCardInput fileUpload;
    private final FormInputCardInput formInput;
    private final Type type;

    private CardInput(BuilderImpl builder) {
        this.textInput = builder.textInput;
        this.qQuery = builder.qQuery;
        this.qPlugin = builder.qPlugin;
        this.fileUpload = builder.fileUpload;
        this.formInput = builder.formInput;
        this.type = builder.type;
    }

    public final TextInputCardInput textInput() {
        return this.textInput;
    }

    public final QQueryCardInput qQuery() {
        return this.qQuery;
    }

    public final QPluginCardInput qPlugin() {
        return this.qPlugin;
    }

    public final FileUploadCardInput fileUpload() {
        return this.fileUpload;
    }

    public final FormInputCardInput formInput() {
        return this.formInput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.textInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.qQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.qPlugin());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileUpload());
        hashCode = 31 * hashCode + Objects.hashCode(this.formInput());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CardInput)) {
            return false;
        }
        CardInput other = (CardInput)obj;
        return Objects.equals(this.textInput(), other.textInput()) && Objects.equals(this.qQuery(), other.qQuery()) && Objects.equals(this.qPlugin(), other.qPlugin()) && Objects.equals(this.fileUpload(), other.fileUpload()) && Objects.equals(this.formInput(), other.formInput());
    }

    public final String toString() {
        return ToString.builder((String)"CardInput").add("TextInput", (Object)this.textInput()).add("QQuery", (Object)this.qQuery()).add("QPlugin", (Object)this.qPlugin()).add("FileUpload", (Object)this.fileUpload()).add("FormInput", (Object)this.formInput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "textInput": {
                return Optional.ofNullable(clazz.cast(this.textInput()));
            }
            case "qQuery": {
                return Optional.ofNullable(clazz.cast(this.qQuery()));
            }
            case "qPlugin": {
                return Optional.ofNullable(clazz.cast(this.qPlugin()));
            }
            case "fileUpload": {
                return Optional.ofNullable(clazz.cast(this.fileUpload()));
            }
            case "formInput": {
                return Optional.ofNullable(clazz.cast(this.formInput()));
            }
        }
        return Optional.empty();
    }

    public static CardInput fromTextInput(TextInputCardInput textInput) {
        return (CardInput)CardInput.builder().textInput(textInput).build();
    }

    public static CardInput fromTextInput(Consumer<TextInputCardInput.Builder> textInput) {
        TextInputCardInput.Builder builder = TextInputCardInput.builder();
        textInput.accept(builder);
        return CardInput.fromTextInput((TextInputCardInput)builder.build());
    }

    public static CardInput fromQQuery(QQueryCardInput qQuery) {
        return (CardInput)CardInput.builder().qQuery(qQuery).build();
    }

    public static CardInput fromQQuery(Consumer<QQueryCardInput.Builder> qQuery) {
        QQueryCardInput.Builder builder = QQueryCardInput.builder();
        qQuery.accept(builder);
        return CardInput.fromQQuery((QQueryCardInput)builder.build());
    }

    public static CardInput fromQPlugin(QPluginCardInput qPlugin) {
        return (CardInput)CardInput.builder().qPlugin(qPlugin).build();
    }

    public static CardInput fromQPlugin(Consumer<QPluginCardInput.Builder> qPlugin) {
        QPluginCardInput.Builder builder = QPluginCardInput.builder();
        qPlugin.accept(builder);
        return CardInput.fromQPlugin((QPluginCardInput)builder.build());
    }

    public static CardInput fromFileUpload(FileUploadCardInput fileUpload) {
        return (CardInput)CardInput.builder().fileUpload(fileUpload).build();
    }

    public static CardInput fromFileUpload(Consumer<FileUploadCardInput.Builder> fileUpload) {
        FileUploadCardInput.Builder builder = FileUploadCardInput.builder();
        fileUpload.accept(builder);
        return CardInput.fromFileUpload((FileUploadCardInput)builder.build());
    }

    public static CardInput fromFormInput(FormInputCardInput formInput) {
        return (CardInput)CardInput.builder().formInput(formInput).build();
    }

    public static CardInput fromFormInput(Consumer<FormInputCardInput.Builder> formInput) {
        FormInputCardInput.Builder builder = FormInputCardInput.builder();
        formInput.accept(builder);
        return CardInput.fromFormInput((FormInputCardInput)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("textInput", TEXT_INPUT_FIELD);
        map.put("qQuery", Q_QUERY_FIELD);
        map.put("qPlugin", Q_PLUGIN_FIELD);
        map.put("fileUpload", FILE_UPLOAD_FIELD);
        map.put("formInput", FORM_INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CardInput, T> g) {
        return obj -> g.apply((CardInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        TEXT_INPUT,
        Q_QUERY,
        Q_PLUGIN,
        FILE_UPLOAD,
        FORM_INPUT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private TextInputCardInput textInput;
        private QQueryCardInput qQuery;
        private QPluginCardInput qPlugin;
        private FileUploadCardInput fileUpload;
        private FormInputCardInput formInput;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CardInput model) {
            this.textInput(model.textInput);
            this.qQuery(model.qQuery);
            this.qPlugin(model.qPlugin);
            this.fileUpload(model.fileUpload);
            this.formInput(model.formInput);
        }

        public final TextInputCardInput.Builder getTextInput() {
            return this.textInput != null ? this.textInput.toBuilder() : null;
        }

        public final void setTextInput(TextInputCardInput.BuilderImpl textInput) {
            TextInputCardInput oldValue = this.textInput;
            this.textInput = textInput != null ? textInput.build() : null;
            this.handleUnionValueChange(Type.TEXT_INPUT, oldValue, this.textInput);
        }

        @Override
        public final Builder textInput(TextInputCardInput textInput) {
            TextInputCardInput oldValue = this.textInput;
            this.textInput = textInput;
            this.handleUnionValueChange(Type.TEXT_INPUT, oldValue, this.textInput);
            return this;
        }

        public final QQueryCardInput.Builder getQQuery() {
            return this.qQuery != null ? this.qQuery.toBuilder() : null;
        }

        public final void setQQuery(QQueryCardInput.BuilderImpl qQuery) {
            QQueryCardInput oldValue = this.qQuery;
            this.qQuery = qQuery != null ? qQuery.build() : null;
            this.handleUnionValueChange(Type.Q_QUERY, oldValue, this.qQuery);
        }

        @Override
        public final Builder qQuery(QQueryCardInput qQuery) {
            QQueryCardInput oldValue = this.qQuery;
            this.qQuery = qQuery;
            this.handleUnionValueChange(Type.Q_QUERY, oldValue, this.qQuery);
            return this;
        }

        public final QPluginCardInput.Builder getQPlugin() {
            return this.qPlugin != null ? this.qPlugin.toBuilder() : null;
        }

        public final void setQPlugin(QPluginCardInput.BuilderImpl qPlugin) {
            QPluginCardInput oldValue = this.qPlugin;
            this.qPlugin = qPlugin != null ? qPlugin.build() : null;
            this.handleUnionValueChange(Type.Q_PLUGIN, oldValue, this.qPlugin);
        }

        @Override
        public final Builder qPlugin(QPluginCardInput qPlugin) {
            QPluginCardInput oldValue = this.qPlugin;
            this.qPlugin = qPlugin;
            this.handleUnionValueChange(Type.Q_PLUGIN, oldValue, this.qPlugin);
            return this;
        }

        public final FileUploadCardInput.Builder getFileUpload() {
            return this.fileUpload != null ? this.fileUpload.toBuilder() : null;
        }

        public final void setFileUpload(FileUploadCardInput.BuilderImpl fileUpload) {
            FileUploadCardInput oldValue = this.fileUpload;
            this.fileUpload = fileUpload != null ? fileUpload.build() : null;
            this.handleUnionValueChange(Type.FILE_UPLOAD, oldValue, this.fileUpload);
        }

        @Override
        public final Builder fileUpload(FileUploadCardInput fileUpload) {
            FileUploadCardInput oldValue = this.fileUpload;
            this.fileUpload = fileUpload;
            this.handleUnionValueChange(Type.FILE_UPLOAD, oldValue, this.fileUpload);
            return this;
        }

        public final FormInputCardInput.Builder getFormInput() {
            return this.formInput != null ? this.formInput.toBuilder() : null;
        }

        public final void setFormInput(FormInputCardInput.BuilderImpl formInput) {
            FormInputCardInput oldValue = this.formInput;
            this.formInput = formInput != null ? formInput.build() : null;
            this.handleUnionValueChange(Type.FORM_INPUT, oldValue, this.formInput);
        }

        @Override
        public final Builder formInput(FormInputCardInput formInput) {
            FormInputCardInput oldValue = this.formInput;
            this.formInput = formInput;
            this.handleUnionValueChange(Type.FORM_INPUT, oldValue, this.formInput);
            return this;
        }

        public CardInput build() {
            return new CardInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CardInput> {
        public Builder textInput(TextInputCardInput var1);

        default public Builder textInput(Consumer<TextInputCardInput.Builder> textInput) {
            return this.textInput((TextInputCardInput)((TextInputCardInput.Builder)TextInputCardInput.builder().applyMutation(textInput)).build());
        }

        public Builder qQuery(QQueryCardInput var1);

        default public Builder qQuery(Consumer<QQueryCardInput.Builder> qQuery) {
            return this.qQuery((QQueryCardInput)((QQueryCardInput.Builder)QQueryCardInput.builder().applyMutation(qQuery)).build());
        }

        public Builder qPlugin(QPluginCardInput var1);

        default public Builder qPlugin(Consumer<QPluginCardInput.Builder> qPlugin) {
            return this.qPlugin((QPluginCardInput)((QPluginCardInput.Builder)QPluginCardInput.builder().applyMutation(qPlugin)).build());
        }

        public Builder fileUpload(FileUploadCardInput var1);

        default public Builder fileUpload(Consumer<FileUploadCardInput.Builder> fileUpload) {
            return this.fileUpload((FileUploadCardInput)((FileUploadCardInput.Builder)FileUploadCardInput.builder().applyMutation(fileUpload)).build());
        }

        public Builder formInput(FormInputCardInput var1);

        default public Builder formInput(Consumer<FormInputCardInput.Builder> formInput) {
            return this.formInput((FormInputCardInput)((FormInputCardInput.Builder)FormInputCardInput.builder().applyMutation(formInput)).build());
        }
    }
}

