/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qapps.model.SubmissionMutation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CardValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CardValue> {
    private static final SdkField<String> CARD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cardId").getter(CardValue.getter(CardValue::cardId)).setter(CardValue.setter(Builder::cardId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cardId").build()}).build();
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("value").getter(CardValue.getter(CardValue::value)).setter(CardValue.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<SubmissionMutation> SUBMISSION_MUTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("submissionMutation").getter(CardValue.getter(CardValue::submissionMutation)).setter(CardValue.setter(Builder::submissionMutation)).constructor(SubmissionMutation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submissionMutation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CARD_ID_FIELD, VALUE_FIELD, SUBMISSION_MUTATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CardValue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String cardId;
    private final String value;
    private final SubmissionMutation submissionMutation;

    private CardValue(BuilderImpl builder) {
        this.cardId = builder.cardId;
        this.value = builder.value;
        this.submissionMutation = builder.submissionMutation;
    }

    public final String cardId() {
        return this.cardId;
    }

    public final String value() {
        return this.value;
    }

    public final SubmissionMutation submissionMutation() {
        return this.submissionMutation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.submissionMutation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CardValue)) {
            return false;
        }
        CardValue other = (CardValue)obj;
        return Objects.equals(this.cardId(), other.cardId()) && Objects.equals(this.value(), other.value()) && Objects.equals(this.submissionMutation(), other.submissionMutation());
    }

    public final String toString() {
        return ToString.builder((String)"CardValue").add("CardId", (Object)this.cardId()).add("Value", (Object)this.value()).add("SubmissionMutation", (Object)this.submissionMutation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cardId": {
                return Optional.ofNullable(clazz.cast(this.cardId()));
            }
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "submissionMutation": {
                return Optional.ofNullable(clazz.cast(this.submissionMutation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cardId", CARD_ID_FIELD);
        map.put("value", VALUE_FIELD);
        map.put("submissionMutation", SUBMISSION_MUTATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CardValue, T> g) {
        return obj -> g.apply((CardValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cardId;
        private String value;
        private SubmissionMutation submissionMutation;

        private BuilderImpl() {
        }

        private BuilderImpl(CardValue model) {
            this.cardId(model.cardId);
            this.value(model.value);
            this.submissionMutation(model.submissionMutation);
        }

        public final String getCardId() {
            return this.cardId;
        }

        public final void setCardId(String cardId) {
            this.cardId = cardId;
        }

        @Override
        public final Builder cardId(String cardId) {
            this.cardId = cardId;
            return this;
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final SubmissionMutation.Builder getSubmissionMutation() {
            return this.submissionMutation != null ? this.submissionMutation.toBuilder() : null;
        }

        public final void setSubmissionMutation(SubmissionMutation.BuilderImpl submissionMutation) {
            this.submissionMutation = submissionMutation != null ? submissionMutation.build() : null;
        }

        @Override
        public final Builder submissionMutation(SubmissionMutation submissionMutation) {
            this.submissionMutation = submissionMutation;
            return this;
        }

        public CardValue build() {
            return new CardValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CardValue> {
        public Builder cardId(String var1);

        public Builder value(String var1);

        public Builder submissionMutation(SubmissionMutation var1);

        default public Builder submissionMutation(Consumer<SubmissionMutation.Builder> submissionMutation) {
            return this.submissionMutation((SubmissionMutation)((SubmissionMutation.Builder)SubmissionMutation.builder().applyMutation(submissionMutation)).build());
        }
    }
}

