/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qapps.model.QAppsResponse;
import software.amazon.awssdk.services.qapps.model.SessionSharingConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetQAppSessionMetadataResponse
extends QAppsResponse
implements ToCopyableBuilder<Builder, GetQAppSessionMetadataResponse> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(GetQAppSessionMetadataResponse.getter(GetQAppSessionMetadataResponse::sessionId)).setter(GetQAppSessionMetadataResponse.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()}).build();
    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionArn").getter(GetQAppSessionMetadataResponse.getter(GetQAppSessionMetadataResponse::sessionArn)).setter(GetQAppSessionMetadataResponse.setter(Builder::sessionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionArn").build()}).build();
    private static final SdkField<String> SESSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionName").getter(GetQAppSessionMetadataResponse.getter(GetQAppSessionMetadataResponse::sessionName)).setter(GetQAppSessionMetadataResponse.setter(Builder::sessionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionName").build()}).build();
    private static final SdkField<SessionSharingConfiguration> SHARING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sharingConfiguration").getter(GetQAppSessionMetadataResponse.getter(GetQAppSessionMetadataResponse::sharingConfiguration)).setter(GetQAppSessionMetadataResponse.setter(Builder::sharingConfiguration)).constructor(SessionSharingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharingConfiguration").build()}).build();
    private static final SdkField<Boolean> SESSION_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("sessionOwner").getter(GetQAppSessionMetadataResponse.getter(GetQAppSessionMetadataResponse::sessionOwner)).setter(GetQAppSessionMetadataResponse.setter(Builder::sessionOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionOwner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, SESSION_ARN_FIELD, SESSION_NAME_FIELD, SHARING_CONFIGURATION_FIELD, SESSION_OWNER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetQAppSessionMetadataResponse.memberNameToFieldInitializer();
    private final String sessionId;
    private final String sessionArn;
    private final String sessionName;
    private final SessionSharingConfiguration sharingConfiguration;
    private final Boolean sessionOwner;

    private GetQAppSessionMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.sessionArn = builder.sessionArn;
        this.sessionName = builder.sessionName;
        this.sharingConfiguration = builder.sharingConfiguration;
        this.sessionOwner = builder.sessionOwner;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String sessionArn() {
        return this.sessionArn;
    }

    public final String sessionName() {
        return this.sessionName;
    }

    public final SessionSharingConfiguration sharingConfiguration() {
        return this.sharingConfiguration;
    }

    public final Boolean sessionOwner() {
        return this.sessionOwner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sharingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionOwner());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQAppSessionMetadataResponse)) {
            return false;
        }
        GetQAppSessionMetadataResponse other = (GetQAppSessionMetadataResponse)((Object)obj);
        return Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.sessionArn(), other.sessionArn()) && Objects.equals(this.sessionName(), other.sessionName()) && Objects.equals(this.sharingConfiguration(), other.sharingConfiguration()) && Objects.equals(this.sessionOwner(), other.sessionOwner());
    }

    public final String toString() {
        return ToString.builder((String)"GetQAppSessionMetadataResponse").add("SessionId", (Object)this.sessionId()).add("SessionArn", (Object)this.sessionArn()).add("SessionName", (Object)this.sessionName()).add("SharingConfiguration", (Object)this.sharingConfiguration()).add("SessionOwner", (Object)this.sessionOwner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "sessionArn": {
                return Optional.ofNullable(clazz.cast(this.sessionArn()));
            }
            case "sessionName": {
                return Optional.ofNullable(clazz.cast(this.sessionName()));
            }
            case "sharingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.sharingConfiguration()));
            }
            case "sessionOwner": {
                return Optional.ofNullable(clazz.cast(this.sessionOwner()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("sessionArn", SESSION_ARN_FIELD);
        map.put("sessionName", SESSION_NAME_FIELD);
        map.put("sharingConfiguration", SHARING_CONFIGURATION_FIELD);
        map.put("sessionOwner", SESSION_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetQAppSessionMetadataResponse, T> g) {
        return obj -> g.apply((GetQAppSessionMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QAppsResponse.BuilderImpl
    implements Builder {
        private String sessionId;
        private String sessionArn;
        private String sessionName;
        private SessionSharingConfiguration sharingConfiguration;
        private Boolean sessionOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQAppSessionMetadataResponse model) {
            super(model);
            this.sessionId(model.sessionId);
            this.sessionArn(model.sessionArn);
            this.sessionName(model.sessionName);
            this.sharingConfiguration(model.sharingConfiguration);
            this.sessionOwner(model.sessionOwner);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getSessionArn() {
            return this.sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        public final String getSessionName() {
            return this.sessionName;
        }

        public final void setSessionName(String sessionName) {
            this.sessionName = sessionName;
        }

        @Override
        public final Builder sessionName(String sessionName) {
            this.sessionName = sessionName;
            return this;
        }

        public final SessionSharingConfiguration.Builder getSharingConfiguration() {
            return this.sharingConfiguration != null ? this.sharingConfiguration.toBuilder() : null;
        }

        public final void setSharingConfiguration(SessionSharingConfiguration.BuilderImpl sharingConfiguration) {
            this.sharingConfiguration = sharingConfiguration != null ? sharingConfiguration.build() : null;
        }

        @Override
        public final Builder sharingConfiguration(SessionSharingConfiguration sharingConfiguration) {
            this.sharingConfiguration = sharingConfiguration;
            return this;
        }

        public final Boolean getSessionOwner() {
            return this.sessionOwner;
        }

        public final void setSessionOwner(Boolean sessionOwner) {
            this.sessionOwner = sessionOwner;
        }

        @Override
        public final Builder sessionOwner(Boolean sessionOwner) {
            this.sessionOwner = sessionOwner;
            return this;
        }

        @Override
        public GetQAppSessionMetadataResponse build() {
            return new GetQAppSessionMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QAppsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetQAppSessionMetadataResponse> {
        public Builder sessionId(String var1);

        public Builder sessionArn(String var1);

        public Builder sessionName(String var1);

        public Builder sharingConfiguration(SessionSharingConfiguration var1);

        default public Builder sharingConfiguration(Consumer<SessionSharingConfiguration.Builder> sharingConfiguration) {
            return this.sharingConfiguration((SessionSharingConfiguration)((SessionSharingConfiguration.Builder)SessionSharingConfiguration.builder().applyMutation(sharingConfiguration)).build());
        }

        public Builder sessionOwner(Boolean var1);
    }
}

