/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qapps.model.QAppsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportQAppSessionDataResponse
extends QAppsResponse
implements ToCopyableBuilder<Builder, ExportQAppSessionDataResponse> {
    private static final SdkField<String> CSV_FILE_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("csvFileLink").getter(ExportQAppSessionDataResponse.getter(ExportQAppSessionDataResponse::csvFileLink)).setter(ExportQAppSessionDataResponse.setter(Builder::csvFileLink)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("csvFileLink").build()}).build();
    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expiresAt").getter(ExportQAppSessionDataResponse.getter(ExportQAppSessionDataResponse::expiresAt)).setter(ExportQAppSessionDataResponse.setter(Builder::expiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> SESSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionArn").getter(ExportQAppSessionDataResponse.getter(ExportQAppSessionDataResponse::sessionArn)).setter(ExportQAppSessionDataResponse.setter(Builder::sessionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CSV_FILE_LINK_FIELD, EXPIRES_AT_FIELD, SESSION_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportQAppSessionDataResponse.memberNameToFieldInitializer();
    private final String csvFileLink;
    private final Instant expiresAt;
    private final String sessionArn;

    private ExportQAppSessionDataResponse(BuilderImpl builder) {
        super(builder);
        this.csvFileLink = builder.csvFileLink;
        this.expiresAt = builder.expiresAt;
        this.sessionArn = builder.sessionArn;
    }

    public final String csvFileLink() {
        return this.csvFileLink;
    }

    public final Instant expiresAt() {
        return this.expiresAt;
    }

    public final String sessionArn() {
        return this.sessionArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.csvFileLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportQAppSessionDataResponse)) {
            return false;
        }
        ExportQAppSessionDataResponse other = (ExportQAppSessionDataResponse)((Object)obj);
        return Objects.equals(this.csvFileLink(), other.csvFileLink()) && Objects.equals(this.expiresAt(), other.expiresAt()) && Objects.equals(this.sessionArn(), other.sessionArn());
    }

    public final String toString() {
        return ToString.builder((String)"ExportQAppSessionDataResponse").add("CsvFileLink", (Object)this.csvFileLink()).add("ExpiresAt", (Object)this.expiresAt()).add("SessionArn", (Object)this.sessionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "csvFileLink": {
                return Optional.ofNullable(clazz.cast(this.csvFileLink()));
            }
            case "expiresAt": {
                return Optional.ofNullable(clazz.cast(this.expiresAt()));
            }
            case "sessionArn": {
                return Optional.ofNullable(clazz.cast(this.sessionArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("csvFileLink", CSV_FILE_LINK_FIELD);
        map.put("expiresAt", EXPIRES_AT_FIELD);
        map.put("sessionArn", SESSION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportQAppSessionDataResponse, T> g) {
        return obj -> g.apply((ExportQAppSessionDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QAppsResponse.BuilderImpl
    implements Builder {
        private String csvFileLink;
        private Instant expiresAt;
        private String sessionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportQAppSessionDataResponse model) {
            super(model);
            this.csvFileLink(model.csvFileLink);
            this.expiresAt(model.expiresAt);
            this.sessionArn(model.sessionArn);
        }

        public final String getCsvFileLink() {
            return this.csvFileLink;
        }

        public final void setCsvFileLink(String csvFileLink) {
            this.csvFileLink = csvFileLink;
        }

        @Override
        public final Builder csvFileLink(String csvFileLink) {
            this.csvFileLink = csvFileLink;
            return this;
        }

        public final Instant getExpiresAt() {
            return this.expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final String getSessionArn() {
            return this.sessionArn;
        }

        public final void setSessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
        }

        @Override
        public final Builder sessionArn(String sessionArn) {
            this.sessionArn = sessionArn;
            return this;
        }

        @Override
        public ExportQAppSessionDataResponse build() {
            return new ExportQAppSessionDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QAppsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ExportQAppSessionDataResponse> {
        public Builder csvFileLink(String var1);

        public Builder expiresAt(Instant var1);

        public Builder sessionArn(String var1);
    }
}

