/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qapps.model.CardType;
import software.amazon.awssdk.services.qapps.model.DependencyListCopier;
import software.amazon.awssdk.services.qapps.model.FormInputCardMetadata;
import software.amazon.awssdk.services.qapps.model.InputCardComputeMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FormInputCard
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FormInputCard> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(FormInputCard.getter(FormInputCard::id)).setter(FormInputCard.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(FormInputCard.getter(FormInputCard::title)).setter(FormInputCard.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<List<String>> DEPENDENCIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dependencies").getter(FormInputCard.getter(FormInputCard::dependencies)).setter(FormInputCard.setter(Builder::dependencies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependencies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(FormInputCard.getter(FormInputCard::typeAsString)).setter(FormInputCard.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<FormInputCardMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadata").getter(FormInputCard.getter(FormInputCard::metadata)).setter(FormInputCard.setter(Builder::metadata)).constructor(FormInputCardMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final SdkField<String> COMPUTE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computeMode").getter(FormInputCard.getter(FormInputCard::computeModeAsString)).setter(FormInputCard.setter(Builder::computeMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TITLE_FIELD, DEPENDENCIES_FIELD, TYPE_FIELD, METADATA_FIELD, COMPUTE_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FormInputCard.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String title;
    private final List<String> dependencies;
    private final String type;
    private final FormInputCardMetadata metadata;
    private final String computeMode;

    private FormInputCard(BuilderImpl builder) {
        this.id = builder.id;
        this.title = builder.title;
        this.dependencies = builder.dependencies;
        this.type = builder.type;
        this.metadata = builder.metadata;
        this.computeMode = builder.computeMode;
    }

    public final String id() {
        return this.id;
    }

    public final String title() {
        return this.title;
    }

    public final boolean hasDependencies() {
        return this.dependencies != null && !(this.dependencies instanceof SdkAutoConstructList);
    }

    public final List<String> dependencies() {
        return this.dependencies;
    }

    public final CardType type() {
        return CardType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final FormInputCardMetadata metadata() {
        return this.metadata;
    }

    public final InputCardComputeMode computeMode() {
        return InputCardComputeMode.fromValue(this.computeMode);
    }

    public final String computeModeAsString() {
        return this.computeMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependencies() ? this.dependencies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FormInputCard)) {
            return false;
        }
        FormInputCard other = (FormInputCard)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.title(), other.title()) && this.hasDependencies() == other.hasDependencies() && Objects.equals(this.dependencies(), other.dependencies()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.computeModeAsString(), other.computeModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FormInputCard").add("Id", (Object)this.id()).add("Title", (Object)this.title()).add("Dependencies", this.hasDependencies() ? this.dependencies() : null).add("Type", (Object)this.typeAsString()).add("Metadata", (Object)this.metadata()).add("ComputeMode", (Object)this.computeModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "dependencies": {
                return Optional.ofNullable(clazz.cast(this.dependencies()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "computeMode": {
                return Optional.ofNullable(clazz.cast(this.computeModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("dependencies", DEPENDENCIES_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("computeMode", COMPUTE_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FormInputCard, T> g) {
        return obj -> g.apply((FormInputCard)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String title;
        private List<String> dependencies = DefaultSdkAutoConstructList.getInstance();
        private String type;
        private FormInputCardMetadata metadata;
        private String computeMode;

        private BuilderImpl() {
        }

        private BuilderImpl(FormInputCard model) {
            this.id(model.id);
            this.title(model.title);
            this.dependencies(model.dependencies);
            this.type(model.type);
            this.metadata(model.metadata);
            this.computeMode(model.computeMode);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final Collection<String> getDependencies() {
            if (this.dependencies instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dependencies;
        }

        public final void setDependencies(Collection<String> dependencies) {
            this.dependencies = DependencyListCopier.copy(dependencies);
        }

        @Override
        public final Builder dependencies(Collection<String> dependencies) {
            this.dependencies = DependencyListCopier.copy(dependencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(String ... dependencies) {
            this.dependencies(Arrays.asList(dependencies));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CardType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final FormInputCardMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(FormInputCardMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(FormInputCardMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getComputeMode() {
            return this.computeMode;
        }

        public final void setComputeMode(String computeMode) {
            this.computeMode = computeMode;
        }

        @Override
        public final Builder computeMode(String computeMode) {
            this.computeMode = computeMode;
            return this;
        }

        @Override
        public final Builder computeMode(InputCardComputeMode computeMode) {
            this.computeMode(computeMode == null ? null : computeMode.toString());
            return this;
        }

        public FormInputCard build() {
            return new FormInputCard(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FormInputCard> {
        public Builder id(String var1);

        public Builder title(String var1);

        public Builder dependencies(Collection<String> var1);

        public Builder dependencies(String ... var1);

        public Builder type(String var1);

        public Builder type(CardType var1);

        public Builder metadata(FormInputCardMetadata var1);

        default public Builder metadata(Consumer<FormInputCardMetadata.Builder> metadata) {
            return this.metadata((FormInputCardMetadata)((FormInputCardMetadata.Builder)FormInputCardMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder computeMode(String var1);

        public Builder computeMode(InputCardComputeMode var1);
    }
}

