/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qapps.model.AppRequiredCapabilitiesCopier;
import software.amazon.awssdk.services.qapps.model.AppRequiredCapability;
import software.amazon.awssdk.services.qapps.model.AppStatus;
import software.amazon.awssdk.services.qapps.model.QAppsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateQAppResponse
extends QAppsResponse
implements ToCopyableBuilder<Builder, CreateQAppResponse> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appId").getter(CreateQAppResponse.getter(CreateQAppResponse::appId)).setter(CreateQAppResponse.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appId").build()}).build();
    private static final SdkField<String> APP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("appArn").getter(CreateQAppResponse.getter(CreateQAppResponse::appArn)).setter(CreateQAppResponse.setter(Builder::appArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appArn").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(CreateQAppResponse.getter(CreateQAppResponse::title)).setter(CreateQAppResponse.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateQAppResponse.getter(CreateQAppResponse::description)).setter(CreateQAppResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> INITIAL_PROMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("initialPrompt").getter(CreateQAppResponse.getter(CreateQAppResponse::initialPrompt)).setter(CreateQAppResponse.setter(Builder::initialPrompt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialPrompt").build()}).build();
    private static final SdkField<Integer> APP_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("appVersion").getter(CreateQAppResponse.getter(CreateQAppResponse::appVersion)).setter(CreateQAppResponse.setter(Builder::appVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appVersion").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateQAppResponse.getter(CreateQAppResponse::statusAsString)).setter(CreateQAppResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CreateQAppResponse.getter(CreateQAppResponse::createdAt)).setter(CreateQAppResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(CreateQAppResponse.getter(CreateQAppResponse::createdBy)).setter(CreateQAppResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(CreateQAppResponse.getter(CreateQAppResponse::updatedAt)).setter(CreateQAppResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(CreateQAppResponse.getter(CreateQAppResponse::updatedBy)).setter(CreateQAppResponse.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final SdkField<List<String>> REQUIRED_CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("requiredCapabilities").getter(CreateQAppResponse.getter(CreateQAppResponse::requiredCapabilitiesAsStrings)).setter(CreateQAppResponse.setter(Builder::requiredCapabilitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiredCapabilities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, APP_ARN_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, INITIAL_PROMPT_FIELD, APP_VERSION_FIELD, STATUS_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD, REQUIRED_CAPABILITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("appId", APP_ID_FIELD);
            this.put("appArn", APP_ARN_FIELD);
            this.put("title", TITLE_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("initialPrompt", INITIAL_PROMPT_FIELD);
            this.put("appVersion", APP_VERSION_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("createdBy", CREATED_BY_FIELD);
            this.put("updatedAt", UPDATED_AT_FIELD);
            this.put("updatedBy", UPDATED_BY_FIELD);
            this.put("requiredCapabilities", REQUIRED_CAPABILITIES_FIELD);
        }
    });
    private final String appId;
    private final String appArn;
    private final String title;
    private final String description;
    private final String initialPrompt;
    private final Integer appVersion;
    private final String status;
    private final Instant createdAt;
    private final String createdBy;
    private final Instant updatedAt;
    private final String updatedBy;
    private final List<String> requiredCapabilities;

    private CreateQAppResponse(BuilderImpl builder) {
        super(builder);
        this.appId = builder.appId;
        this.appArn = builder.appArn;
        this.title = builder.title;
        this.description = builder.description;
        this.initialPrompt = builder.initialPrompt;
        this.appVersion = builder.appVersion;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.requiredCapabilities = builder.requiredCapabilities;
    }

    public final String appId() {
        return this.appId;
    }

    public final String appArn() {
        return this.appArn;
    }

    public final String title() {
        return this.title;
    }

    public final String description() {
        return this.description;
    }

    public final String initialPrompt() {
        return this.initialPrompt;
    }

    public final Integer appVersion() {
        return this.appVersion;
    }

    public final AppStatus status() {
        return AppStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public final List<AppRequiredCapability> requiredCapabilities() {
        return AppRequiredCapabilitiesCopier.copyStringToEnum(this.requiredCapabilities);
    }

    public final boolean hasRequiredCapabilities() {
        return this.requiredCapabilities != null && !(this.requiredCapabilities instanceof SdkAutoConstructList);
    }

    public final List<String> requiredCapabilitiesAsStrings() {
        return this.requiredCapabilities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.appArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(this.appVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequiredCapabilities() ? this.requiredCapabilitiesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateQAppResponse)) {
            return false;
        }
        CreateQAppResponse other = (CreateQAppResponse)((Object)obj);
        return Objects.equals(this.appId(), other.appId()) && Objects.equals(this.appArn(), other.appArn()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.initialPrompt(), other.initialPrompt()) && Objects.equals(this.appVersion(), other.appVersion()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy()) && this.hasRequiredCapabilities() == other.hasRequiredCapabilities() && Objects.equals(this.requiredCapabilitiesAsStrings(), other.requiredCapabilitiesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"CreateQAppResponse").add("AppId", (Object)this.appId()).add("AppArn", (Object)this.appArn()).add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("InitialPrompt", (Object)this.initialPrompt()).add("AppVersion", (Object)this.appVersion()).add("Status", (Object)this.statusAsString()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedBy", (Object)this.updatedBy()).add("RequiredCapabilities", this.hasRequiredCapabilities() ? this.requiredCapabilitiesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "appId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "appArn": {
                return Optional.ofNullable(clazz.cast(this.appArn()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "initialPrompt": {
                return Optional.ofNullable(clazz.cast(this.initialPrompt()));
            }
            case "appVersion": {
                return Optional.ofNullable(clazz.cast(this.appVersion()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
            case "requiredCapabilities": {
                return Optional.ofNullable(clazz.cast(this.requiredCapabilitiesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateQAppResponse, T> g) {
        return obj -> g.apply((CreateQAppResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QAppsResponse.BuilderImpl
    implements Builder {
        private String appId;
        private String appArn;
        private String title;
        private String description;
        private String initialPrompt;
        private Integer appVersion;
        private String status;
        private Instant createdAt;
        private String createdBy;
        private Instant updatedAt;
        private String updatedBy;
        private List<String> requiredCapabilities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateQAppResponse model) {
            super(model);
            this.appId(model.appId);
            this.appArn(model.appArn);
            this.title(model.title);
            this.description(model.description);
            this.initialPrompt(model.initialPrompt);
            this.appVersion(model.appVersion);
            this.status(model.status);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
            this.requiredCapabilitiesWithStrings(model.requiredCapabilities);
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final String getAppArn() {
            return this.appArn;
        }

        public final void setAppArn(String appArn) {
            this.appArn = appArn;
        }

        @Override
        public final Builder appArn(String appArn) {
            this.appArn = appArn;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getInitialPrompt() {
            return this.initialPrompt;
        }

        public final void setInitialPrompt(String initialPrompt) {
            this.initialPrompt = initialPrompt;
        }

        @Override
        public final Builder initialPrompt(String initialPrompt) {
            this.initialPrompt = initialPrompt;
            return this;
        }

        public final Integer getAppVersion() {
            return this.appVersion;
        }

        public final void setAppVersion(Integer appVersion) {
            this.appVersion = appVersion;
        }

        @Override
        public final Builder appVersion(Integer appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AppStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final Collection<String> getRequiredCapabilities() {
            if (this.requiredCapabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.requiredCapabilities;
        }

        public final void setRequiredCapabilities(Collection<String> requiredCapabilities) {
            this.requiredCapabilities = AppRequiredCapabilitiesCopier.copy(requiredCapabilities);
        }

        @Override
        public final Builder requiredCapabilitiesWithStrings(Collection<String> requiredCapabilities) {
            this.requiredCapabilities = AppRequiredCapabilitiesCopier.copy(requiredCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredCapabilitiesWithStrings(String ... requiredCapabilities) {
            this.requiredCapabilitiesWithStrings(Arrays.asList(requiredCapabilities));
            return this;
        }

        @Override
        public final Builder requiredCapabilities(Collection<AppRequiredCapability> requiredCapabilities) {
            this.requiredCapabilities = AppRequiredCapabilitiesCopier.copyEnumToString(requiredCapabilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredCapabilities(AppRequiredCapability ... requiredCapabilities) {
            this.requiredCapabilities(Arrays.asList(requiredCapabilities));
            return this;
        }

        @Override
        public CreateQAppResponse build() {
            return new CreateQAppResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends QAppsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateQAppResponse> {
        public Builder appId(String var1);

        public Builder appArn(String var1);

        public Builder title(String var1);

        public Builder description(String var1);

        public Builder initialPrompt(String var1);

        public Builder appVersion(Integer var1);

        public Builder status(String var1);

        public Builder status(AppStatus var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);

        public Builder requiredCapabilitiesWithStrings(Collection<String> var1);

        public Builder requiredCapabilitiesWithStrings(String ... var1);

        public Builder requiredCapabilities(Collection<AppRequiredCapability> var1);

        public Builder requiredCapabilities(AppRequiredCapability ... var1);
    }
}

