/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qapps.model.CardType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TextInputCardInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TextInputCardInput> {
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(TextInputCardInput.getter(TextInputCardInput::title)).setter(TextInputCardInput.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(TextInputCardInput.getter(TextInputCardInput::id)).setter(TextInputCardInput.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(TextInputCardInput.getter(TextInputCardInput::typeAsString)).setter(TextInputCardInput.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> PLACEHOLDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("placeholder").getter(TextInputCardInput.getter(TextInputCardInput::placeholder)).setter(TextInputCardInput.setter(Builder::placeholder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("placeholder").build()}).build();
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultValue").getter(TextInputCardInput.getter(TextInputCardInput::defaultValue)).setter(TextInputCardInput.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, ID_FIELD, TYPE_FIELD, PLACEHOLDER_FIELD, DEFAULT_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("title", TITLE_FIELD);
            this.put("id", ID_FIELD);
            this.put("type", TYPE_FIELD);
            this.put("placeholder", PLACEHOLDER_FIELD);
            this.put("defaultValue", DEFAULT_VALUE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String title;
    private final String id;
    private final String type;
    private final String placeholder;
    private final String defaultValue;

    private TextInputCardInput(BuilderImpl builder) {
        this.title = builder.title;
        this.id = builder.id;
        this.type = builder.type;
        this.placeholder = builder.placeholder;
        this.defaultValue = builder.defaultValue;
    }

    public final String title() {
        return this.title;
    }

    public final String id() {
        return this.id;
    }

    public final CardType type() {
        return CardType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String placeholder() {
        return this.placeholder;
    }

    public final String defaultValue() {
        return this.defaultValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.placeholder());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextInputCardInput)) {
            return false;
        }
        TextInputCardInput other = (TextInputCardInput)obj;
        return Objects.equals(this.title(), other.title()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.placeholder(), other.placeholder()) && Objects.equals(this.defaultValue(), other.defaultValue());
    }

    public final String toString() {
        return ToString.builder((String)"TextInputCardInput").add("Title", (Object)this.title()).add("Id", (Object)this.id()).add("Type", (Object)this.typeAsString()).add("Placeholder", (Object)this.placeholder()).add("DefaultValue", (Object)this.defaultValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "placeholder": {
                return Optional.ofNullable(clazz.cast(this.placeholder()));
            }
            case "defaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TextInputCardInput, T> g) {
        return obj -> g.apply((TextInputCardInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String title;
        private String id;
        private String type;
        private String placeholder;
        private String defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(TextInputCardInput model) {
            this.title(model.title);
            this.id(model.id);
            this.type(model.type);
            this.placeholder(model.placeholder);
            this.defaultValue(model.defaultValue);
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CardType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getPlaceholder() {
            return this.placeholder;
        }

        public final void setPlaceholder(String placeholder) {
            this.placeholder = placeholder;
        }

        @Override
        public final Builder placeholder(String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public TextInputCardInput build() {
            return new TextInputCardInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TextInputCardInput> {
        public Builder title(String var1);

        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(CardType var1);

        public Builder placeholder(String var1);

        public Builder defaultValue(String var1);
    }
}

