/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qapps.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.qapps.QAppsClient;
import software.amazon.awssdk.services.qapps.internal.UserAgentUtils;
import software.amazon.awssdk.services.qapps.model.LibraryItemMember;
import software.amazon.awssdk.services.qapps.model.ListLibraryItemsRequest;
import software.amazon.awssdk.services.qapps.model.ListLibraryItemsResponse;

public class ListLibraryItemsIterable
implements SdkIterable<ListLibraryItemsResponse> {
    private final QAppsClient client;
    private final ListLibraryItemsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLibraryItemsIterable(QAppsClient client, ListLibraryItemsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLibraryItemsResponseFetcher();
    }

    public Iterator<ListLibraryItemsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LibraryItemMember> libraryItems() {
        Function<ListLibraryItemsResponse, Iterator> getIterator = response -> {
            if (response != null && response.libraryItems() != null) {
                return response.libraryItems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLibraryItemsResponseFetcher
    implements SyncPageFetcher<ListLibraryItemsResponse> {
        private ListLibraryItemsResponseFetcher() {
        }

        public boolean hasNextPage(ListLibraryItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLibraryItemsResponse nextPage(ListLibraryItemsResponse previousPage) {
            if (previousPage == null) {
                return ListLibraryItemsIterable.this.client.listLibraryItems(ListLibraryItemsIterable.this.firstRequest);
            }
            return ListLibraryItemsIterable.this.client.listLibraryItems((ListLibraryItemsRequest)((Object)ListLibraryItemsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

